package test.org.itscool.webersample.action;

import java.util.List;

import org.itscool.webersample.action.company.OfficialTitleRegistAction;
import org.itscool.webersample.bean.OfficialTitle;
import org.itscool.webersample.dao.OfficialTitleDao;
import org.itscool.webertest.testcase.WeberDbTestCase;

public class TestOfficialTitleRegistAction extends WeberDbTestCase{
	public void setUp(){
        this.initTables("test-db-data.xml");
		this.clearTables();
    }
    
    public void testDoExcecute(){
    	OfficialTitleRegistAction action = new OfficialTitleRegistAction();
    	OfficialTitle form = new OfficialTitle();
    	form.setName("add");
    	form.setTitleId("0100");
    	
    	request.addParameter("submit_add", "1");
    	
    	assertDoExecute(action, form, "success");
    	assertNotNull(bucket.getAttribute("titleList"));
    }
    
    public void testDoExecute2(){
    	OfficialTitleRegistAction action = new OfficialTitleRegistAction();
    	OfficialTitleDao dao = new OfficialTitleDao();
    	List list = dao.getAllData();
    	if(list.size()>0){
	    	OfficialTitle form = (OfficialTitle)list.get(0);
	    	form.setName("update");
	    	form.setTitleId("0100");
	    	
	    	request.addParameter("submit_edit", "1");
	    	
	    	assertDoExecute(action, form, "success");
	    	assertNotNull(bucket.getAttribute("titleList"));
    	}
    }
    
    public void testDoExecute3(){
    	OfficialTitleRegistAction action = new OfficialTitleRegistAction();
    	OfficialTitleDao dao = new OfficialTitleDao();
    	
    	OfficialTitle form = new OfficialTitle();
    	form.setName("add");
    	form.setTitleId("01033");
    	dao.save(form);
    	 	
    	request.addParameter("submit_delete", "1");
    	
    	assertDoExecute(action, form, "success");
    	assertNotNull(bucket.getAttribute("titleList"));
    }
}
