package test.org.itscool.weber.user;

import java.io.IOException;
import java.util.HashMap;

import junit.framework.TestCase;

import org.itscool.weber.user.RoleFileManager;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserRole;

public class TestRoleFileManager extends TestCase{
	private static boolean init = false;
	public void setUp(){
		if( init ){
			return;
		}
		init = true;
		String rootPath = System.getProperty("user.dir");
    	
    	//RoleFileManager manager = (RoleFileManager)factory.createInstance("RoleManager");
    	RoleFileManager manager = RoleFileManager.getInstance();
    	manager.setRootPath(rootPath);
    	System.out.println(rootPath);
    	HashMap roleDefines = new HashMap();
    	roleDefines.put("guest1", "/j2src/test/test/org/itscool/weber/user/guest1-user.pwd");
    	//roleDefines.put("guest1", "guest1-user.properties");
    	
    	manager.setRoleDefines(roleDefines);
    	try{
    		manager.init();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
	}
	
	public void testMakeUser(){
		UserRole userRole = new UserRole();
		userRole.setName("guest1");
		RoleFileManager manager = RoleFileManager.getInstance();
		
		try{
			manager.init();
			
			User user = new User();
			user.setName("taro");
			user.setPwd("ios");
			
			boolean ret = manager.add("guest1", user);
			assertEquals(ret, true);
			
			User checkUser = manager.getUser("guest1", "taro");
			
			assertNotNull(checkUser);
			assertEquals(user.getName(), checkUser.getName());
			assertEquals(user.getPwd(), checkUser.getPwd());
			manager.delete("guest1", user);
		}catch(IOException ioe){
			ioe.printStackTrace();
			fail(ioe.getMessage());
		}
	}
	
	public void testMakeUserKana(){
		UserRole userRole = new UserRole();
		userRole.setName("guest1");
		RoleFileManager manager = RoleFileManager.getInstance();
		
		try{
			manager.init();
			
			User user = new User();
			user.setName("̂");
			user.setPwd("ios");
			
			boolean ret = manager.add("guest1", user);
			assertEquals(ret, true);
			
			User checkUser = manager.getUser("guest1", "̂");
			
			assertNotNull(checkUser);
			assertEquals(user.getName(), checkUser.getName());
			assertEquals(user.getPwd(), checkUser.getPwd());
			manager.delete("guest1", user);
		}catch(IOException ioe){
			ioe.printStackTrace();
			fail(ioe.getMessage());
		}
	}
	
	public void testIsUser(){
		UserRole userRole = new UserRole();
		userRole.setName("guest1");
		RoleFileManager manager = RoleFileManager.getInstance();
		
		try{
			manager.init();
			
			User user = new User();
			user.setName("̂1");
			user.setPwd("ios");
			
			boolean ret = manager.add("guest1", user);
			assertEquals(ret, true);
			
			//assertEquals(manager.isUserCheck(mappings, user), true);
			
			manager.delete("guest1", user);
		}catch(IOException ioe){
			ioe.printStackTrace();
			fail(ioe.getMessage());
		}
	}
	
	public void testIsUserFailPwd(){
		UserRole userRole = new UserRole();
		userRole.setName("guest1");
		RoleFileManager manager = RoleFileManager.getInstance();
		
		try{
			manager.init();
			
			User user = new User();
			user.setName("̂2");
			user.setPwd("ios");
			
			boolean ret = manager.add("guest1", user);
			assertEquals(ret, true);
			
			//قȂpX[hZbg
			user.setPwd("hogehoge");
			//assertEquals(manager.isUserCheck(mappings, user), false);
			
			manager.delete("guest1", user);
		}catch(IOException ioe){
			ioe.printStackTrace();
			fail(ioe.getMessage());
		}
	}
	
	public void testIsUserFailName(){
		UserRole userRole = new UserRole();
		userRole.setName("guest1");
		RoleFileManager manager = RoleFileManager.getInstance();
		
		try{
			manager.init();
			
			User user = new User();
			user.setName("̂");
			user.setPwd("ios");
			
			boolean ret = manager.add("guest1", user);
			assertEquals(ret, true);
			
			//قȂ閼OZbg
			user.setName("hogehoge");
			//assertEquals(manager.isUserCheck(mappings, user), false);
			
			//OႤ̂ŏȂ
			manager.delete("guest1", user);
			
			//Oɖ߂ăgC
			user.setName("̂");
			//assertEquals(manager.isUserCheck(mappings, user), true);
			
			manager.delete("guest1", user);
			
		}catch(IOException ioe){
			ioe.printStackTrace();
			fail(ioe.getMessage());
		}
	}
}
