package test.org.itscool.commons.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.util.UrlUtil;

public class TestUrlUtil extends TestCase{

    public void testURLMatch(){
        String key="aaa/layout.do";
        String path="aaa/layout.do";
        
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch2(){
        String key="/*.do";
        String path = "/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch3(){
        String key = "/servlet/*.do";
        String path = "/servlet/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch4(){
        String key = "/*/*.do";
        String path = "/servlet/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch5(){
        String key = "/*/*/*.do";
        String path = "/servlet/layout/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch6(){
        String key = "/**/*.do";
        String path = "/servlet/layout/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch7(){
        String key = "/*/servlet/";
        String path = "/aaa/servlet/";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch8(){
        String key = "/**/test/*/servlet/";
        String path = "/aaa/bbb/ccc/ddd/test/once/servlet/";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
    
    public void testURLMatch9(){
        String key = "/**/*/servlet/";
        String path = "/aaa/bbb/ccc/ddd/test/once/servlet/";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, true);
    }
	
    public void testNotURLMatch(){
        String key = "/*.do";
        String path = "/servlet/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, false);
    }
    
    public void testNotURLMatch2(){
        String key = "/*/*.do";
        String path = "/servlet/layout/layout.do";
        boolean ret = UrlUtil.isURLMatch(key, path);
        assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
            ret, false);
    }
    
	public void testNotURLMatch3(){
		String key = "/**/sample.do";
		String path = "/sample.do";
		boolean ret = UrlUtil.isURLMatch(key, path);
		assertEquals("L[ƃpX̕sv key[" + key + "] path[" + path + "]", 
			ret, false);
	}
	public static Test suite() {
		return new TestSuite(TestUrlUtil.class);
	}

}
