package org.itscool.webersample.dao;

import java.util.List;

import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.commons.dao.FieldMap;
import org.itscool.webersample.bean.OfficialTitle;

/**
 * Ef[^ANZXNX
*/
public class OfficialTitleDao extends BaseDao{
	public OfficialTitle getTitle(int id){
		Criteria crt = new Criteria(OfficialTitle.class);
		crt.eq(OfficialTitle.TABLE+"."+OfficialTitle.PK_COLUM_id, id);
		List list = select(crt);
		if(list.size()>0){
			return (OfficialTitle)list.get(0);
		}else{
			return null;
		}
	}
	
	/**
	 * w肳ꂽɍvE擾܂
	 * @param primaryId 
	 * @return E
	 */
	public OfficialTitle getOfficialTitle(int primaryId){
	    Criteria crt = new Criteria(OfficialTitle.class);
	    String columName = FieldMap.convColumWithTableName(OfficialTitle.TABLE, OfficialTitle.PK_COLUM_id);
	    crt.eq(columName, primaryId);
	    List result = select(crt);
	    if( result.size() > 0){
	    	return (OfficialTitle)result.get(0);
	    }else{
	    	return null;
	    }
		//return find(searchItem, searchKey, OfficialTitle.class);
	}
	
	/**
	 * ES擾܂
	 * @return ẼXg
	 */
	public List getAllData(){
	    Criteria crt = new Criteria(OfficialTitle.class);
	    return select(crt);
		//return this.getAllData(OfficialTitle.class);
	}
	
	/**
	 * Eo^܂
	 * @param worker E
	 * @return o^ID
	 */
    public void save(OfficialTitle title){
        Criteria crt = new Criteria(OfficialTitle.class);
		int id = getNewIdFromAutoNumber(OfficialTitle.TABLE);
		title.setId(id);
		this.insert(crt, title);
    }
    
    /**
	 * EXV܂
	 * @param worker E
	 */
    public void update(OfficialTitle title){
        Criteria crt = new Criteria(OfficialTitle.class);
        crt.eq(OfficialTitle.TABLE + "." + OfficialTitle.PK_COLUM_id, title.getId());
        
		this.update(crt, title);
    }
    
    /**
	 * E폜܂
	 * @param worker E
	 */
    public void delete(OfficialTitle title){
		Criteria crt = new Criteria(OfficialTitle.class);
		crt.eq(OfficialTitle.TABLE + "." + OfficialTitle.PK_COLUM_id, title.getId());
		this.delete(crt);
	}
}
