/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.user;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.file.Log;
import org.itscool.commons.util.AngouUtil;
import org.itscool.commons.util.StringUtil;
import org.itscool.weber.user.RoleManager;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;
import org.itscool.weber.user.UserRole;
import org.itscool.weber.user.UserRoleDao;

public class RoleDbManager
implements RoleManager {
    private Log log = Log.getInstance();
    private static RoleDbManager instance = null;
    static /* synthetic */ Class class$0;

    public static RoleDbManager getInstance() {
        if (instance == null) {
            instance = new RoleDbManager();
        }
        return instance;
    }

    private RoleDbManager() {
    }

    public void init() {
    }

    public boolean isUserCheck(HashMap roles, User user) {
        if (user == null) {
            return false;
        }
        if (roles == null || roles.size() == 0) {
            return this.isRoles(user);
        }
        return this.isRoles(roles, user);
    }

    private boolean isRoles(HashMap roles, User user) {
        boolean ret = false;
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        UserDao dao = new UserDao();
        while (it.hasNext()) {
            String userName;
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            User dbUser = dao.getUser(roleName, userName = user.getName());
            ret = this.isRole(user, dbUser);
            if (!ret) continue;
            user.setRole(dbUser.getRole());
            return ret;
        }
        return ret;
    }

    private boolean isRoles(User user) {
        boolean ret = false;
        UserDao dao = new UserDao();
        List users = dao.getUsers(user.getName());
        int i = 0;
        while (i < users.size()) {
            User dbUser = (User)users.get(i);
            ret = this.isRole(user, dbUser);
            if (ret) {
                UserRole userRole = dbUser.getRole();
                user.setRole(userRole);
                return ret;
            }
            ++i;
        }
        return ret;
    }

    private boolean isRole(User loginUser, User dbUser) {
        if (dbUser == null) {
            return false;
        }
        if (loginUser == null) {
            return false;
        }
        if (!dbUser.getName().equals(loginUser.getName())) {
            return false;
        }
        String pwd = "";
        try {
            byte[] pwdBytes = StringUtil.decodeHex((String)dbUser.getPwd(), (String)"ISO-8859-1");
            pwd = AngouUtil.decrypt((String)dbUser.getName(), (byte[])pwdBytes);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        if (!pwd.equals(loginUser.getPwd())) {
            return false;
        }
        loginUser.setId(dbUser.getId());
        return true;
    }

    public void reload() {
    }

    public List getAllData() {
        UserDao userDao = new UserDao();
        List users = userDao.getAllData();
        int i = 0;
        while (i < users.size()) {
            User user = (User)users.get(i);
            if (user != null) {
                String pwd = "";
                try {
                    byte[] pwdBytes = StringUtil.decodeHex((String)user.getPwd(), (String)"ISO-8859-1");
                    pwd = AngouUtil.decrypt((String)user.getName(), (byte[])pwdBytes);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage());
                }
                user.setPwd(pwd);
            }
            ++i;
        }
        return users;
    }

    public User getUser(String roleName, String userName) {
        UserRoleDao dao = new UserRoleDao();
        UserRole role = dao.getRole(roleName);
        if (role != null) {
            UserDao userDao = new UserDao();
            User user = userDao.getUser(role, userName);
            if (user != null) {
                String pwd = "";
                try {
                    byte[] pwdBytes = StringUtil.decodeHex((String)user.getPwd(), (String)"ISO-8859-1");
                    pwd = AngouUtil.decrypt((String)user.getName(), (byte[])pwdBytes);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage());
                }
                user.setPwd(pwd);
            }
            return user;
        }
        return null;
    }

    public HashMap getUsers(String roleName) {
        HashMap<String, User> users = new HashMap<String, User>();
        UserRoleDao roleDao = new UserRoleDao();
        UserRole role = roleDao.getRole(roleName);
        UserDao dao = new UserDao();
        List lst = dao.getUsers(role);
        int i = 0;
        while (i < lst.size()) {
            User user = (User)lst.get(i);
            String pwd = "";
            try {
                byte[] pwdBytes = StringUtil.decodeHex((String)user.getPwd(), (String)"ISO-8859-1");
                pwd = AngouUtil.decrypt((String)user.getName(), (byte[])pwdBytes);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
            user.setPwd(pwd);
            users.put(user.getName(), user);
            ++i;
        }
        return users;
    }

    public void delete(String roleName, User user) throws IOException {
        UserDao dao = new UserDao();
        if (user.getRoleId() == -1) {
            UserRoleDao roleDao = new UserRoleDao();
            UserRole role = roleDao.getRole(roleName);
            user.setRoleId(role.getId());
        }
        dao.delete(user);
    }

    public void delete(String roleName, String name) throws IOException {
        User user = new User();
        user.setName(name);
        this.delete(roleName, user);
    }

    public boolean add(String roleName, User user) throws IOException {
        BaseDao dao;
        if (user.getRoleId() == -1) {
            dao = new UserRoleDao();
            UserRole role = dao.getRole(roleName);
            if (role == null) {
                return false;
            }
            user.setRoleId(role.getId());
        }
        dao = new UserDao();
        if (this.getUser(roleName, user.getName()) == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.itscool.weber.user.User");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            User newUser = (User)BeanUtil.copyInstance((Object)user, (String)clazz.getName());
            byte[] pwdAngou = AngouUtil.encrypt((String)user.getName(), (String)user.getPwd());
            String pwdAngouStr = StringUtil.encodeHex((byte[])pwdAngou, (String)"ISO-8859-1");
            newUser.setPwd(pwdAngouStr);
            int id = dao.save(newUser);
            user.setId(id);
            return true;
        }
        return false;
    }

    public boolean add(String roleName, String name, String pwd) throws IOException {
        User user = new User();
        user.setName(name);
        user.setPwd(pwd);
        return this.add(roleName, user);
    }

    public void update(String roleName, User user) throws IOException {
        UserRoleDao roleDao = new UserRoleDao();
        UserRole role = roleDao.getRole(roleName);
        user.setId(role.getId());
        UserDao dao = new UserDao();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.itscool.weber.user.User");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        User newUser = (User)BeanUtil.copyInstance((Object)user, (String)clazz.getName());
        byte[] pwdAngou = AngouUtil.encrypt((String)user.getName(), (String)user.getPwd());
        String pwdAngouStr = StringUtil.encodeHex((byte[])pwdAngou, (String)"ISO-8859-1");
        newUser.setPwd(pwdAngouStr);
        dao.update(newUser);
    }

    public boolean addRole(UserRole role) {
        UserRoleDao roleDao = new UserRoleDao();
        if (roleDao.getRole(role.getName()) != null) {
            return false;
        }
        roleDao.save(role);
        return true;
    }

    public boolean deleteRole(UserRole role) {
        UserRoleDao roleDao = new UserRoleDao();
        UserDao userDao = new UserDao();
        if (userDao.getUsers(role).size() > 0) {
            return false;
        }
        roleDao.delete(role);
        return true;
    }
}

