/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.io;

import java.io.IOException;
import java.util.HashMap;
import org.itscool.commons.file.ConfigReader;
import org.itscool.weber.mapping.ActionMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionConfigReader
extends ConfigReader {
    protected void doCreate(HashMap hashMap) throws IOException {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at itscool-config.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList mappingsList = root.getElementsByTagName("action-mappings");
        if (mappingsList == null) {
            String err = "Can not element at <action-maggpins>(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        Node mappings = mappingsList.item(0);
        if (mappings != null) {
            this.createMappings(mappings, hashMap);
        }
    }

    protected void createMappings(Node mappings, HashMap hashMap) throws IOException {
        NodeList mappingsChilds = mappings.getChildNodes();
        int i = 0;
        while (i < mappingsChilds.getLength()) {
            Node action = mappingsChilds.item(i);
            if (action.getNodeName().equals("action")) {
                this.createAction(action, hashMap);
            }
            ++i;
        }
    }

    protected void createAction(Node action, HashMap hashMap) throws IOException {
        NamedNodeMap attributes = action.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node type = attributes.getNamedItem("type");
        Node name = attributes.getNamedItem("name");
        if (path == null || path.getNodeName().length() == 0) {
            throw new IOException("action tag's path is null");
        }
        if (type == null || type.getNodeName().length() == 0) {
            throw new IOException("action tag's type is null");
        }
        String nameStr = null;
        if (name != null) {
            nameStr = name.getNodeValue();
        }
        ActionMapping actionMapping = new ActionMapping(path.getNodeValue(), type.getNodeValue(), nameStr);
        NodeList childs = action.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeName().equals("forward")) {
                this.createForward(child, actionMapping);
            } else if (child.getNodeName().equals("role")) {
                this.createRole(child, actionMapping);
            }
            ++i;
        }
        hashMap.put(actionMapping.getPath(), actionMapping);
    }

    protected void createForward(Node forward, ActionMapping actionMapping) throws IOException {
        NamedNodeMap attributes = forward.getAttributes();
        Node path = attributes.getNamedItem("path");
        Node name = attributes.getNamedItem("name");
        if (path == null || path.getNodeName().length() == 0) {
            throw new IOException("forward tag's path is null.");
        }
        if (name == null || name.getNodeName().length() == 0) {
            throw new IOException("forward tag's name is null.");
        }
        actionMapping.addForward(name.getNodeValue(), path.getNodeValue());
    }

    protected void createRole(Node role, ActionMapping actionMapping) throws IOException {
        NamedNodeMap attributes = role.getAttributes();
        Node name = attributes.getNamedItem("name");
        if (name == null || name.getNodeName().length() == 0) {
            throw new IOException("role tag's name is null.");
        }
        String roleName = name.getNodeValue();
        actionMapping.addRole(roleName);
    }
}

