/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.action;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.request.GeneralForm;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.FrontServlet;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.RoleManager;
import org.itscool.weber.user.User;

public abstract class Action {
    private HashMap lnkForwards;
    private ActionBucket bucket;
    private GeneralForm generalForm = null;
    private HashMap errList = new HashMap();

    public String getForward(String name) {
        return (String)this.lnkForwards.get(name);
    }

    public void setForwards(HashMap forwards) {
        this.lnkForwards = forwards;
    }

    public void setGeneralForm(GeneralForm generalForm) {
        this.generalForm = generalForm;
    }

    public void init(FrontServlet lnkServlet, HttpServletRequest request, HttpServletResponse response, Object bean, HashMap roles, GeneralForm generalForm) {
        ActionBucket bucket = new ActionBucket();
        bucket.setServlet(lnkServlet);
        bucket.setRequest(request);
        bucket.setResponse(response);
        bucket.setForm(bean);
        bucket.setRoles(roles);
        this.bucket = bucket;
        this.setGeneralForm(generalForm);
    }

    public String execute() throws Exception {
        if (!this.checkUserRole(this.bucket)) {
            return this.doAuthFailure(this.bucket);
        }
        String ret = this.validate(this.bucket);
        if (!ret.equals("success")) {
            this.bucket.setRetryInputParam(this.generalForm);
            return ret;
        }
        return this.doExecute(this.bucket);
    }

    public boolean checkUserRole(ActionBucket bucket) {
        boolean ret = true;
        if (bucket.getRoles() == null || bucket.getRoles().size() == 0) {
            return true;
        }
        User user = (User)bucket.getAttributeFromSession("org.itscool.weber.action.USER");
        ret = user == null ? false : this.isUserCheck(bucket.getRoles(), user);
        return ret;
    }

    public String validate(ActionBucket bucket) throws Exception {
        this.doValidate(bucket);
        if (this.isInputError()) {
            bucket.setAttribute("org.itscool.weber.action.INPUT_ERROR", this.errList);
            return this.doInputFailure(bucket);
        }
        return "success";
    }

    public abstract String doExecute(ActionBucket var1) throws Exception;

    protected void doValidate() throws Exception {
    }

    protected void doValidate(ActionBucket bucket) throws Exception {
        this.doValidate();
    }

    protected String doAuthFailure(ActionBucket bucket) {
        return "org.itscool.weber.action.ROLE_FAIL";
    }

    protected String doInputFailure(ActionBucket bucket) {
        return "org.itscool.weber.action.INPUT_ERROR";
    }

    public boolean isUserCheck(HashMap roles, User user) {
        boolean ret = false;
        BeanFactory factory = BeanFactory.getInstance();
        RoleManager manager = (RoleManager)factory.createInstance("RoleManager");
        ret = manager.isUserCheck(roles, user);
        return ret;
    }

    protected void putMessage(Object key, Object msg) {
        this.errList.put(key, msg);
    }

    protected void putMessage(Object key) {
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        this.putMessage(key, message);
    }

    public boolean isInputError() {
        boolean ret = false;
        if (this.errList.size() > 0) {
            ret = true;
        }
        return ret;
    }

    protected boolean isInt(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Integer.parseInt(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isLong(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Long.parseLong(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isDouble(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Double.parseDouble(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isFloat(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Float.parseFloat(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isShort(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Short.parseShort(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isNotNull(String paramName) {
        boolean ret = true;
        try {
            Object paramValue = this.getParameter(paramName);
            if (paramValue == null || paramValue.toString().length() == 0) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected Object getParameter(String paramName) {
        Object result = null;
        Object obj = this.generalForm.getParameter(paramName);
        return obj;
    }
}

