/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

public class NumberFormatUtil {
    public static String encodeMoneyString(String numStr) {
        if (numStr == null || numStr.toString().length() == 0) {
            return numStr;
        }
        try {
            int pointIndex = numStr.indexOf(".");
            String bodyStr = "";
            String pointStr = "";
            if (pointIndex != -1) {
                pointStr = numStr.substring(pointIndex + 1, numStr.length());
                bodyStr = numStr.substring(0, pointIndex);
            } else {
                bodyStr = numStr;
            }
            Integer.parseInt(bodyStr);
            if (bodyStr.length() <= 3) {
                return "\\" + numStr;
            }
            int bodyLen = bodyStr.length();
            String newStr = bodyStr.substring(bodyLen - 3, bodyLen);
            bodyStr = bodyStr.substring(0, bodyLen - 3);
            while (bodyLen > 4) {
                bodyLen = bodyStr.length();
                String next = bodyStr.substring(bodyLen - 3, bodyLen);
                bodyStr = bodyStr.substring(0, bodyLen - 3);
                newStr = String.valueOf(next) + "," + newStr;
            }
            if (bodyStr.length() > 0) {
                newStr = String.valueOf(bodyStr) + "," + newStr;
            }
            return "\\" + newStr;
        }
        catch (NumberFormatException e) {
            return numStr;
        }
    }

    public static String decodeMoneyString(String enNumStr) {
        if (enNumStr == null || enNumStr.length() == 0) {
            return enNumStr;
        }
        if (enNumStr.substring(0, 1).equals("\\")) {
            enNumStr = enNumStr.substring(1, enNumStr.length());
            enNumStr = enNumStr.replaceAll(",", "");
        }
        return enNumStr;
    }

    public static boolean isNumber(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(str);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    public static String convZeroPadding(int num, int keta) {
        String numStr = String.valueOf(num);
        int numLen = numStr.length();
        if (numLen >= keta) {
            return numStr;
        }
        int i = 0;
        while (i < keta - numLen) {
            numStr = "0" + numStr;
            ++i;
        }
        return numStr;
    }

    public static void main(String[] argv) {
        System.out.println(NumberFormatUtil.encodeMoneyString("10.1"));
        System.out.println(NumberFormatUtil.encodeMoneyString("1.2"));
        System.out.println(NumberFormatUtil.encodeMoneyString("aaa"));
        System.out.println(NumberFormatUtil.encodeMoneyString(null));
        System.out.println(NumberFormatUtil.encodeMoneyString("1234"));
        System.out.println(NumberFormatUtil.encodeMoneyString("123456789"));
        System.out.println(NumberFormatUtil.encodeMoneyString("123456789.1234567"));
        System.out.println(NumberFormatUtil.decodeMoneyString("\\9,999"));
        System.out.println(NumberFormatUtil.decodeMoneyString("\\9,999,999,999.999"));
        System.out.println(NumberFormatUtil.convZeroPadding(100, 4));
        System.out.println(NumberFormatUtil.convZeroPadding(100, 10));
        System.out.println(NumberFormatUtil.convZeroPadding(100, 2));
    }
}

