/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.daotool.data;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.itscool.commons.daotool.MappingToolException;
import org.itscool.commons.daotool.data.CellUtil;
import org.itscool.commons.daotool.data.DbProperty;
import org.itscool.commons.daotool.data.DbPropertyList;

public class DbPropertyReader {
    private HashMap tableMap = new HashMap();
    private int startClassRow = 0;
    private int startNoteRow = 1;
    private int startTableRow = 2;
    private int startInfoRow = 3;
    private int startParamRow = 6;

    public HashMap create(String path, int sheetNo) throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        HSSFWorkbook workbook = new HSSFWorkbook(fs);
        if (this.tableMap.size() > 0) {
            this.tableMap.clear();
        }
        int sheetNum = workbook.getNumberOfSheets();
        int i = sheetNo;
        while (i < sheetNum) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            if (sheet.getLastRowNum() != 0) {
                DbPropertyList propertyMap = this.createpropertyMap(sheet, i);
                this.tableMap.put(propertyMap.getTableName(), propertyMap);
            }
            ++i;
        }
        Set keySet = this.tableMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            DbPropertyList propertyList = (DbPropertyList)this.tableMap.get(key);
            String tableName = propertyList.getTableName();
            System.out.println("\n");
            System.out.println("====================================================================================================================");
            System.out.println("\u3010" + tableName + "\u306e\u30c6\u30fc\u30d6\u30eb\u60c5\u5831 \u3011\n");
            System.out.println(propertyList.toString());
            Set propertyKeySet = propertyList.keySet();
            Iterator propertyIt = propertyKeySet.iterator();
            System.out.println("[\u30d7\u30ed\u30d1\u30c6\u30a3\u60c5\u5831]");
            while (propertyIt.hasNext()) {
                Object propertyKey = propertyIt.next();
                DbProperty property = (DbProperty)propertyList.get(propertyKey);
                String fkTableName = property.getForeignTable();
                String fkFieldName = property.getForeignKey();
                String fkPropertyName = property.getForeignPropertyName();
                System.out.println("Property " + property.toString());
                if (fkTableName == null || fkTableName.length() <= 0) continue;
                DbPropertyList fkPropertyList = (DbPropertyList)this.tableMap.get(fkTableName);
                if (fkPropertyList == null) {
                    String err = "\u30c6\u30fc\u30d6\u30eb\u60c5\u5831[" + tableName + "]\u306b\u5b9a\u7fa9\u3055\u308c\u305f\u5916\u90e8\u53c2\u7167\u60c5\u5831[" + fkTableName + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f";
                    throw new NullPointerException(err);
                }
                String propertyName = property.getPropertyName();
                System.out.print("  [" + propertyName + "\u306e\u5916\u90e8\u53c2\u7167\u60c5\u5831] [" + fkTableName + "][" + fkFieldName + "]");
                System.out.print(" pkg:" + fkPropertyList.getPkgName());
                System.out.print(" class:" + fkPropertyList.getClassName());
                System.out.print(" fkProperty:" + fkPropertyName);
                System.out.println(" property:" + propertyName);
                DbPropertyList newFkPropertyList = propertyList.getFkPropertyList(fkTableName);
                if (newFkPropertyList == null) {
                    newFkPropertyList = new DbPropertyList();
                    newFkPropertyList.setPkgName(fkPropertyList.getPkgName());
                    newFkPropertyList.setClassName(fkPropertyList.getClassName());
                    newFkPropertyList.setAuthor(fkPropertyList.getAuthor());
                    newFkPropertyList.setTableName(fkPropertyList.getTableName());
                    newFkPropertyList.setRefName(fkPropertyName);
                    propertyList.addFkPropertyList(newFkPropertyList);
                }
                DbProperty newFkProperty = new DbProperty();
                newFkProperty.setFieldName(fkFieldName);
                newFkProperty.setPropertyName(propertyName);
                newFkProperty.setForeignPropertyName(fkPropertyName);
                newFkPropertyList.addProperty(fkFieldName, newFkProperty);
            }
        }
        return this.tableMap;
    }

    public DbPropertyList createpropertyMap(HSSFSheet sheet, int sheetNo) {
        HSSFRow row0 = sheet.getRow(this.startClassRow);
        HSSFCell pkgCell = row0.getCell((short)1);
        HSSFCell clazzCell = row0.getCell((short)9);
        HSSFRow row1 = sheet.getRow(this.startNoteRow);
        HSSFCell noteCell = row1.getCell((short)1);
        HSSFCell createClassCell = row1.getCell((short)9);
        HSSFRow row2 = sheet.getRow(this.startTableRow);
        HSSFCell tableCell = row2.getCell((short)1);
        HSSFCell createDaoCell = row2.getCell((short)9);
        HSSFRow row3 = sheet.getRow(this.startInfoRow);
        HSSFCell authorCell = row3.getCell((short)1);
        HSSFCell dateCell = row3.getCell((short)9);
        String pkg = CellUtil.getStringCellValue(pkgCell);
        String clazz = CellUtil.getStringCellValue(clazzCell);
        String note = CellUtil.getStringCellValue(noteCell);
        String author = CellUtil.getStringCellValue(authorCell);
        String date = CellUtil.getStringCellValue(dateCell);
        String table = CellUtil.getStringCellValue(tableCell);
        boolean createClass = CellUtil.getBooleanCellValue(createClassCell);
        boolean createDao = CellUtil.getBooleanCellValue(createDaoCell);
        if (pkg == null || pkg.length() == 0) {
            throw new MappingToolException("\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]");
        }
        if (clazz == null || clazz.length() == 0) {
            throw new MappingToolException("\u30af\u30e9\u30b9\u540d\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]");
        }
        if (table == null || table.length() == 0) {
            throw new MappingToolException("\u30c6\u30fc\u30d6\u30eb\u540d\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]");
        }
        DbPropertyList propertyMap = new DbPropertyList();
        propertyMap.setPkgName(pkg);
        propertyMap.setClassName(clazz);
        propertyMap.setNote(note);
        propertyMap.setAuthor(author);
        propertyMap.setDate(date);
        propertyMap.setTableName(table);
        propertyMap.setCreateClassFlg(createClass);
        propertyMap.setCreateDaoFlg(createDao);
        System.out.println("\u8aad\u53d6\u958b\u59cb\u30c6\u30fc\u30d6\u30eb\u540d      " + propertyMap.getTableName());
        int i = this.startParamRow;
        while (i <= sheet.getLastRowNum()) {
            DbProperty property = this.createParamater(sheet.getRow(i), sheetNo, i);
            if (property.getPropertyName() != null && property.getPropertyName().length() != 0 || property.getPropertyType() != null && property.getPropertyType().length() != 0 || property.getFieldName() != null && property.getFieldName().length() != 0 || property.getFieldType() != null && property.getFieldType().length() != 0) {
                if (property.getPropertyName() == null || property.getPropertyName().length() == 0) {
                    throw new MappingToolException("\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + i + "]");
                }
                if (property.getFieldName() == null || property.getFieldName().length() == 0) {
                    throw new MappingToolException("\u30d5\u30a3\u30fc\u30eb\u30c9\u540d\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + i + "]");
                }
                if (property.getFieldType() == null || property.getFieldType().length() == 0) {
                    throw new MappingToolException("\u30d5\u30a3\u30fc\u30eb\u30c9\u30bf\u30a4\u30d7\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + i + "]");
                }
                if (property.getPropertyType() == null || property.getPropertyType().length() == 0) {
                    throw new MappingToolException("\u30d7\u30ed\u30d1\u30c6\u30a3\u30bf\u30a4\u30d7\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + i + "]");
                }
                propertyMap.addProperty(property.getFieldName(), property);
            }
            ++i;
        }
        return propertyMap;
    }

    public DbProperty createParamater(HSSFRow row, int sheetNo, int rowNo) {
        HSSFCell propertyNameCell = row.getCell((short)0);
        HSSFCell propertyTypeCell = row.getCell((short)1);
        HSSFCell fieldNameCell = row.getCell((short)2);
        HSSFCell fieldTypeCell = row.getCell((short)3);
        HSSFCell fieldDefCell = row.getCell((short)4);
        HSSFCell fieldNonCell = row.getCell((short)5);
        HSSFCell fieldSizeCell = row.getCell((short)6);
        HSSFCell primaryCell = row.getCell((short)7);
        HSSFCell fTableCell = row.getCell((short)8);
        HSSFCell fKeyCell = row.getCell((short)9);
        HSSFCell fPropertyNameCell = row.getCell((short)10);
        HSSFCell noteCell = row.getCell((short)11);
        String propertyName = CellUtil.getStringCellValue(propertyNameCell);
        String propertyType = CellUtil.getStringCellValue(propertyTypeCell);
        String fieldName = CellUtil.getStringCellValue(fieldNameCell);
        String fieldType = CellUtil.getStringCellValue(fieldTypeCell);
        String fieldDef = CellUtil.getStringCellValue(fieldDefCell);
        int fieldSize = (int)CellUtil.getNumericCellValue(fieldSizeCell);
        boolean fieldNon = CellUtil.getBooleanCellValue(fieldNonCell);
        boolean primary = CellUtil.getBooleanCellValue(primaryCell);
        String foreignTable = CellUtil.getStringCellValue(fTableCell);
        String foreignKey = CellUtil.getStringCellValue(fKeyCell);
        String foreignPropertyName = CellUtil.getStringCellValue(fPropertyNameCell);
        String note = CellUtil.getStringCellValue(noteCell);
        DbProperty property = new DbProperty();
        property.setPropertyName(propertyName);
        property.setPropertyType(propertyType);
        property.setFieldName(fieldName);
        property.setFieldType(fieldType);
        property.setFieldDef(fieldDef);
        property.setNon(fieldNon);
        property.setSize(fieldSize);
        property.setPrimary(primary);
        if (foreignTable != null && foreignTable.length() > 0) {
            if (foreignKey == null || foreignKey.length() == 0) {
                throw new MappingToolException("\u5916\u90e8\u53c2\u7167\u30ad\u30fc\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5916\u90e8\u53c2\u7167\u30c6\u30fc\u30d6\u30eb\u540d[" + foreignTable + "]" + " \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + rowNo + "]");
            }
            if (foreignPropertyName == null || foreignPropertyName.length() == 0) {
                throw new MappingToolException("\u5916\u90e8\u53c2\u7167\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5916\u90e8\u53c2\u7167\u30c6\u30fc\u30d6\u30eb\u540d[" + foreignTable + "]" + " \u30b7\u30fc\u30c8\u756a\u53f7[" + sheetNo + "]" + " \u884c\u756a\u53f7[" + rowNo + "]");
            }
            property.setForeignTable(foreignTable);
            property.setForeignKey(foreignKey);
            property.setForeignPropertyName(foreignPropertyName);
        }
        property.setNote(note);
        return property;
    }

    public HashMap getTableMap() {
        return this.tableMap;
    }
}

