/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.daotool;

import java.util.HashMap;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.daotool.MappingToolException;
import org.itscool.commons.daotool.MappingToolInfo;
import org.itscool.commons.daotool.data.DbPropertyReader;
import org.itscool.commons.daotool.velocity.BeanListVelocityWriter;
import org.itscool.commons.daotool.velocity.BeanVelocityWriter;
import org.itscool.commons.daotool.velocity.DaoVelocityWriter;
import org.itscool.commons.daotool.velocity.RegistActionVelocityWriter;
import org.itscool.commons.daotool.velocity.SearchActionVelocityWriter;
import org.itscool.commons.daotool.velocity.SqlVelocityWriter;

public class MappingTool {
    public static final String DOCUMENT_PATH = "docpath";
    public static final String TEMPLATE_PATH = "tmppath";
    public static final String ENCODE = "encode";
    public static final String DB = "db";
    public static final String OUT = "out";
    public static final String SQL_TEMP_VM = "sqlTemplate.vm";
    public static final String BEAN_TEMP_VM = "beanTemplate.vm";
    public static final String BEANLIST_TEMP_VM = "beanListTemplate.vm";
    public static final String START_SHEET_INDEX = "startSheetIndex";

    public static void main(String[] argv) throws Exception {
        new MappingTool("di-config.xml");
    }

    public MappingTool(String configName) throws Exception {
        try {
            BeanFactory factory = new BeanFactory();
            try {
                factory.createForUrl(configName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception(ex.getMessage());
            }
            MappingToolInfo info = (MappingToolInfo)factory.createInstance("MappingToolInfo");
            String docpath = info.getInfo(DOCUMENT_PATH);
            String tmppath = info.getInfo(TEMPLATE_PATH);
            String encode = info.getInfo(ENCODE);
            String db = info.getInfo(DB);
            String out = info.getInfo(OUT);
            int startSheetIndex = 0;
            try {
                startSheetIndex = Integer.parseInt(info.getInfo(START_SHEET_INDEX));
            }
            catch (NumberFormatException nfe) {
                throw new MappingToolException("\u8aad\u53d6\u958b\u59cb\u30b7\u30fc\u30c8\u756a\u53f7\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (docpath == null || docpath.length() == 0) {
                throw new MappingToolException("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306e\u30d1\u30b9\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (tmppath == null || tmppath.length() == 0) {
                throw new MappingToolException("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u30d1\u30b9\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (encode == null || encode.length() == 0) {
                throw new MappingToolException("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (db == null || db.length() == 0) {
                throw new MappingToolException("\uff24\uff22\u306e\u7a2e\u985e\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (out == null || out.length() == 0) {
                throw new MappingToolException("\u51fa\u529b\u5148\u306e\u30d1\u30b9\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            System.out.println("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306e\u30d1\u30b9" + docpath);
            System.out.println("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u30d1\u30b9" + tmppath);
            System.out.println("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0  " + encode);
            System.out.println("\uff24\uff22\u306e\u7a2e\u985e        " + db);
            System.out.println("\u51fa\u529b\u5148\u306e\u30d1\u30b9      " + out);
            System.out.println("----- \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u69cb\u6210\u60c5\u5831 -----");
            System.out.println("\u8aad\u53d6\u958b\u59cb\u30b7\u30fc\u30c8\u756a\u53f7      " + startSheetIndex);
            DbPropertyReader reader = new DbPropertyReader();
            HashMap tableList = reader.create(docpath, startSheetIndex);
            SqlVelocityWriter sqlWriter = new SqlVelocityWriter(tableList);
            sqlWriter.execute(tmppath, SQL_TEMP_VM, out, encode);
            BeanVelocityWriter beanWriter = new BeanVelocityWriter(tableList);
            beanWriter.execute(tmppath, BEAN_TEMP_VM, out, encode);
            BeanListVelocityWriter beanListWriter = new BeanListVelocityWriter(tableList);
            beanListWriter.execute(tmppath, BEANLIST_TEMP_VM, out, encode);
            DaoVelocityWriter daoWriter = new DaoVelocityWriter(tableList);
            daoWriter.execute(tmppath, "daoTemplate.vm", out, encode);
            SearchActionVelocityWriter sActionWriter = new SearchActionVelocityWriter(tableList);
            sActionWriter.execute(tmppath, "sActionTemplate.vm", out, encode);
            RegistActionVelocityWriter rActionWriter = new RegistActionVelocityWriter(tableList);
            rActionWriter.execute(tmppath, "rActionTemplate.vm", out, encode);
            System.out.println("\u6b63\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f");
            throw e;
        }
    }
}

