/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.webertest.io;

import java.io.IOException;
import java.util.HashMap;
import org.itscool.commons.file.ConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebReader
extends ConfigReader {
    protected void doCreate(HashMap hashMap) throws IOException {
        NodeList servletList;
        Element root = this.document.getDocumentElement();
        if (root == null) {
            String err = "Can not root element at web.xml(" + ((Object)((Object)this)).getClass().getName() + ")";
            throw new IOException(err);
        }
        NodeList filterList = root.getElementsByTagName("filter");
        if (filterList != null) {
            int i = 0;
            while (i < filterList.getLength()) {
                Node filter = filterList.item(i);
                this.createInitParams(filter, hashMap);
                ++i;
            }
        }
        if ((servletList = root.getElementsByTagName("servlet")) != null) {
            int i = 0;
            while (i < servletList.getLength()) {
                Node servlet = servletList.item(i);
                this.createInitParams(servlet, hashMap);
                ++i;
            }
        }
    }

    protected void createInitParams(Node mappings, HashMap hashMap) throws IOException {
        NodeList mappingChilds = mappings.getChildNodes();
        int i = 0;
        while (i < mappingChilds.getLength()) {
            Node initParam = mappingChilds.item(i);
            if (initParam.getNodeName().equals("init-param")) {
                this.createInitParam(initParam, hashMap);
            }
            ++i;
        }
    }

    protected void createInitParam(Node initParam, HashMap hashMap) {
        NodeList initParamChilds = initParam.getChildNodes();
        String name = null;
        String value = null;
        int i = 0;
        while (i < initParamChilds.getLength()) {
            Node valueBody;
            Node param = initParamChilds.item(i);
            if (param.getNodeName().equals("param-name")) {
                Node nameBody = param.getFirstChild();
                if (nameBody != null) {
                    name = nameBody.toString();
                }
            } else if (param.getNodeName().equals("param-value") && (valueBody = param.getFirstChild()) != null) {
                value = valueBody.toString();
            }
            ++i;
        }
        if (name != null && value != null) {
            hashMap.put(name, value);
        }
    }
}

