/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.file.ConfigReader;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.filter.LayoutPageResponseWrapper;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;

public class LayoutFilter
implements Filter {
    private FilterConfig filterConfig = null;

    public void init(FilterConfig config) throws ServletException {
        BeanFactory factory;
        if (this.filterConfig == null) {
            this.filterConfig = config;
        }
        if (!(factory = BeanFactory.getInstance()).isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        LayoutMappings includeMappings = LayoutMappings.getInstance();
        try {
            ConfigReader includeReader = (ConfigReader)factory.createInstance("LayoutConfigReader");
            includeReader.create((LinkedList)includeMappings);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String path = req.getServletPath();
        String jsp = this.layout(path, req);
        if (jsp == null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        LayoutPageResponseWrapper wrapper = new LayoutPageResponseWrapper(res);
        chain.doFilter((ServletRequest)req, (ServletResponse)wrapper);
        res.reset();
        byte[] buff = wrapper.getByteStream().toByteArray();
        String buffStr = new String(buff);
        TagInfo body = TagUtil.createTagInfo((String)buffStr, (String)"body");
        TagInfo head = TagUtil.createTagInfo((String)buffStr, (String)"head");
        if (body != null) {
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)body.getDataInTag().getBytes());
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body_tag", (Object)body.getStartTag().getBytes());
            if (head != null) {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.head", (Object)head.getDataInTag().getBytes());
            }
        } else {
            req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)buff);
        }
        this.filterConfig.getServletContext().getRequestDispatcher(jsp).forward((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }

    private String layout(String path, HttpServletRequest req) {
        LayoutMappings mappings = LayoutMappings.getInstance();
        LayoutMapping include = (LayoutMapping)mappings.get(path);
        if (include == null) {
            return null;
        }
        String extendz = include.getExtendz();
        if (extendz != null) {
            this.checkParentLayout(include, req);
        }
        String layoutPath = include.getPath();
        HashMap putMap = include.getPuts();
        if (putMap != null) {
            Set keySet = putMap.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
                req.setAttribute("org.itscool.stylist.include.INCLUDE." + name, (Object)put);
            }
        }
        return layoutPath;
    }

    private void checkParentLayout(LayoutMapping layout, HttpServletRequest req) {
        HashMap putMap;
        LayoutMappings mappings = LayoutMappings.getInstance();
        String parentName = layout.getExtendz();
        String extendz = layout.getExtendz();
        if (extendz != null) {
            LayoutMapping parent = (LayoutMapping)mappings.get(parentName);
            this.checkParentLayout(parent, req);
        }
        if ((putMap = layout.getPuts()) == null) {
            return;
        }
        Set keySet = putMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + name, (Object)put);
        }
    }
}

