<?php
require_once("apiconfig.php");
require_once("apifunc.php");
require_once "Cache/Lite.php";

// リクエストURL組み立て
$url="http://feed.linksynergy.com/coupon?token=$lstoken&network=11";
echo $url;


// キャッシュの設定情報をここに入れる
$cacheOptions = array (
    'cacheDir' => './cache/',
    'lifeTime' => '86400',// 60秒×60分×24時間
    'automaticCleaningFactor' => 200
);

// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$couponCache = new Cache_Lite($cacheOptions);

if ($cache = $couponCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $couponBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $couponBuff = file_get_contents($url);
    $couponCache->save($couponBuff,$cacheId);
}


/* XMLを読み込んで必要な階層のデータのみ変数に取り込む*/
$xml = simplexml_load_string ($couponBuff);
$links = $xml->link;

?>
<!DOCTYPE html>
<html lang="ja">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>セール＆クーポン：カテゴリ、プロモーションタイプ</title>
<link rel="stylesheet" href="style.css" />
<!--[if IE]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

</head>

<body>

<div id="maincontainer">

<header><div class="innertube"><h1><a href="index.php"><img src="logo.gif" alt="LinkShop" width="292" height="61" border="0" /></a></h1></div></header>

<div id="contentwrapper">
<div id="contentcolumn">
<div class="innertube">

<br>

■セール＆クーポン<br />
<?php foreach ($links as $link) { ?>
<a href="<?php echo h($link->clickurl); ?>"><?php echo h($link->offerdescription); ?></a><br />
<?php
if ($couponcode=h($link->couponcode)) {
echo "クーポンコードは".$couponcode."です<br />";
}
?>
<?php } ?>




</div>
</div>
</div>

<nav id="leftcolumn">
<div class="innertube">
左カラム
</div>
</nav>

<nav id="rightcolumn">
<div class="innertube">
右カラム
</div>
</nav>

<footer><a href="http://www.c-player.com/ad62110/message/">Copyright 2010 WebサービスAPI勉強会第２クール</a></footer>

</div>
</body>
</html>
