<?php
/**
 * 携帯で位置情報を利用するサンプルプログラム（検索結果ページ）
 */

// モバイル処理用のライブラリ
require_once 'Mobile_Common.php';

// 開始処理
mobileStart();

// グーグルマップAPIキー
$googlemap_apikey = '（グーグルマップのAPIキー）';	/* MUST MODIFY! */	
// ホットペッパーAPIキー
$hotpepper_apikey = '（ホットペッパーのAPIキー）';	/* MUST MODIFY! */	

// GPS測位結果を取得
$lat = null;
$lon = null;
$gpsres = getGpsResult();
if ($gpsres != null) {
    $lat = $gpsres['lat'];
    $lon = $gpsres['lon'];
}

// ホットペッパー グルメサーチAPIに問い合わせる
$retarray = getHotPepperApi($lat, $lon, $hotpepper_apikey);

// 取得結果を整理
$i = 0;
$shops = array();
foreach ($retarray->shop as $shop) {
    $item = array();
    // お店情報
    $item['name']   = $shop->name;          // お店名
    $item['lat']    = $shop->lat;           // 緯度
    $item['lon']    = $shop->lng;           // 経度
    $item['catch']  = $shop->catch;         // お店キャッチ
    $item['access'] = $shop->access;        // 交通アクセス
    $item['url']    = $shop->urls->mobile;  // 携帯向けURL
    
    // GoogleMapマーカーの文字
    $item['letter'] = chr(ord('A') + $i);  // ここは大文字
    // お店ごとの詳細地図
    $size = 220;
    $map_param = array(
        'key'     => $googlemap_apikey,
        'center'  => $item['lat'].','.$item['lon'],
        'zoom'    => 17,
        'size'    => $size.'x'.$size,
        'maptype' => 'mobile',
        'markers' => $item['lat'].','.$item['lon'].',green'.strtolower($item['letter']),  // ここは小文字
    );
    $item['mapurl'] = getGoogleMapUrl($map_param);
    
    // 背景色
    $item['bgcolor'] = ($i % 2 == 0) ? '#eeeeee' : '#dddddd';
    
    $shops[] = $item;
    $i++;
}

// 現在位置とお店全件の位置を示すGoogle Map
$size = 220;
$map_param = array(
    'key'     => $googlemap_apikey,
    'size'    => $size.'x'.$size,
    'maptype' => 'mobile',
    'markers' => $lat.','.$lon.',red',
);

// お店の場所にマーカーを立てる
foreach ($shops as $shop) {
    $marker = $shop['lat'].','.$shop['lon'].',green'.strtolower($shop['letter']);
    $map_param['markers'] .= '|'.$marker;  // 複数のマーカーを立てる場合は'|'でつなげる
}
$map_url = getGoogleMapUrl($map_param);


/**
 * GPS測位結果を取得する
 *
 * @return 緯度（lat）と経度（lon）の連想配列
 */
function getGpsResult()
{
    $lat = null;
    $lon = null;
    
    switch (whichCarrier()) {
    case CARRIER_DOCOMO:
        if (isset($_POST['LAT']) && isset($_POST['LON'])) {
            // ドコモはPOSTでパラメタ名大文字で送信されてくる
            $lat = $_POST['LAT'];
            $lon = $_POST['LON'];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
        
    case CARRIER_EZWEB:
        if (isset($_GET['lat']) && isset($_GET['lon'])) {
            // EZwebはGETでパラメタ名小文字で送信されてくる
            $lat = $_GET['lat'];
            $lon = $_GET['lon'];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
        
    case CARRIER_SOFTBANK:
        if (isset($_GET['pos'])) {
            $pos = $_GET['pos'];
            // Softbankは1つのパラメタに緯度経度がくっついて送信されてくるため、正規表現で分離する
            preg_match('!N([0-9\.]+)E([0-9\.]+)!', $pos, $match);
            $lat = $match[1];
            $lon = $match[2];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
    }
    if ($lat != null && $lon != null) {
        // 正常に緯度経度が送信されてきた場合は、次の形式の連想配列で返す
        return array('lat' => $lat, 'lon' => $lon);
    } else {
        // 緯度経度の取得に失敗した場合はnullを返す
        return null;
    }
}

/**
 * dms（度分秒単位）表記をdegree（度単位）表記に変換
 *
 * @param string $dms xxx.xx.xx.xx形式の文字列
 *
 * @return degree単位の数値
 */
function convertDmsToDegree($dms)
{
    // 「.」ごとに分割
    list($a, $b, $c, $d) = explode('.', $dms);
    // 度分秒それぞれを10進法に直して加算
    $degree = $a + ($b / 60) + ($c / 60 / 60) + ($d / 60 / 60 / 100);
    return $degree;
}

/**
 * ホットペッパー.jp グルメサーチAPIに問い合わせる
 *
 * @param int    $lat    緯度（degree）
 * @param int    $lon    経度（degree）
 * @param string $apikey APIキー
 *
 * @return API取得結果のPHPオブジェクト
 */
function getHotPepperApi($lat, $lon, $apikey)
{
    $hp_param = array(
        'key' => $apikey,
        'lat' => $lat,        // degreeで指定
        'lng' => $lon,        // degreeで指定
        'type' => 'lite',     // レスポンスの出力タイプ
        'range' => 5,         // 検索結果の範囲
    );
    
    // URL組み立て
    $url_hp = 'http://webservice.recruit.co.jp/hotpepper/gourmet/v1/';
    $param_array = array();
    foreach ($hp_param as $key => $value) {
        $param_array[] = $key.'='.urlencode($value);
    }
    $url_hp .= '?'.implode('&', $param_array);
    // API問い合わせ
    $retxml = file_get_contents($url_hp);
    // XMLをPHPオブジェクトに変換
    $retarray = simplexml_load_string($retxml);
    return $retarray;
}

/**
 * Google Static MapsのURLを返す
 *
 * @param array $param APIパラメタの連想配列
 *
 * @return 地図画像のURL
 */
function getGoogleMapUrl($param)
{
    $map_url = 'http://maps.google.com/staticmap';
    $param_array = array();
    foreach ($param as $key => $value) {
        $param_array[] = $key.'='.urlencode($value);
    }
    $map_url .= '?'.implode('&', $param_array);
    return $map_url;
}

?>
<html>
<head>
<meta http-equiv="Content-Type" content="Application/xhtml+xml; charset=Shift_JIS" />
<title>近くのお店を検索</title>
</head>
<body>
近くのお店を検索！<br/>
<br/>

<?php if ($lat == null || $lon == null) { ?>
    位置情報が取得できませんでした。<br/>

<?php } else { ?>

    <!--全体の地図-->
    <div style="text-align:center;">
    <img src="<?php varout($map_url) ?>" alt="" width="220" height="220" />
    </div>
    
    <hr/>
    近くのお店
    <div><a href="http://webservice.recruit.co.jp/"><img src="http://webservice.recruit.co.jp/banner/hotpepper-s.gif" alt="ホットペッパー Webサービス" width="135" height="17" border="0" title="ホットペッパー Webサービス"></a></div>
    
    <hr/>
    <?php
    // お店ごとにループ
    foreach ($shops as $shop) {
    ?>
        <!--背景色を指定-->
        <div style="background-color:<?php varout($shop['bgcolor']) ?>;">
            <!--グーグルマップのマーカーに指定した文字-->
            [<?php varout($shop['letter']) ?>]<br/>
            <!--お店名とホットペッパーサイトへのリンク-->
            <a href="<?php varout($shop['url']) ?>"><?php varout($shop['name']) ?></a><br/>
            <!--キャッチコピー-->
            <?php varout($shop['catch']) ?><br/>
            <!--交通アクセスと、詳細地図へのリンク-->
            <?php varout($shop['access']) ?> [<a href="<?php varout($shop['mapurl']) ?>">詳細地図</a>]<br/>
        </div>
    <?php } ?>
<?php } ?>

</body>
</html>
<?php

//■終了処理
mobileFinish();

?>
