<?php
/**
 *  携帯サイト用共通関数定義
 *
 * @package Mobile_Common.php
 * @version 1
 */

define('CARRIER_DOCOMO', 'i');
define('CARRIER_EZWEB', 'e');
define('CARRIER_SOFTBANK', 's');
define('CARRIER_PC', 'pc');

/**
 * 開始処理
 *
 * @return none
 */
function mobileStart()
{
    //■php内部文字エンコーディング
    mb_internal_encoding('utf-8');
    
    //■header出力
    //携帯アクセスでdocomoの場合は、Content-Typeを出力
    if (whichCarrier() == CARRIER_DOCOMO) {
        header("Content-Type: application/xhtml+xml;");
    }
    //auのみ、ブラウザキャッシュが効くのでキャッシュ無効にする
    if (whichCarrier() == CARRIER_EZWEB) {
        header('Cache-Control: no-cache');
    }
    
    //■出力バッファ開始
    ob_start();
    
    //■XML宣言
    echo '<'.'?xml version="1.0" encoding="Shift_JIS" ?'.'>'."\n";
    
    //■DOCTYPE宣言
    switch (whichCarrier()) {
    case CARRIER_DOCOMO:
    case CARRIER_PC:
        echo '<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/2.3) 1.0//EN" "i-xhtml_4ja_10.dtd">';
        break;
    case CARRIER_EZWEB:
        echo '<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">';
        break;
    case CARRIER_SOFTBANK:
        echo '<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
        break;
    }
}

/**
 * 出力処理
 *
 * @return none
 */
function mobileFinish()
{
    //■文字コード変換＆バッファ出力
    $content = ob_get_contents();
    ob_end_clean();
    $content = mb_convert_encoding($content, 'sjis-win', 'utf-8');
    echo $content;
}

/**
 * html出力用関数
 *
 * @param string $str html出力する文字列
 *
 * @return none
 */
function varout($str)
{
    echo htmlspecialchars($str, ENT_QUOTES);
}

/**
 * UAからキャリアを判定する
 *
 * @return キャリア定数
 */
function whichCarrier()
{
    global $_mobile_carrier;
    
    //すでに判別済みの場合は前回結果を返す
    if ($_mobile_carrier != null) {
        return $_mobile_carrier;
    }
    
    //UA判別正規表現と判別結果の定義
    $uaList = array(
        array(
            'regexp'  => '!^DoCoMo!',
            'carrier' => CARRIER_DOCOMO,
        ),
        array(
            'regexp'  => '!^KDDI-!',
            'carrier' => CARRIER_EZWEB,
        ),
        array(
            'regexp'  => '!^UP\.Browser!',
            'carrier' => CARRIER_EZWEB,
        ),
        array(
            'regexp'  => '!^SoftBank!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^Vodafone!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^J-PHONE!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^MOT-!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^Semulator!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^Vemulator!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^J-EMULATOR!',
            'carrier' => CARRIER_SOFTBANK,
        ),
        array(
            'regexp'  => '!^MOTEMULATOR!',
            'carrier' => CARRIER_SOFTBANK,
        ),
    );
    
    $ua = $_SERVER['HTTP_USER_AGENT'];
    
    foreach ($uaList as $item) {
        if (preg_match($item['regexp'], $ua)) {
            $_mobile_carrier = $item['carrier'];
            break;
        }
    }
    if ($_mobile_carrier == null) {
        // PCやその他のUAでアクセスされたとき
        $_mobile_carrier = CARRIER_PC;
    }
    
    return $_mobile_carrier;
}

// wackey 追加
function convertDmsToDegree($dms)
{
    // 「.」ごとに分割
    list($a, $b, $c, $d) = explode('.', $dms);
    // 度分秒それぞれを10進法に直して加算
    $degree = $a + ($b / 60) + ($c / 60 / 60) + ($d / 60 / 60 / 100);
    return $degree;
}

?>
