<?php
require_once("apiconfig.php");
require_once("apifunc.php");
require_once 'Lite.php';
$url="http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&operation=GenreSearch&version=2007-04-11&genreId=0";

// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$rwsCache = new Cache_Lite($cacheOptions);

if ($cache = $rwsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $rwsBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $rwsBuff = file_get_contents($url);
    $rwsCache->save($rwsBuff,$cacheId);
}

//キャッシュ時間取得
$chashjikan = date("Y/m/d H:i:s", $rwsCache->lastModified());

$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('genreSearch:GenreSearch', 'genreSearchGenreSearchh', $rwsBuff);
$xml = simplexml_load_string ($rwsBuff);
$hits = $xml->Body->genreSearchGenreSearchh->child;

// サイドバー用ジャンル別ランキングリクエストURL組立　$urlは使用済みなのでここで上書き再利用する
$url="http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=ItemRanking&version=2009-04-15&genreId=0";

// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$rwsCache = new Cache_Lite($cacheOptions);

if ($cache = $rwsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $rwsBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $rwsBuff = file_get_contents($url);
    $rwsCache->save($rwsBuff,$cacheId);
}

$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('itemRanking:ItemRanking', 'itemRankingItemRanking', $rwsBuff);
$xml = simplexml_load_string ($rwsBuff);
$ranking = $xml->Body->itemRankingItemRanking->Item;
?>
<!DOCTYPE html>
<html lang="ja">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>LinkShop</title>
<link rel="stylesheet" href="style.css" />
<!--[if IE]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->
</head>

<body>

<div id="maincontainer">

<header><div class="innertube"><h1><a href="index.php"><img src="logo.gif" alt="LinkShop" width="292" height="61" border="0" /></a></h1></div></header>

<div id="search">
<form action="search.php" method="get">
キーワード：<input type="text" name="keyword" size="40">
<select id="genreid" name="genreid">
<option value="0">すべての商品</option>
<?php foreach ($hits as $hit) { ?>
<option value="<?php echo h($hit->genreId); ?>">
<?php echo h($hit->genreName); ?>
</option>
<?php } ?>
<input type="submit" value="検索">
</select>
</form>
</div>



<div id="contentwrapper">
<div id="contentcolumn">
	<div class="innertube">
    
    <b>中央カラム: <em>536px</em></b><br />

	</div>
</div>
</div>

<div id="leftcolumn">
	<div class="innertube">
    
		<b>左カラム: <em>200px</em></b><br />
<?php foreach ($hits as $hit) { ?>
<a href="search.php?genreid=<?php echo h($hit->genreId); ?>">
<?php echo h($hit->genreName); ?>
</a><br>
<?php } ?>

	</div>

</div>

<div id="rightcolumn">
	<div class="innertube">
    
		<b>右カラム: <em>200px</em></b><br />
		<ol>
		<?php foreach ($ranking as $hit) { ?>
			<li><a href="<?php echo h($hit->affiliateUrl); ?>"><?php echo h($hit->itemName); ?><br />
			<img src="<?php echo h($hit->mediumImageUrl); ?>"></a></li>
		<?php } ?>
		</ol>


	</div>
</div>

<footer><a href="http://www.c-player.com/ad62110/message/">Copyright 2010 WebサービスAPI勉強会第２クール</a></footer>

</div>
</body>
</html>
