<?php
require_once("./common.php");// 設定・共通ファイル読み込み

// 楽天リクエストURL組み立て
$rwsquery = "芦ノ湖";// 楽天検索用クエリー
$rwsquery4url = rawurlencode($rwsquery);// URLエンコード

$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&&operation=KeywordHotelSearch&version=2009-02-03&hits=30&sumDisplayFlag=1&keyword=$rwsquery4url";

// xmlファイルを一度ファイルとして取得して変数に格納
$xml = file_get_contents($rwsurl);

// 楽天の場合「:」が入っている要素名がある。
// simpleXMLでは扱えないので、その文字を削除する。
$xml = str_replace('header:Header', 'headerHeader', $xml);
$xml = str_replace('keywordHotelSearch:KeywordHotelSearch', 'keywordHotelSearchKeywordHotelSearch', $xml);
// 変数に入れられた文字列をsimpleXMLで読みこむ
$xml = simplexml_load_string($xml);
$items = $xml->Body->keywordHotelSearchKeywordHotelSearch->hotelSimple;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="&copy; 2009 ムジログ." />
<meta name="Keywords" content="箱根湯本温泉,強羅温泉,仙石原温泉,芦ノ湖温泉,湯河原温泉,旅館,ホテル" />
<meta name="description" content="何度も行きたい箱根温泉の特集です  ～ 箱根湯本温泉、強羅温泉、仙石原温泉、芦ノ湖温泉、湯河原温泉 ～" />
<title>芦ノ湖温泉 | 何度も行きたい箱根温泉</title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<div id="wrapper">


<div id="header">
<a href="index.php"><img src="c_img/logo.jpg" alt="何度も行きたい箱根温泉" width="758" height="120" /></a>
</div>

<div id="navigation">
<ol>
<li id="yumoto"><a href="hakoneyumoto.php" accesskey="1">箱根湯本温泉</a></li>
<li id="goura"><a href="goura.php" accesskey="2">強羅温泉</a></li>
<li id="sengokuhara"><a href="sengokuhara.php" accesskey="3">仙石原温泉</a></li>
<li id="ashinoko"><a href="ashinoko.php" accesskey="4">芦ノ湖温泉</a></li>
<li id="yugawara"><a href="yugawara.php" accesskey="5">湯河原温泉</a></li>
<li id="kensaku"><a href="shukuhakuyoyaku.php" accesskey="6">宿泊空室検索</a></li>
</ol>
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai">芦ノ湖温泉</span></div>

<div id="content">

<h2>芦ノ湖温泉</h2>
<p>芦ノ湖（あしのこ）温泉は、芦ノ湖畔の元箱根にある温泉。開湯は<a href="http://ja.wikipedia.org/wiki/1966%E5%B9%B4" title="1966年">1966年</a>（<a href="http://ja.wikipedia.org/wiki/%E6%98%AD%E5%92%8C" title="昭和">昭和</a>41年）。湯ノ花沢温泉からの<a href="http://ja.wikipedia.org/wiki/%E5%BC%95%E6%B9%AF" title="引湯">引湯</a>で誕生した温泉であるが、現在は自家源泉を持つ施設もある。単純温泉、単純硫黄温泉。関所や遊覧船乗り場に近い。</p>
（wikipediaより）
<?php
foreach ($items as $item) {
?>
<h3><?php echo h($item->hotelName); ?></h3>
<?php echo h($item->hotelSpecialSum); ?><br />
評価：<?php echo h($item->reviewAverage); ?><br />
投稿件数：<?php echo h($item->	reviewCount); ?><br />
<a href="syosai.php?num=<?php echo h($item->hotelNo); ?>">詳細はこちら</a>

<div class="pic">&nbsp;</div>
<?php
}
?>
<h3>&nbsp;</h3>
</div>
<ul id="menu">
<li id="selected">芦ノ湖温泉</li>
</ul>

<div class="ad">
<!-- 160*600 adwords -->
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai">芦ノ湖温泉</span></div>

<div id="footer">
<hr />
<div id="footerl">
Copyright 2009 オトコ磨きドットジェイピー All Rights Reserved.　<a href="http://musilog.net/contact" target="_blank">お問い合わせ（ムジログ）</a><br />
<!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_22121.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="221" height="21"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE -->
</div>

</div>


</div>

<script type="text/javascript">
var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
</script>
<script type="text/javascript">
try {
var pageTracker = _gat._getTracker("UA-148922-12");
pageTracker._trackPageview();
} catch(err) {}</script></body>
</html>
