/* 
 The MIT License 

 Copyright (c) 2008 Katokichi 

 Permission is hereby granted, free of charge, to any person obtaining a copy 
 of this software and associated documentation files (the "Software"), to deal 
 in the Software without restriction, including without limitation the rights 
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 copies of the Software, and to permit persons to whom the Software is 
 furnished to do so, subject to the following conditions: 

 The above copyright notice and this permission notice shall be included in 
 all copies or substantial portions of the Software. 

 THE SOFTWARE IS PROVIDED "AS IS (AS FAR AS POSSIBLE)", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
 IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES
 OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR THERWISE, 
 ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 IN THE SOFTWARE.
 */

// 何時間後の情報を取り扱うかを保持
status = 7;
target_info = [".jpg", "_1.jpg", "_2.jpg", "_3.jpg",
    "_4.jpg", "_5.jpg", "_6.jpg", "_anime.gif"];
target_strings = [
    dashcode.getLocalizedString("time_current"),
    dashcode.getLocalizedString("time_1h_later"),
    dashcode.getLocalizedString("time_2h_later"),
    dashcode.getLocalizedString("time_3h_later"),
    dashcode.getLocalizedString("time_4h_later"),
    dashcode.getLocalizedString("time_5h_later"),
    dashcode.getLocalizedString("time_6h_later"),
    dashcode.getLocalizedString("time_anime") ];

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    dashcode.setupParts();
    // 設定情報の読み込みと反映
    var key = "prefecture";
    key = widget.preferenceForKey(widget.identifier + "-" + key);
    var pref = document.getElementById("pref_popup");
    pref.object.setSelectedIndex(key);
    // 読み込んだ情報に更新
    changepref(null);
    hidecurrentstatus(event);

    // 各種イベント用の画像・文字列を非表示にしておく
    var elem1, elem2;
    elem1 = document.getElementById("time_info"); // 時間情報
    elem1.style.opacity = 0.0;

    elem1 = document.getElementById("nextRectangleShape"); // 次を表示コマンド用エリア
    elem2 = document.getElementById("nextarrow");
    elem1.style.opacity = 0.0; elem2.style.opacity = 0.0;

    elem1 = document.getElementById("prevRectangleShape"); // 次を表示コマンド用エリア
    elem2 = document.getElementById("prevarrow");
    elem1.style.opacity = 0.0; elem2.style.opacity = 0.0;
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    // Stop any timers to prevent CPU usage
    // Remove any preferences as needed
    // widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
    // Stop any timers to prevent CPU usage
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    // Restart any timers that were stopped on hide
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
//
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

//
// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    // 表示情報の取得と更新・プレファレンスへの保存
    changepref(event);
    
    // Transition
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }

    showcurrentstatus(event);
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}

//
// Function: changepref(event)
// Called when the location popup button is changed from the back of the widget
//
// event: onchange event from the pref_popup button
//
function changepref(event)
{
    // 情報の収集
    var pref = document.getElementById("pref_popup");
    var img = document.getElementById("weather_rader");

    // 情報をプレファレンスとして保存しておく（次からの起動のため）
    var key = "prefecture";
    var value = pref.object.getSelectedIndex();;
    widget.setPreferenceForKey(value, widget.identifier + "-" + key);

    img.src = "http://image.weather.livedoor.com/component/rader_img/pref_"
        + pref.object.getValue() + target_info[status];
}


function jumptoLivedoor(event)
{
    // Livedoor天気情報のURLへジャンプ
    var livedoorURL = "http://weather.livedoor.com/";

    // Show website code
    widget.openURL(livedoorURL);
}

function getstatehandler(event, to)
{
    var item = document.getElementById("time_info");
    item.innerText = target_strings[status];
    var functions = new Array(2);
    functions[0] = function(a, c, s, f){ item.style.opacity = c; };
    functions[1] = function() { item.style.opacity = to * 1.0; };
    return functions;
}

function showcurrentstatus(event)
{
    // 今のステータスを画面中央にアニメーション表示
    var functions = getstatehandler(event, 1.0);
    fadestatus(350, 12, 0.0, 1.0, functions);
}

function hidecurrentstatus(event)
{
    // 画面中央に表示している今のステータスを消去
    var functions = getstatehandler(event, 0.0);
    fadestatus(1500, 12, 1.0, 0.0, functions);
}

stateanimator = null;
function fadestatus(duration, interval, a, b, functions)
{
    if (stateanimator !== null)
    {
        stateanimator.stop();
        stateanimator.oncomplete();
    }
    stateanimator = new AppleAnimator(duration, interval, a, b, functions[0]);
    stateanimator.start();
    stateanimator.oncomplete = functions[1];
}

function getcontrolhandler(event, to)
{
    var elem1_1 = document.getElementById("nextRectangleShape");
    var elem2_1 = document.getElementById("prevRectangleShape");
    var elem1_2 = document.getElementById("nextarrow");
    var elem2_2 = document.getElementById("prevarrow");

    // Fade out
    var functions = new Array(2);
    functions[0] = function(a, c, s, f) {
            elem1_1.style.opacity = c*0.30;
            elem1_2.style.opacity = c;
            elem2_1.style.opacity = c*0.30;
            elem2_2.style.opacity = c;
            };
    functions[1] = function() {
            elem1_1.style.opacity = to * 0.3;
            elem1_2.style.opacity = to * 1.0;
            elem2_1.style.opacity = to * 0.3;
            elem2_2.style.opacity = to * 1.0;
            };
    return functions;
}

function showcontroller(event)
{
    var functions = getcontrolhandler(event, 1.0);
    fadecontroller(300, 10, 0.0, 1.0, functions);
    showcurrentstatus(event);
}

function hidecontroller(event)
{
    var functions = getcontrolhandler(event, 0.0);
    fadecontroller(600, 10, 1.0, 0.0, functions);
    hidecurrentstatus(event);
}

fadeanimator = null;
function fadecontroller(duration, interval, a, b, functions)
{
    if (fadeanimator !== null)
    {
        fadeanimator.stop();
        fadeanimator.oncomplete();
    }
    fadeanimator = new AppleAnimator(duration, interval, a, b, functions[0]);
    fadeanimator.start();
    fadeanimator.oncomplete = functions[1];
}

function clickevent(event)
{
    var prevarea = document.getElementById("prevRectangleShape");
    var nextarea = document.getElementById("nextRectangleShape");
    // マウスがどのnext,prev上に置かれているかを判別
    var x = event.x; // ウィジェット内での位置を見る
    var y = event.y;
    if (prevarea.offsetLeft <= x && x <= (prevarea.offsetLeft+prevarea.offsetWidth)
        && prevarea.offsetTop <= y && y <= (prevarea.offsetTop+prevarea.offsetHeight))
    {
        // prevRectangleShape内でクリック
        changeinfo(event, -1); // 1時間前の情報に変更
    } else if (nextarea.offsetLeft <= x && x <= (nextarea.offsetLeft+nextarea.offsetWidth)
        && nextarea.offsetTop <= y && y <= (nextarea.offsetTop+nextarea.offsetHeight))
    {
        // nextRectangleShape内でクリック
        changeinfo(event, 1); // 1時間後の情報に変更
    } else {
        // とりあえず現在の情報を文字列で表示
        showcurrentstatus(event);
    }
}

function changeinfo(event, value)
{
    // 表示情報の変更
    status = parseInt(status) + parseInt(value);
    if (status>7) {
        status = 0;
    } else if (status<0) {
        status = 7;
    }
    changepref(null);
    showcurrentstatus(event);
}
