/* 
 This file was generated by Dashcode.  
 You may edit this file to customize your widget or web page 
 according to the license.txt file included in the project.
 */

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    dashcode.setupParts();
    // 設定情報の読み込みと反映
    var preferenceForKey = "prefecture";
    preferenceForKey = widget.preferenceForKey(widget.identifier + "-" + preferenceForKey);
    var prefField = document.getElementById("pref_popup");
    prefField.object.setSelectedIndex(preferenceForKey);
    // 読み込んだ情報に更新
    changepref(null);

    // 時間情報を表す文字列を非表示にしておく
    var timeinfo = document.getElementById("time_info");
    timeinfo.style.opacity = 0.0;
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    // Stop any timers to prevent CPU usage
    // Remove any preferences as needed
    // widget.setPreferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
    // Stop any timers to prevent CPU usage
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    // Restart any timers that were stopped on hide
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
//
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

//
// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    // 表示情報の取得と更新・プレファレンスへの保存
    changepref(event);
    
    // Transition
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    widget.onsync = sync;
}

// 何時間後の情報を取り扱うかを保持
status = 7;
var target_info = new Array(8);
target_info[0] = ".jpg";
target_info[1] = "_1.jpg";
target_info[2] = "_2.jpg";
target_info[3] = "_3.jpg";
target_info[4] = "_4.jpg";
target_info[5] = "_5.jpg";
target_info[6] = "_6.jpg";
target_info[7] = "_anime.gif";

var target_strings = new Array(8);
target_strings[0] = dashcode.getLocalizedString("time_current");
target_strings[1] = dashcode.getLocalizedString("time_1h_later");
target_strings[2] = dashcode.getLocalizedString("time_2h_later");
target_strings[3] = dashcode.getLocalizedString("time_3h_later");
target_strings[4] = dashcode.getLocalizedString("time_4h_later");
target_strings[5] = dashcode.getLocalizedString("time_5h_later");
target_strings[6] = dashcode.getLocalizedString("time_6h_later");
target_strings[7] = dashcode.getLocalizedString("time_anime");

//
// Function: changepref(event)
// Called when the location popup button is changed from the back of the widget
//
// event: onchange event from the pref_popup button
//
function changepref(event)
{
    // 情報の収集
    var prefField = document.getElementById("pref_popup");
    var imgElement = document.getElementById("weather_rader");

    // 情報をプレファレンスとして保存しておく（次からの起動のため）
    var preferenceKey = "prefecture";
    var preferenceValue = prefField.object.getSelectedIndex();;
    widget.setPreferenceForKey(preferenceValue, widget.identifier + "-" + preferenceKey);

    imgElement.src = "http://image.weather.livedoor.com/component/rader_img/pref_"
        + prefField.object.getValue() + target_info[status];
}


function jumptoLivedoor(event)
{
    // Livedoor天気情報のURLへジャンプ
    var websiteURL = "http://weather.livedoor.com/";	// replace with the website URL to show

    // Show website code
    widget.openURL(websiteURL);
}


function changeinfo(event)
{
    // 何時間後の情報を表示するかを変更
    status++;
    if (status>7) {
        status = 0;
    }
    changepref(null);

    // 今のステータスをアニメーション表示
    var itemToFade = document.getElementById("time_info");
    itemToFade.innerText = target_strings[status];
    var fadeHandler = function(a, c, s, f){ itemToFade.style.opacity = c; };
    var currentAnimator = new AppleAnimator(1200, 13);
    var firstAnimation = new AppleAnimation(0.0, 1.0, fadeHandler);
    var secondAnimation = new AppleAnimation(1.0, 1.0, fadeHandler);
    secondAnimation.from = 100;
    secondAnimation.from = 850;
    var thirdAnimation = new AppleAnimation(1.0, 0.0, fadeHandler);
    currentAnimator.addAnimation(firstAnimation);
    currentAnimator.addAnimation(secondAnimation);
    currentAnimator.addAnimation(thirdAnimation);
    currentAnimator.start();
}
