<?php
/*
 *
 *
 *    Weasy (template.php)
 *    Mafice <mafice@mflabo.net>
 *
 *
 */

//
//      テンプレートについて
//
//  まず、ユーザがアクセスすると、このtemplate関数が実行されます。
//  ユーザが検索をした場合にも同じくこの関数が実行されます。
//
//  この関数にはひとつの引数が渡され中身はこのようになっています。
//
//    $_GET['q']          ・・・ ユーザからのクエリ (検索フォームからクエリが送信されたときのみ)
//    $url['form_search'] ・・・ 検索フォームのクエリの送信先
//    $url['php_search']  ・・・ エントリデータベースのアクセス先
//                              $url['php_search']/?q=クエリ にアクセスすることで、
//                              一致するエントリがcsv形式で取得できます。
//
//

function template ($url){

print <<< HDOC
<!DOCTYPE html>
<head>
  <meta charset="utf-8">
  <title>test</title>
</head>
<body>
  <div style="width:60%;margin-right:auto;margin-left:auto;margin-top:2em;text-align:center;">
    <h2>探したい情報を探す</h2>

    <form action="{$url['form_search']}" method="GET">
      <input type="text"   tabindex="0" name="q">
      <input type="submit" tabindex="0" value="検索">
    </form>

HDOC;

  if(isset($_GET['q'])){

    $db = file("{$url['php_search']}?q=".htmlspecialchars($_GET['q']));

    if($db == array())
      print '該当する情報が見つかりませんでした。';

    foreach($db as $line){

      $entry = str_getcsv($line);

      print <<< HDOC

        <div class="entry">
          <b>{$entry[1]}</b>
          <p>{$entry[3]}</p>
          <hr>
        </div>
HDOC;
    }
  }
}

?>
  </div>
</body>
</html>

