/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTOutlineView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    NSTableHeaderView headerView;
    TreeItem[] items;
    int itemCount;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int columnCount;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreExpand;
    boolean ignoreSelect;
    boolean ignoreRedraw;
    boolean reloadPending;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    TreeItem insertItem;
    boolean insertBefore;
    boolean shouldExpand = true;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    @Override
    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        this.clearCachedWidth(this.items);
    }

    TreeItem _getItem(TreeItem treeItem, int n, boolean bl) {
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem != null) {
            n2 = treeItem.itemCount;
            treeItemArray = treeItem.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        TreeItem treeItem2 = treeItemArray[n];
        if (treeItem2 != null || (this.style & 0x10000000) == 0 || !bl) {
            return treeItem2;
        }
        treeItemArray[n] = treeItem2 = new TreeItem(this, treeItem, 0, n, false);
        return treeItem2;
    }

    @Override
    boolean acceptsFirstResponder(long l, long l2) {
        return true;
    }

    @Override
    long accessibilityAttributeValue(long l, long l2, long l3) {
        long l4;
        long l5 = 0L;
        NSString nSString = new NSString(l3);
        if ((nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute) || nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (l4 = super.accessibilityAttributeValue(l, l2, l3)) != 0L) {
            NSArray nSArray = new NSArray(l4);
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() - 1L);
            nSMutableArray.addObjectsFromArray(nSArray);
            nSMutableArray.removeObjectAtIndex(0L);
            l5 = nSMutableArray.id;
        }
        if (l5 != 0L) {
            return l5;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] treeItemArray, int n, GC gC, boolean bl) {
        if (treeItemArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem == null) continue;
            int n3 = treeItem.calculateWidth(n, gC);
            n2 = Math.max(n2, n3);
            if (!bl || !treeItem.getExpanded()) continue;
            n2 = Math.max(n2, this.calculateWidth(treeItem.items, n, gC, bl));
        }
        return n2;
    }

    @Override
    NSSize cellSize(long l, long l2) {
        NSSize nSSize = super.cellSize(l, l2);
        NSCell nSCell = new NSCell(l);
        NSImage nSImage = nSCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] lArray = new long[1];
            OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
            TreeItem treeItem = (TreeItem)this.display.getWidget(lArray[0]);
            OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
            long l3 = lArray[0];
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].nsColumn.id != l3) continue;
                n = i;
                break;
            }
            this.sendMeasureItem(treeItem, nSCell.isHighlighted(), n, nSSize);
        }
        return nSSize;
    }

    @Override
    boolean canDragRowsWithIndexes_atPoint(long l, long l2, long l3, NSPoint nSPoint) {
        boolean bl;
        if (!super.canDragRowsWithIndexes_atPoint(l, l2, l3, nSPoint)) {
            return false;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        long l4 = nSTableView.rowAtPoint(nSPoint);
        long l5 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl2 = bl = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl && !nSTableView.isRowSelected(l4) && (l5 & 0x1E0000L) == 0L) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l4);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSTableView.isRowSelected(l4) && bl || !this.hasFocus();
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            Event event = new Event();
            TreeItem treeItem2 = treeItem.getParentItem();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(treeItem)) {
                treeItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void checkItems() {
        if (!this.reloadPending) {
            return;
        }
        this.reloadPending = false;
        TreeItem[] treeItemArray = this.getSelection();
        ((NSOutlineView)this.view).reloadData();
        this.selectItems(treeItemArray, true);
        this.ignoreExpand = true;
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].updateExpanded();
        }
        this.ignoreExpand = false;
    }

    void clear(TreeItem treeItem, int n, boolean bl) {
        TreeItem treeItem2 = this._getItem(treeItem, n, false);
        if (treeItem2 != null) {
            treeItem2.clear();
            treeItem2.redraw(-1);
            if (bl) {
                this.clearAll(treeItem2, true);
            }
        }
    }

    void clearAll(TreeItem treeItem, boolean bl) {
        int n = this.getItemCount(treeItem);
        if (n == 0) {
            return;
        }
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        for (int i = 0; i < n; ++i) {
            TreeItem treeItem2 = treeItemArray[i];
            if (treeItem2 == null) continue;
            treeItem2.clear();
            treeItem2.redraw(-1);
            if (!bl) continue;
            this.clearAll(treeItem2, true);
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        this.clear(null, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(null, bl);
    }

    void clearCachedWidth(TreeItem[] treeItemArray) {
        TreeItem treeItem;
        if (treeItemArray == null) {
            return;
        }
        for (int i = 0; i < treeItemArray.length && (treeItem = treeItemArray[i]) != null; ++i) {
            treeItem.width = -1;
            this.clearCachedWidth(treeItem.items);
        }
    }

    @Override
    void collapseItem_collapseChildren(long l, long l2, long l3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l3);
        if (treeItem == null) {
            return;
        }
        if (!this.ignoreExpand) {
            treeItem.sendExpand(false, bl);
        }
        this.ignoreExpand = true;
        super.collapseItem_collapseChildren(l, l2, l3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        this.setScrollWidth();
    }

    @Override
    long columnAtPoint(long l, long l2, NSPoint nSPoint) {
        if ((this.style & 0x20) != 0 && nSPoint.x <= (double)this.getCheckColumnWidth() && nSPoint.y < this.headerView.frame().height) {
            return 1L;
        }
        return super.columnAtPoint(l, l2, nSPoint);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    n3 += this.columns[i].getWidth();
                }
            } else {
                GC gC = new GC(this);
                n3 = this.calculateWidth(this.items, 0, gC, true) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n3 += this.getCheckColumnWidth();
            }
        } else {
            n3 = n;
        }
        n4 = n2 == -1 ? (int)((NSOutlineView)this.view).numberOfRows() * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TreeItem treeItem, int n) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray;
        if (treeItem.items != null) {
            for (int i = 0; i < treeItem.items.length; ++i) {
                if (treeItem.items[i] == null) continue;
                this.createColumn(treeItem.items[i], n);
            }
        }
        if ((stringArray = treeItem.strings) != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n);
            System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
            objectArray[n] = "";
            treeItem.strings = objectArray;
        }
        if (n == 0) {
            treeItem.text = "";
        }
        if ((objectArray = treeItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n);
            System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
            treeItem.images = resourceArray2;
        }
        if (n == 0) {
            treeItem.image = null;
        }
        if ((resourceArray2 = treeItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n);
            System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
            treeItem.cellBackground = colorArray;
        }
        if ((colorArray = treeItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n);
            System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
            treeItem.cellForeground = resourceArray;
        }
        if ((resourceArray = treeItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n);
            System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
            treeItem.cellFont = fontArray;
        }
    }

    @Override
    void createHandle() {
        NSString nSString;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2L : 0L);
        NSOutlineView nSOutlineView = (NSOutlineView)new SWTOutlineView().alloc();
        nSOutlineView.initWithFrame(new NSRect());
        nSOutlineView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSOutlineView.setAutoresizesOutlineColumn(false);
        nSOutlineView.setAutosaveExpandedItems(true);
        nSOutlineView.setDataSource(nSOutlineView);
        nSOutlineView.setDelegate(nSOutlineView);
        nSOutlineView.setColumnAutoresizingStyle(0L);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSOutlineView.setIntercellSpacing(nSSize);
        nSOutlineView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSOutlineView.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSOutlineView.setHeaderView(null);
        NSString nSString2 = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nSString);
            nSString.release();
            this.checkColumn.headerCell().setTitle(nSString2);
            nSOutlineView.addTableColumn(this.checkColumn);
            nSOutlineView.setOutlineTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long l = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(l, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setControlSize(1L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nSString);
        nSString.release();
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.setResizingMask(0L);
        this.firstColumn.headerCell().setTitle(nSString2);
        nSOutlineView.addTableColumn(this.firstColumn);
        nSOutlineView.setOutlineTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4L);
        this.firstColumn.setDataCell(this.dataCell);
        this.scrollView = nSScrollView;
        this.view = nSOutlineView;
    }

    void createItem(TreeColumn treeColumn, int n) {
        Object object;
        NSObject nSObject;
        Object object2;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == this.columns.length) {
            object2 = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object2, 0, this.columns.length);
            this.columns = object2;
        }
        if (this.columnCount == 0) {
            object2 = this.firstColumn;
            ((NSTableColumn)object2).setMinWidth(0.0);
            ((NSTableColumn)object2).setResizingMask(2L);
            this.firstColumn = null;
        } else {
            nSObject = (NSOutlineView)this.view;
            NSString nSString = NSString.string();
            object2 = (NSTableColumn)new NSTableColumn().alloc();
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(String.valueOf(++NEXT_ID));
            object2 = ((NSTableColumn)object2).initWithIdentifier((NSString)object);
            ((NSObject)object).release();
            ((NSTableColumn)object2).setMinWidth(0.0);
            ((NSTableColumn)object2).headerCell().setTitle(nSString);
            ((NSTableView)nSObject).addTableColumn((NSTableColumn)object2);
            int n2 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)nSObject).moveColumn(this.columnCount + n2, n + n2);
            ((NSTableColumn)object2).setDataCell(this.dataCell);
            if (n == 0) {
                ((NSOutlineView)nSObject).setOutlineTableColumn((NSTableColumn)object2);
            }
        }
        treeColumn.createJNIRef();
        nSObject = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object2).setHeaderCell((NSCell)nSObject);
        this.display.addWidget(nSObject, treeColumn);
        treeColumn.nsColumn = object2;
        ((NSTableColumn)object2).setWidth(0.0);
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        for (int i = 0; i < this.itemCount; ++i) {
            object = this.items[i];
            if (object == null || this.columnCount <= 1) continue;
            this.createColumn((TreeItem)object, n);
        }
    }

    void createItem(TreeItem treeItem, TreeItem treeItem2, int n) {
        Object object;
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem2 != null) {
            n2 = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n == -1) {
            n = n2;
        }
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == treeItemArray.length) {
            object = new TreeItem[treeItemArray.length + 4];
            System.arraycopy(treeItemArray, 0, object, 0, treeItemArray.length);
            treeItemArray = object;
            if (treeItem2 != null) {
                treeItem2.items = treeItemArray;
            } else {
                this.items = treeItemArray;
            }
        }
        System.arraycopy(treeItemArray, n, treeItemArray, n + 1, n2++ - n);
        treeItemArray[n] = treeItem;
        treeItem.items = new TreeItem[4];
        treeItem.handle = object = (SWTTreeItem)new SWTTreeItem().alloc().init();
        treeItem.createJNIRef();
        treeItem.register();
        if (treeItem2 != null) {
            treeItem2.itemCount = n2;
        } else {
            this.itemCount = n2;
        }
        this.ignoreExpand = true;
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            TreeItem[] treeItemArray2 = this.getSelection();
            if (treeItem2 != null) {
                nSOutlineView.reloadItem(treeItem2.handle, true);
            } else {
                nSOutlineView.reloadData();
            }
            this.selectItems(treeItemArray2, true);
        } else {
            this.reloadPending = true;
        }
        if (treeItem2 != null && treeItem2.itemCount == 1 && treeItem2.expanded) {
            nSOutlineView.expandItem(treeItem2.handle);
        }
        this.ignoreExpand = false;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.outlineViewFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    @Override
    void deselectAll(long l, long l2, long l3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1L) {
            return;
        }
        super.deselectAll(l, l2, l3);
    }

    @Override
    void deselectRow(long l, long l2, long l3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == l3) {
            return;
        }
        super.deselectRow(l, l2, l3);
    }

    public void deselectAll() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.deselectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        this.ignoreSelect = true;
        nSOutlineView.deselectRow(l);
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn treeColumn) {
        Object object;
        int n;
        int n2;
        for (n2 = 0; n2 < this.columnCount && this.columns[n2] != treeColumn; ++n2) {
        }
        for (n = 0; n < this.items.length; ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            object = this.items[n];
            if (object == null) continue;
            if (this.columnCount <= 1) {
                ((TreeItem)object).strings = null;
                ((TreeItem)object).images = null;
                ((TreeItem)object).cellBackground = null;
                ((TreeItem)object).cellForeground = null;
                ((TreeItem)object).cellFont = null;
                continue;
            }
            if (((TreeItem)object).strings != null) {
                objectArray2 = ((TreeItem)object).strings;
                if (n2 == 0) {
                    ((TreeItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                }
                objectArray = new String[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).strings = objectArray;
            } else if (n2 == 0) {
                ((TreeItem)object).text = "";
            }
            if (((TreeItem)object).images != null) {
                objectArray2 = ((TreeItem)object).images;
                if (n2 == 0) {
                    ((TreeItem)object).image = objectArray2[1];
                }
                objectArray = new Image[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).images = objectArray;
            } else if (n2 == 0) {
                ((TreeItem)object).image = null;
            }
            if (((TreeItem)object).cellBackground != null) {
                objectArray2 = ((TreeItem)object).cellBackground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).cellBackground = objectArray;
            }
            if (((TreeItem)object).cellForeground != null) {
                objectArray2 = ((TreeItem)object).cellForeground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).cellForeground = objectArray;
            }
            if (((TreeItem)object).cellFont == null) continue;
            objectArray2 = ((TreeItem)object).cellFont;
            objectArray = new Font[this.columnCount - 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n2);
            System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
            ((TreeItem)object).cellFont = objectArray;
        }
        n = this.indexOf(treeColumn.nsColumn);
        System.arraycopy(this.columns, n2 + 1, this.columns, n2, --this.columnCount - n2);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = treeColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.firstColumn.setResizingMask(0L);
            this.setScrollWidth();
        } else {
            if (n2 == 0) {
                ((NSOutlineView)this.view).setOutlineTableColumn(this.columns[0].nsColumn);
            }
            ((NSOutlineView)this.view).removeTableColumn(treeColumn.nsColumn);
        }
        object = ((NSOutlineView)this.view).tableColumns();
        int n3 = (int)((NSArray)object).count();
        block2: for (int i = n; i < n3; ++i) {
            long l = ((NSArray)object).objectAtIndex((long)((long)i)).id;
            for (int j = 0; j < this.columnCount; ++j) {
                if (this.columns[j].nsColumn.id != l) continue;
                this.columns[j].sendEvent(10);
                continue block2;
            }
        }
    }

    void destroyItem(TreeItem treeItem) {
        int n;
        TreeItem[] treeItemArray;
        int n2;
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            n2 = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        for (n = 0; n < n2 && treeItemArray[n] != treeItem; ++n) {
        }
        System.arraycopy(treeItemArray, n + 1, treeItemArray, n, --n2 - n);
        treeItemArray[n2] = null;
        if (treeItem2 != null) {
            treeItem2.itemCount = n2;
        } else {
            this.itemCount = n2;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            if (treeItem2 != null) {
                nSOutlineView.reloadItem(treeItem2.handle, true);
            } else {
                nSOutlineView.reloadData();
            }
        } else {
            this.reloadPending = true;
        }
        this.setScrollWidth();
        if (this.itemCount == 0) {
            this.imageBounds = null;
        }
        if (this.insertItem == treeItem) {
            this.insertItem = null;
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return false;
    }

    @Override
    void drawBackgroundInClipRect(long l, long l2, NSRect nSRect) {
        super.drawViewBackgroundInRect(l, l2, nSRect);
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    @Override
    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        Color color;
        boolean bl2 = this.hooks(40);
        boolean bl3 = this.hooks(42);
        boolean bl4 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
        long l4 = nSOutlineView.rowForItem(new id(lArray[0]));
        if (l4 == -1L) {
            return;
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(lArray[0]);
        if (treeItem == null) {
            return;
        }
        OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
        long l5 = lArray[0];
        long l6 = nSOutlineView.tableColumns().indexOfObjectIdenticalTo(new id(l5));
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l5) continue;
            n = i;
            break;
        }
        Color color2 = color = treeItem.cellBackground != null ? treeItem.cellBackground[n] : null;
        if (color == null) {
            color = treeItem.background;
        }
        boolean bl5 = color != null;
        boolean bl6 = true;
        boolean bl7 = bl = nSTextFieldCell.isHighlighted();
        boolean bl8 = this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl && (bl2 || bl3)) {
            color4 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(l, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n3 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSOutlineView.rectOfColumn(l6);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSOutlineView.rectOfRow(l4);
            nSRect2.width = nSRect3.width;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl3 || bl2) {
            NSRect nSRect4 = nSOutlineView.frameOfCellAtColumn(l6, l4);
            d = nSRect.x - nSRect4.x;
            d2 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                d -= 0.5;
                d2 -= 0.5;
            }
        }
        int n4 = (int)(nSRect.x - d);
        int n5 = (int)(nSRect.y - d2);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl4) {
            this.sendMeasureItem(treeItem, nSTextFieldCell.isHighlighted(), n, nSSize);
        }
        Color color5 = null;
        if (bl2) {
            nSGraphicsContext.saveGraphicsState();
            object5 = NSAffineTransform.transform();
            ((NSAffineTransform)object5).translateXBy(d, d2);
            ((NSAffineTransform)object5).concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n));
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                object2 = color4;
                ((GC)object3).setBackground(color3);
            } else {
                object2 = treeItem.getForeground(n);
                ((GC)object3).setBackground(treeItem.getBackground(n));
            }
            ((GC)object3).setForeground((Color)object2);
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = treeItem;
            ((Event)object).gc = object3;
            ((Event)object).index = n;
            ((Event)object).detail = 16;
            if (bl5) {
                ((Event)object).detail |= 8;
            }
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = (int)nSRect2.x;
            ((Event)object).y = (int)nSRect2.y;
            ((Event)object).width = (int)nSRect2.width;
            ((Event)object).height = (int)nSRect2.height;
            this.sendEvent(40, (Event)object);
            if (!((Event)object).doit) {
                bl7 = false;
                bl5 = false;
                bl6 = false;
            } else {
                bl5 = bl5 && (((Event)object).detail & 8) != 0;
                bl6 = (((Event)object).detail & 0x10) != 0;
                boolean bl9 = bl7 = bl7 && (((Event)object).detail & 2) != 0;
            }
            if (!bl7 && bl) {
                color5 = Color.cocoa_new(this.display, ((GC)object3).getForeground().handle);
            }
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (treeItem.isDisposed()) {
                return;
            }
            if (bl7 && ((this.style & 0x8000) == 0 || bl8)) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSOutlineView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        } else if (bl && (this.style & 0x8000) != 0 && !bl8) {
            color5 = treeItem.getForeground(n);
        }
        if (bl5 && !bl7) {
            nSGraphicsContext.saveGraphicsState();
            object5 = color.handle;
            object4 = NSColor.colorWithDeviceRed((double)object5[0], (double)object5[1], (double)object5[2], 1.0);
            ((NSColor)object4).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (treeItem == this.insertItem && this.insertItem != null && !this.insertItem.isDisposed()) {
            nSGraphicsContext.saveGraphicsState();
            object5 = nSTextFieldCell.titleRectForBounds(nSRect);
            object4 = new GCData();
            ((GCData)object4).paintRect = object5;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setClipping((int)(((NSRect)object5).x - d), (int)(((NSRect)object5).y - d2), (int)((NSRect)object5).width, (int)((NSRect)object5).height);
            object2 = this.insertItem.getImageBounds(0).union(this.insertItem.getBounds());
            object = this.getClientArea();
            int n6 = ((Rectangle)object).x + ((Rectangle)object).width;
            int n7 = this.insertBefore ? ((Rectangle)object2).y : ((Rectangle)object2).y + ((Rectangle)object2).height - 1;
            ((GC)object3).drawLine(((Rectangle)object2).x, n7, n6, n7);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl6) {
            if ((!this.drawExpansion || bl4) && nSImage != null) {
                object5 = new NSRect();
                ((NSRect)object5).x = nSRect.x + 3.0;
                ((NSRect)object5).y = nSRect.y + (double)((float)Math.ceil((nSRect.height - (double)this.imageBounds.height) / 2.0));
                ((NSRect)object5).width = this.imageBounds.width;
                ((NSRect)object5).height = this.imageBounds.height;
                object4 = new NSRect();
                object3 = nSImage.size();
                ((NSRect)object4).width = ((NSSize)object3).width;
                ((NSRect)object4).height = ((NSSize)object3).height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object2 = NSAffineTransform.transform();
                ((NSAffineTransform)object2).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object2).translateXBy(0.0, -(((NSRect)object5).height + 2.0 * ((NSRect)object5).y));
                ((NSAffineTransform)object2).concat();
                nSImage.drawInRect((NSRect)object5, (NSRect)object4, 2L, 1.0);
                nSGraphicsContext.restoreGraphicsState();
                int n8 = this.imageBounds.width + 3;
                nSRect.x += (double)n8;
                nSRect.width -= (double)n8;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl10 = false;
            if (color5 != null) {
                object4 = color5.handle;
                if (object4[0] == 0.0 && object4[1] == 0.0 && object4[2] == 0.0 && object4[3] == 1.0) {
                    object3 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object2 = new NSRange();
                    ((NSRange)object2).length = ((NSAttributedString)object3).length();
                    ((NSMutableAttributedString)object3).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object2);
                    int n9 = this.columnCount == 0 ? 16384 : this.columns[n].style & 0x1024000;
                    NSSize nSSize3 = ((NSAttributedString)object3).size();
                    NSRect nSRect5 = new NSRect();
                    nSRect5.x = nSRect.x + 2.0;
                    nSRect5.y = nSRect.y;
                    nSRect5.width = nSRect.width - 2.0;
                    switch (n9) {
                        case 0x1000000: {
                            nSRect5.width -= 2.0;
                            break;
                        }
                        case 131072: {
                            if (!(nSRect.width > nSSize3.width)) break;
                            nSRect5.width -= 2.0;
                        }
                    }
                    nSRect5.height = nSRect.height;
                    if (nSRect5.height > nSSize3.height) {
                        nSRect5.y += (nSRect5.height - nSSize3.height) / 2.0;
                        nSRect5.height = nSSize3.height;
                    }
                    ((NSAttributedString)object3).drawInRect(nSRect5);
                    ((NSObject)object3).release();
                } else {
                    object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], (double)object4[3]);
                    nSTextFieldCell.setTextColor((NSColor)object3);
                    bl10 = true;
                }
            } else {
                bl10 = true;
            }
            if (bl10) {
                object4 = nSTextFieldCell.attributedStringValue();
                object3 = ((NSAttributedString)object4).size();
                if (nSRect.height > ((NSSize)object3).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object3).height) / 2.0;
                    nSRect.height = ((NSSize)object3).height;
                }
                super.drawInteriorWithFrame_inView(l, l2, nSRect, l3);
            }
        }
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(d, d2);
            nSAffineTransform.concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n));
            if (bl7) {
                ((GC)object3).setForeground(color4);
                ((GC)object3).setBackground(color3);
            } else {
                ((GC)object3).setForeground(color5 != null ? color5 : treeItem.getForeground(n));
                ((GC)object3).setBackground(treeItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object2 = new Event();
            ((Event)object2).item = treeItem;
            ((Event)object2).gc = object3;
            ((Event)object2).index = n;
            if (bl6) {
                ((Event)object2).detail |= 0x10;
            }
            if (bl5) {
                ((Event)object2).detail |= 8;
            }
            if (bl) {
                ((Event)object2).detail |= 2;
            }
            ((Event)object2).x = n4;
            ((Event)object2).y = n5;
            ((Event)object2).width = n2;
            ((Event)object2).height = n3;
            this.sendEvent(42, (Event)object2);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    @Override
    void drawWithExpansionFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(l, l2, nSRect, l3);
        this.drawExpansion = false;
    }

    @Override
    void expandItem_expandChildren(long l, long l2, long l3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l3);
        if (treeItem == null) {
            return;
        }
        if (!this.ignoreExpand) {
            treeItem.sendExpand(true, bl);
        }
        this.ignoreExpand = true;
        super.expandItem_expandChildren(l, l2, l3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        if (!bl) {
            this.ignoreExpand = true;
            TreeItem[] treeItemArray = treeItem.items;
            for (int i = 0; i < treeItem.itemCount; ++i) {
                if (treeItemArray[i] == null) continue;
                treeItemArray[i].updateExpanded();
            }
            this.ignoreExpand = false;
        }
        this.setScrollWidth(false, treeItem.items, true);
    }

    @Override
    NSRect expansionFrameWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        if (this.toolTipText == null) {
            NSRect nSRect2;
            NSRect nSRect3 = super.expansionFrameWithFrame_inView(l, l2, nSRect, l3);
            NSCell nSCell = new NSCell(l);
            NSAttributedString nSAttributedString = nSCell.attributedStringValue();
            NSSize nSSize = nSAttributedString.size();
            if (nSRect3.width != 0.0 && nSRect3.height != 0.0) {
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    NSSize nSSize2 = nSCell.cellSize();
                    nSRect2.width = nSSize2.width;
                } else {
                    nSRect2 = nSRect3;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                }
            } else {
                Object object;
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    object = nSCell.cellSize();
                    nSRect2.width = ((NSSize)object).width;
                } else {
                    nSRect2 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(l, OS.sel_cellSize);
                    nSRect2.width = ((NSSize)object).width;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                } else {
                    object = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect((NSRect)object, nSRect2, (NSRect)object);
                    if (OS.NSEqualRects(nSRect2, (NSRect)object)) {
                        return new NSRect();
                    }
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    @Override
    Widget findTooltip(NSPoint nSPoint) {
        long l;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (l = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1L) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(l);
            for (int i = 0; i < this.columnCount; ++i) {
                TreeColumn treeColumn = this.columns[i];
                if (treeColumn.nsColumn.id != id2.id) continue;
                return treeColumn;
            }
        }
        return super.findTooltip(nSPoint);
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    @Override
    public Rectangle getClientArea() {
        NSTableHeaderView nSTableHeaderView;
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        if (OS.VERSION_MMB < OS.VERSION_MMB(10, 11, 0) && (nSTableHeaderView = ((NSTableView)this.view).headerView()) != null) {
            int n = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    TreeColumn getColumn(id id2) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i];
        }
        return null;
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n = 0;
        while (n < this.columnCount) {
            TreeColumn treeColumn = this.columns[n];
            int n2 = this.indexOf(treeColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n2;
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).headerView() != null;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(null, n, true);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n = (int)nSOutlineView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        NSRect nSRect = nSOutlineView.frameOfOutlineCellAtRow(n);
        if (OS.NSPointInRect(nSPoint, nSRect)) {
            return null;
        }
        id id2 = nSOutlineView.itemAtRow(n);
        Widget widget = this.display.getWidget(id2.id);
        if (widget != null && widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    int getItemCount(TreeItem treeItem) {
        return treeItem == null ? this.itemCount : treeItem.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).rowHeight() + 1;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] treeItemArray = new TreeItem[this.itemCount];
        for (int i = 0; i < this.itemCount; ++i) {
            treeItemArray[i] = this._getItem(null, i, true);
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (nSOutlineView.numberOfSelectedRows() == 0L) {
            return new TreeItem[0];
        }
        NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        TreeItem[] treeItemArray = new TreeItem[n];
        for (int i = 0; i < n; ++i) {
            id id2 = nSOutlineView.itemAtRow(lArray[i]);
            Widget widget = this.display.getWidget(id2.id);
            if (widget == null || !(widget instanceof TreeItem)) continue;
            treeItemArray[i] = (TreeItem)widget;
        }
        return treeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).numberOfSelectedRows();
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        long l;
        NSView nSView;
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && (nSView = ((NSTableView)this.view).headerView()) != null) {
            int n = (int)nSView.bounds().height;
            nSPoint.y += (double)n;
        }
        if ((l = ((NSTableView)(nSView = (NSOutlineView)this.view)).rowAtPoint(nSPoint)) == -1L) {
            return null;
        }
        id id2 = ((NSOutlineView)nSView).itemAtRow(l);
        return (TreeItem)this.display.getWidget(id2.id);
    }

    @Override
    NSRect headerRectOfColumn(long l, long l2, long l3) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(l, l2, l3);
        }
        if (l3 == 0L) {
            NSRect nSRect = this.callSuperRect(l, l2, l3);
            nSRect.width = 0.0;
            return nSRect;
        }
        if (l3 == 1L) {
            NSRect nSRect = this.callSuperRect(l, l2, l3);
            nSRect.width += this.checkColumn.width() + 1.0;
            nSRect.x -= this.checkColumn.width() + 1.0;
            return nSRect;
        }
        return this.callSuperRect(l, l2, l3);
    }

    @Override
    void highlightSelectionInClipRect(long l, long l2, long l3) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
        this.callSuper(l, l2, nSRect);
    }

    @Override
    long hitTestForEvent(long l, long l2, long l3, NSRect nSRect, long l4) {
        return this.callSuper(l, l2, l3, nSRect, l4);
    }

    @Override
    long image(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_IMAGE, lArray);
        return lArray[0];
    }

    @Override
    NSRect imageRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSRect.x += 3.0;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != null) {
            return -1;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (treeItem != this.items[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    @Override
    void keyDown(long l, long l2, long l3) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(l, l2, l3);
    }

    @Override
    long menuForEvent(long l, long l2, long l3) {
        if (l != this.headerView.id) {
            NSPoint nSPoint;
            long l4;
            NSEvent nSEvent = new NSEvent(l3);
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(l4 = nSOutlineView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(l4);
                nSOutlineView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(l, l2, l3);
    }

    @Override
    void mouseDown(long l, long l2, long l3) {
        NSEvent nSEvent;
        if (l == this.view.id && ((nSEvent = new NSEvent(l3)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(l, l2, l3);
    }

    @Override
    void mouseDownSuper(long l, long l2, long l3) {
        NSRect nSRect;
        NSRect nSRect2;
        int n;
        NSCell nSCell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean bl = false;
        NSEvent nSEvent = new NSEvent(l3);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n2 = (int)nSOutlineView.rowAtPoint(nSPoint);
        NSObject nSObject = null;
        if (n2 != -1) {
            nSObject = new NSObject(nSOutlineView.itemAtRow(n2));
        }
        if (n2 != -1 && (this.style & 0x20) != 0 && (nSCell = nSOutlineView.preparedCellAtColumn(n = (int)nSOutlineView.columnAtPoint(nSPoint), n2)) != null && nSCell.isKindOfClass(OS.class_NSButtonCell) && nSCell.isEnabled() && OS.NSPointInRect(nSPoint, nSRect2 = nSCell.imageRectForBounds(nSOutlineView.frameOfCellAtColumn(n, n2)))) {
            this.preventSelect = true;
            bl = true;
        }
        if (!bl && n2 != -1 && (nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1L && nSOutlineView.isRowSelected(n2) && !OS.NSPointInRect(nSPoint, nSRect = nSOutlineView.frameOfOutlineCellAtRow(n2))) {
            this.selectedRowIndex = n2;
        }
        this.didSelect = false;
        if (nSObject != null) {
            nSObject.retain();
        }
        super.mouseDownSuper(l, l2, l3);
        if (nSObject != null) {
            nSObject.release();
        }
        this.didSelect = false;
    }

    @Override
    boolean needsPanelToBecomeKey(long l, long l2) {
        return false;
    }

    @Override
    long nextState(long l, long l2) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.clickedRow();
        if (n == -1) {
            n = (int)nSOutlineView.selectedRow();
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((long)((long)n)).id);
        if (treeItem.grayed) {
            return treeItem.checked ? 0L : -1L;
        }
        return treeItem.checked ? 0L : 1L;
    }

    @Override
    long outlineView_child_ofItem(long l, long l2, long l3, long l4, long l5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l5);
        TreeItem treeItem2 = this._getItem(treeItem, (int)l4, true);
        return treeItem2.handle.id;
    }

    @Override
    void outlineView_didClickTableColumn(long l, long l2, long l3, long l4) {
        TreeColumn treeColumn = this.getColumn(new id(l4));
        if (treeColumn == null) {
            return;
        }
        treeColumn.sendSelectionEvent(13);
    }

    @Override
    long outlineView_objectValueForTableColumn_byItem(long l, long l2, long l3, long l4, long l5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l5);
        this.checkData(treeItem);
        if (this.checkColumn != null && l4 == this.checkColumn.id) {
            NSNumber nSNumber = treeItem.checked && treeItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(treeItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l4) continue;
            return treeItem.createString((int)i).id;
        }
        return treeItem.createString((int)0).id;
    }

    @Override
    boolean outlineView_isItemExpandable(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return true;
        }
        return ((TreeItem)this.display.getWidget((long)l4)).itemCount != 0;
    }

    @Override
    long outlineView_numberOfChildrenOfItem(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return this.itemCount;
        }
        return ((TreeItem)this.display.getWidget((long)l4)).itemCount;
    }

    @Override
    boolean outlineView_shouldExpandItem_item(long l, long l2, long l3, long l4) {
        return this.shouldExpand;
    }

    @Override
    boolean outlineView_shouldReorderColumn_toColumn(long l, long l2, long l3, long l4, long l5) {
        if ((this.style & 0x20) != 0) {
            if (l4 == 0L) {
                return false;
            }
            if (l5 == 0L) {
                return false;
            }
        }
        NSOutlineView nSOutlineView = new NSOutlineView(l3);
        id id2 = nSOutlineView.tableColumns().objectAtIndex(l4);
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i].movable;
        }
        return true;
    }

    @Override
    boolean outlineView_shouldTrackCell_forTableColumn_item(long l, long l2, long l3, long l4, long l5, long l6) {
        if ((this.style & 0x20) != 0 && new NSCell(l4).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l7 = nSOutlineView.rowForItem(new id(l6));
        return nSOutlineView.isRowSelected(l7);
    }

    @Override
    void outlineView_willDisplayCell_forTableColumn_item(long l, long l2, long l3, long l4, long l5, long l6) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            return;
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(l6);
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != l5) continue;
            n = i;
            break;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l4);
        OS.object_setInstanceVariable(l4, Display.SWT_ROW, l6);
        OS.object_setInstanceVariable(l4, Display.SWT_COLUMN, l5);
        Image image = n == 0 ? treeItem.image : (treeItem.images == null ? null : treeItem.images[n]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = treeItem.cellForeground != null ? treeItem.cellForeground[n] : null;
                if (color == null) {
                    color = treeItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n2 = (this.style & 0x4000000) != 0 ? 1 : 0;
        int n3 = 0;
        if (this.columnCount > 0) {
            int n4 = this.columns[n].style;
            if ((n4 & 0x1000000) != 0) {
                n3 = 2;
            } else if ((n4 & 0x20000) != 0) {
                n3 = 1;
            }
        }
        Font font2 = font = treeItem.cellFont != null ? treeItem.cellFont[n] : null;
        if (font == null) {
            font = treeItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2L);
            nSMutableParagraphStyle.setAlignment(n3);
            nSMutableParagraphStyle.setBaseWritingDirection(n2);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n3);
            nSTextFieldCell.setBaseWritingDirection(n2);
        }
    }

    @Override
    void outlineViewColumnDidMove(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSOldColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSNewColumn");
        id id3 = nSDictionary.valueForKey(nSString);
        nSString.release();
        int n = new NSNumber(id2).intValue();
        int n2 = new NSNumber(id3).intValue();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        NSArray nSArray = nSOutlineView.tableColumns();
        for (int i = n3; i <= n4; ++i) {
            id id4 = nSArray.objectAtIndex(i);
            TreeColumn treeColumn = this.getColumn(id4);
            if (treeColumn == null) continue;
            treeColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
        this.headerView.setNeedsDisplay(true);
    }

    @Override
    void outlineViewColumnDidResize(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSTableColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        TreeColumn treeColumn = this.getColumn(id2);
        if (treeColumn == null) {
            return;
        }
        treeColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = this.indexOf(treeColumn.nsColumn);
        if (n == -1) {
            return;
        }
        NSArray nSArray = nSOutlineView.tableColumns();
        int n2 = (int)nSOutlineView.numberOfColumns();
        for (int i = n + 1; i < n2; ++i) {
            id2 = nSArray.objectAtIndex(i);
            treeColumn = this.getColumn(id2);
            if (treeColumn == null) continue;
            treeColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
    }

    @Override
    void scrollClipViewToPoint(long l, long l2, long l3, NSPoint nSPoint) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(l, l2, l3, nSPoint);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSOutlineView)this.view).headerView() != null && nSPoint.x <= (double)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1L));
            }
        }
    }

    @Override
    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.selectedRow();
        if (n == -1) {
            this.sendSelectionEvent(13);
        } else {
            id id2 = nSOutlineView.itemAtRow(n);
            TreeItem treeItem = (TreeItem)this.display.getWidget(id2.id);
            Event event = new Event();
            event.item = treeItem;
            event.index = n;
            this.sendSelectionEvent(13, event, false);
        }
    }

    @Override
    void outlineViewSelectionDidChange(long l, long l2, long l3) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    @Override
    void outlineViewSelectionIsChanging(long l, long l2, long l3) {
        this.didSelect = true;
        this.sendSelection();
    }

    @Override
    void outlineView_setObjectValue_forTableColumn_byItem(long l, long l2, long l3, long l4, long l5, long l6) {
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            TreeItem treeItem = (TreeItem)this.display.getWidget(l6);
            treeItem.checked = !treeItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
            treeItem.redraw(-1);
        }
    }

    @Override
    boolean outlineView_writeItems_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        Item item;
        int n;
        for (n = 0; n < this.items.length; ++n) {
            item = this.items[n];
            if (item == null || item.isDisposed()) continue;
            ((TreeItem)item).release(false);
        }
        this.items = null;
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = 0; i < this.items.length; ++i) {
            TreeItem treeItem = this.items[i];
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
        this.items = new TreeItem[4];
        this.itemCount = 0;
        this.imageBounds = null;
        this.insertItem = null;
        this.ignoreSelect = true;
        ((NSOutlineView)this.view).reloadData();
        this.ignoreSelect = false;
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    @Override
    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                item = this.columns[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setImage(long l, long l2, long l3) {
        OS.object_setInstanceVariable(l, Display.SWT_IMAGE, l3);
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem != null && treeItem.isDisposed()) {
            this.error(5);
        }
        TreeItem treeItem2 = this.insertItem;
        this.insertItem = treeItem;
        this.insertBefore = bl;
        if (treeItem2 != null && !treeItem2.isDisposed()) {
            treeItem2.redraw(-1);
        }
        if (treeItem != null) {
            treeItem.redraw(-1);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.selectAll(null);
        this.ignoreSelect = false;
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
        nSIndexSet = nSIndexSet.initWithIndex(l);
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
        this.ignoreSelect = false;
        nSIndexSet.release();
    }

    @Override
    void selectRowIndexes_byExtendingSelection(long l, long l2, long l3, boolean bl) {
        NSIndexSet nSIndexSet;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (nSIndexSet = new NSIndexSet(l3)).count() == 0L) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(l, l2, l3, bl);
    }

    @Override
    void sendDoubleSelection() {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.clickedRow();
        if (n == -1) {
            n = (int)nSOutlineView.selectedRow();
        }
        if (n != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSOutlineView.tableColumns();
                int n2 = (int)nSOutlineView.clickedColumn();
                if (n2 != -1) {
                    id id2 = ((NSArray)object).objectAtIndex(n2);
                    if (id2.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            object = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((long)((long)n)).id);
            Event event = new Event();
            event.item = object;
            this.sendSelectionEvent(14, event, false);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return bl;
    }

    void sendMeasureItem(TreeItem treeItem, boolean bl, int n, NSSize nSSize) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n3 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSOutlineView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(treeItem.getFont(n));
        Event event = new Event();
        event.item = treeItem;
        event.gc = gC;
        event.index = n;
        event.width = n2;
        event.height = n3;
        if (bl && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !treeItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n3 < event.height) {
                nSOutlineView.setRowHeight(event.height);
            }
            if (n2 != event.width && this.columnCount == 0 && n == 0) {
                treeItem.width = event.width;
                treeItem.width = (int)((double)treeItem.width + nSOutlineView.indentationPerLevel() * (double)(1L + nSOutlineView.levelForItem(treeItem.handle)));
                if (this.setScrollWidth(treeItem)) {
                    nSOutlineView.setNeedsDisplay(true);
                }
            }
        }
    }

    @Override
    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        if (n == 29) {
            this.dragDetected = true;
        } else if (n == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                Widget widget;
                NSOutlineView nSOutlineView = (NSOutlineView)this.view;
                NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
                int n2 = (int)nSIndexSet.count();
                long[] lArray = new long[n2];
                nSIndexSet.getIndexes(lArray, n2, 0L);
                for (int i = 0; i < n2; ++i) {
                    if (lArray[i] == (long)this.selectedRowIndex) continue;
                    this.ignoreSelect = true;
                    nSOutlineView.deselectRow(lArray[i]);
                    this.ignoreSelect = false;
                }
                Event event = new Event();
                id id2 = nSOutlineView.itemAtRow(this.selectedRowIndex);
                if (id2 != null && (widget = this.display.getWidget(id2.id)) != null && widget instanceof TreeItem) {
                    event.item = this.display.getWidget(id2.id);
                    this.sendSelectionEvent(13, event, false);
                }
                this.selectedRowIndex = -1;
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    void selectItems(TreeItem[] treeItemArray, boolean bl) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int n = treeItemArray.length;
        for (int i = 0; i < n; ++i) {
            if (treeItemArray[i] == null) continue;
            if (treeItemArray[i].isDisposed()) {
                if (bl) continue;
                this.error(5);
            }
            TreeItem treeItem = treeItemArray[i];
            if (!bl) {
                this.showItem(treeItemArray[i], false);
            }
            nSMutableIndexSet.addIndex(nSOutlineView.rowForItem(treeItem.handle));
        }
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSMutableIndexSet, false);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    @Override
    NSRect titleRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            int n = this.imageBounds.width + 3;
            nSRect.x += (double)n;
            nSRect.width -= (double)n;
        }
        return nSRect;
    }

    @Override
    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (nArray[i] == nArray2[i]) continue;
            bl = true;
        }
        if (bl) {
            TreeColumn treeColumn;
            int n;
            int n2;
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n3 = (this.style & 0x20) != 0 ? 1 : 0;
            for (int i = 0; i < nArray2.length; ++i) {
                n2 = nArray2[i];
                nArray3[n2] = (int)nSOutlineView.rectOfColumn((long)((long)(i + n3))).x;
            }
            int[] nArray4 = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                treeColumn = this.columns[n];
                int n4 = this.indexOf(treeColumn.nsColumn);
                int n5 = n2 + n3;
                nSOutlineView.moveColumn(n4, n5);
                nArray4[n] = (int)nSOutlineView.rectOfColumn((long)((long)n5)).x;
            }
            TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
            for (n = 0; n < this.columnCount; ++n) {
                treeColumn = treeColumnArray[n];
                if (treeColumn.isDisposed() || nArray4[n] == nArray3[n]) continue;
                treeColumn.sendEvent(10);
            }
        }
    }

    @Override
    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth();
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setHeaderView(bl ? this.headerView : null);
        this.scrollView.tile();
    }

    public void setItemCount(int n) {
        this.checkWidget();
        this.checkItems();
        n = Math.max(0, n);
        this.setItemCount(null, n);
    }

    void setItemCount(TreeItem treeItem, int n) {
        boolean bl;
        int n2 = this.getItemCount(treeItem);
        if (n == n2) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n3 = Math.max(4, (n + 3) / 4 * 4);
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        boolean bl2 = bl = treeItem == null || treeItem.getExpanded();
        if (n < n2) {
            if (treeItem == null) {
                this.itemCount = n;
            } else {
                treeItem.itemCount = n;
            }
            TreeItem[] treeItemArray2 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            for (int i = n; i < n2; ++i) {
                TreeItem treeItem2 = treeItemArray[i];
                if (treeItem2 == null || treeItem2.isDisposed()) continue;
                treeItem2.release(false);
            }
            this.selectItems(treeItemArray2, true);
            TreeItem[] treeItemArray3 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray3, 0, n);
            }
            treeItemArray = treeItemArray3;
            if (treeItem == null) {
                this.items = treeItemArray3;
            } else {
                treeItem.items = treeItemArray3;
            }
        } else if ((this.style & 0x10000000) == 0) {
            for (int i = n2; i < n; ++i) {
                new TreeItem(this, treeItem, 0, i, true);
            }
        } else {
            TreeItem[] treeItemArray4 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray4, 0, n2);
            }
            treeItemArray = treeItemArray4;
            if (treeItem == null) {
                this.items = treeItemArray4;
                this.itemCount = n;
            } else {
                treeItem.items = treeItemArray4;
                treeItem.itemCount = n;
            }
            TreeItem[] treeItemArray5 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            this.selectItems(treeItemArray5, true);
            if (treeItem != null && n2 == 0 && treeItem.expanded) {
                this.ignoreExpand = true;
                nSOutlineView.expandItem(treeItem.handle);
                this.ignoreExpand = false;
            }
        }
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n == -1) {
            this.setItemHeight(null, null, true);
        } else {
            ((NSOutlineView)this.view).setRowHeight(n);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        double d = nSFont.ascender();
        double d2 = -nSFont.descender() + nSFont.leading();
        int n = (int)Math.ceil(d + d2) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n = Math.max(n, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl || nSTableView.rowHeight() < (double)n) {
            nSTableView.setRowHeight(n);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setUsesAlternatingRowBackgroundColors(bl);
        ((NSOutlineView)this.view).setGridStyleMask(bl ? 1L : 0L);
    }

    @Override
    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.checkItems();
            this.setScrollWidth();
        }
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(true, this.items, true);
    }

    boolean setScrollWidth(boolean bl, TreeItem[] treeItemArray, boolean bl2) {
        int n;
        if (treeItemArray == null) {
            return false;
        }
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        GC gC = new GC(this);
        int n2 = this.calculateWidth(treeItemArray, 0, gC, bl2);
        gC.dispose();
        if (!bl && (n = (int)this.firstColumn.width()) >= n2) {
            return false;
        }
        this.firstColumn.setWidth(n2);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    boolean setScrollWidth(TreeItem treeItem) {
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null && !treeItem2.getExpanded()) {
            return false;
        }
        GC gC = new GC(this);
        int n = treeItem.calculateWidth(0, gC);
        gC.dispose();
        int n2 = (int)this.firstColumn.width();
        if (n2 < n) {
            this.firstColumn.setWidth(n);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    @Override
    void setShouldExpandItem(long l, long l2, boolean bl) {
        this.shouldExpand = bl;
    }

    @Override
    void setShouldScrollClipView(long l, long l2, boolean bl) {
        this.shouldScroll = bl;
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.checkItems();
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectItems(treeItemArray, false);
        if (treeItemArray.length > 0) {
            for (int i = 0; i < treeItemArray.length; ++i) {
                TreeItem treeItem = treeItemArray[i];
                if (treeItem == null) continue;
                this.showItem(treeItem, true);
                break;
            }
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn == this.sortColumn) {
            return;
        }
        this.setSort(treeColumn, this.sortDirection);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, n);
    }

    void setSort(TreeColumn treeColumn, int n) {
        NSImage nSImage = null;
        NSTableColumn nSTableColumn = null;
        if (treeColumn != null) {
            nSTableColumn = treeColumn.nsColumn;
            if (n == 1024) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (n == 128) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != treeColumn) {
            nSTableView.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        nSTableView.setHighlightedTableColumn(nSTableColumn);
        nSTableView.setIndicatorImage(nSImage, nSTableColumn);
        this.sortDirection = n;
        this.sortColumn = treeColumn;
    }

    public void setTopItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, false);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        if (l == -1L) {
            return;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSOutlineView.frameOfCellAtColumn((long)0L, (long)l).y;
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0) && nSOutlineView.headerView() != null) {
            NSRect nSRect = this.headerView.frame();
            nSPoint.y -= nSRect.y + nSRect.height;
        }
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n = this.indexOf(treeColumn.nsColumn);
        if (0 > n || n >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSOutlineView)this.view).scrollColumnToVisible(n);
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, true);
    }

    void showItem(TreeItem treeItem, boolean bl) {
        Object object;
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            this.showItem(treeItem2, false);
            if (!treeItem2.getExpanded()) {
                treeItem2.setExpanded(true);
                object = new Event();
                ((Event)object).item = treeItem2;
                this.sendEvent(17, (Event)object);
            }
        }
        if (bl) {
            object = (NSOutlineView)this.view;
            ((NSTableView)object).scrollRowToVisible(((NSOutlineView)object).rowForItem(treeItem.handle));
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length > 0) {
            this.checkData(treeItemArray[0]);
            this.showItem(treeItemArray[0], true);
        }
    }

    @Override
    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl, this.headerView);
    }
}

