/*
 * Decompiled with CFR 0.152.
 */
package in.lapin.fenrir.WCCF;

import in.lapin.fenrir.WCCF.ColorSettingsFrame;
import in.lapin.fenrir.WCCF.FormationFrame;
import in.lapin.fenrir.WCCF.KpInfoFrame;
import in.lapin.fenrir.WCCF.OwnCardListFrame;
import in.lapin.fenrir.WCCF.Player;
import in.lapin.fenrir.WCCF.ResponceFrame;
import in.lapin.fenrir.WCCF.SingleCardFrame;
import in.lapin.fenrir.WCCF.SplashFrame;
import in.lapin.fenrir.WCCF.TeamFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MainControl {
    private static List<Player> all;
    private static List<Player> have;
    private static List<Player> team;
    private static List<String[]> teamkp;
    private static List<String[]> nationalkp;
    private static List<String[]> combikp;
    private static List<String[]> rarekp;
    private static List<String[]> kpinfo;
    private Logger logger;
    private Player vo;
    private Player player1;
    private Player player2;
    private Player player3;
    private Player player4;
    private Player player5;
    private Player player6;
    private Player player7;
    private Player player8;
    private Player player9;
    private Player player10;
    private Player player11;
    private Player player12;
    private Player player13;
    private Player player14;
    private Player player15;
    private Player player16;
    private String Formation = "4-4-2(Diamond)";
    private Label label;
    private Object source;
    private int lbl1x;
    private int lbl1y;
    private int lbl2x;
    private int lbl2y;
    private int lbl3x;
    private int lbl3y;
    private int lbl4x;
    private int lbl4y;
    private int lbl5x;
    private int lbl5y;
    private int lbl6x;
    private int lbl6y;
    private int lbl7x;
    private int lbl7y;
    private int lbl8x;
    private int lbl8y;
    private int lbl9x;
    private int lbl9y;
    private int lbl10x;
    private int lbl10y;
    private String kp1 = "";
    private String kp2 = "";
    private String kp3 = "";
    private boolean useColor = true;
    private TeamFrame tf;
    private FormationFrame ff;
    private ResponceFrame rf;
    private SingleCardFrame scf;
    private OwnCardListFrame oclf;
    private KpInfoFrame kif;
    private ColorSettingsFrame csf;
    private SplashFrame sf;
    private boolean changeData = false;
    private int vpos = 0;
    private int cpos = 0;
    public static final int cUp = 1;
    public static final int cDown = 2;
    private Color FW_BA;
    private Color FW_FO;
    private Color MF_BA;
    private Color MF_FO;
    private Color DF_BA;
    private Color DF_FO;
    private Color GK_BA;
    private Color GK_FO;
    private Color HOLE_BA;
    private Color HOLE_FO;
    private Color KOLE_BA;
    private Color KOLE_FO;
    private Color SATLE_BA;
    private Color SATLE_FO;
    private Color ATLERE_BA;
    private Color ATLERE_FO;
    private Color ATLE_BA;
    private Color ATLE_FO;
    private Color LEOC_BA;
    private Color LEOC_FO;
    private Color LE_BA;
    private Color LE_FO;
    private Color RE_BA;
    private Color RE_FO;
    private Color SP_BA;
    private Color SP_FO;
    private Color RARE_BA;
    private Color RARE_FO;
    private Color KOJINRARE_BA;
    private Color KOJINRARE_FO;
    private Color COMBIRARE_BA;
    private Color COMBIRARE_FO;
    private Point pnt;
    private String openFile = "";
    private static final float Threshold = 0.8f;

    public MainControl(Display display) throws Exception {
        if (all == null) {
            all = this.readFile("wccf_data.csv");
        }
        if (team == null) {
            team = new ArrayList<Player>();
        }
        if (teamkp == null) {
            teamkp = this.readFile2("teamkp.csv");
        }
        if (nationalkp == null) {
            nationalkp = this.readFile2("nationalkp.csv");
        }
        if (combikp == null) {
            combikp = this.readFile2("combikp.csv");
        }
        if (rarekp == null) {
            rarekp = this.readFile2("rarekp.csv");
        }
        if (kpinfo == null) {
            kpinfo = this.readFile2("kpinfo.csv");
        }
        if (have == null) {
            have = this.readFile("own.lst");
        }
        if (this.FW_BA == null) {
            Path path = Paths.get("color.inf", new String[0]);
            BufferedReader br = Files.newBufferedReader(path, Charset.forName("UTF-8"));
            String rl = br.readLine();
            this.useColor = rl == null ? false : rl.startsWith("1");
            br.lines().forEach(buffer -> this.splitColorData((String)buffer, display));
            br.close();
        }
        if (this.logger == null) {
            this.logger = Logger.getLogger(MainControl.class.getName());
            FileHandler handler = new FileHandler("wccftb.log");
            this.logger.addHandler(handler);
            SimpleFormatter formatter = new SimpleFormatter();
            handler.setFormatter(formatter);
        }
    }

    private List<Player> readFile(String fname) throws Exception {
        ArrayList<Player> lst = new ArrayList<Player>();
        Path path = Paths.get(fname, new String[0]);
        if (path.toFile().exists()) {
            BufferedReader br = Files.newBufferedReader(path, Charset.forName("UTF-8"));
            br.readLine();
            br.lines().forEach(buffer -> {
                boolean bl = lst.add(this.splitData((String)buffer));
            });
            br.close();
        }
        return lst;
    }

    private List<String[]> readFile2(String fname) throws Exception {
        ArrayList<String[]> lst = new ArrayList<String[]>();
        Path path = Paths.get(fname, new String[0]);
        if (path.toFile().exists()) {
            BufferedReader br = Files.newBufferedReader(path, Charset.forName("UTF-8"));
            br.lines().forEach(buffer -> {
                boolean bl = lst.add(buffer.split(","));
            });
            br.close();
        }
        return lst;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<Player> search(String ver, String name, String country, String region, String rarity, String team, String pos, String off, String offcond, String def, String defcond, String tec, String teccond, String pow, String powcond, String spe, String specond, String sta, String stacond, String total, String totalcond, String rarekp, String kp, String ss, String bp, String gk, String cap, String fk, String ck, String pk, String combikp, String skill, String cp, String live, String oldclub, String height, String heicond, String weight, String weicond, String gene, String foot) {
        return all.stream().filter(vo -> this.isEqualsWithVer(ver, vo.getVer())).filter(vo -> this.isInclude(name, vo.getName())).filter(vo -> this.isEquals(country, vo.getCountry())).filter(vo -> this.isEquals(region, vo.getRegion())).filter(vo -> this.isEqualsWithRarity(rarity, vo.getRarity(), vo.getNo(), vo.getVer())).filter(vo -> this.isEqualsWithOldClub(team, (Player)vo, oldclub)).filter(vo -> this.isEquals(pos, vo.getPos())).filter(vo -> this.isCompared(off, offcond, vo.getOff())).filter(vo -> this.isCompared(def, defcond, vo.getDef())).filter(vo -> this.isCompared(tec, teccond, vo.getTec())).filter(vo -> this.isCompared(pow, powcond, vo.getPow())).filter(vo -> this.isCompared(spe, specond, vo.getSpe())).filter(vo -> this.isCompared(sta, stacond, vo.getSta())).filter(vo -> this.isCompared(total, totalcond, vo.getTotal())).filter(vo -> this.isRareKp(rarekp, (Player)vo)).filter(vo -> this.isEquals(kp, vo.getKp())).filter(vo -> this.isEquals(ss, vo.getSs())).filter(vo -> this.isEquals(bp, vo.getBp())).filter(vo -> this.isEquals(gk, vo.getGk())).filter(vo -> this.isEquals(cap, vo.getCap())).filter(vo -> this.isEquals(fk, vo.getFk())).filter(vo -> this.isEquals(ck, vo.getCk())).filter(vo -> this.isEquals(pk, vo.getPk())).filter(vo -> this.isCombiKp(combikp, (Player)vo)).filter(vo -> this.isEquals(skill, vo.getSkill())).filter(vo -> this.isEquals(cp, vo.getCp())).filter(vo -> this.isEquals(live, vo.getLive())).filter(vo -> this.isCompared(height, heicond, vo.getHeight())).filter(vo -> this.isCompared(weight, weicond, vo.getWeight())).filter(vo -> this.isBetween(gene, vo.getBirth_d())).filter(vo -> this.isEquals(foot, vo.getFoot())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    public List<Player> search2(String name, String birth) {
        return all.stream().filter(vo -> this.isSimiler(name, vo.getName()) || name.startsWith(vo.getName()) || vo.getName().startsWith(name) || name.endsWith(vo.getName()) || vo.getName().endsWith(name)).filter(vo -> this.isEquals(birth, vo.getBirth())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    public List<Player> search3(String birth) {
        int year = Integer.parseInt(birth.split("/")[0]);
        String start = String.valueOf(year - 2);
        String end = String.valueOf(year + 2);
        return all.stream().filter(vo -> this.isBetween(String.valueOf(start) + "\uff5e" + end, vo.getBirth_d())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    public List<Player> search4(String country) {
        return all.stream().filter(vo -> this.isInclude(country, vo.getCountry())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    public List<Player> search5(String team) {
        return all.stream().filter(vo -> this.isSimiler(team, vo.getTeam())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    public List<Player> search6(String skill) {
        return all.stream().filter(vo -> this.isEquals(skill, vo.getSkill())).sorted(Comparator.comparing(Player::getNo)).sorted(Comparator.comparing(Player::getVer).reversed()).collect(Collectors.toList());
    }

    private boolean isEquals(String a, String b) {
        return "".equals(a) ? true : ("\u3059\u3079\u3066".equals(a) ? !"".equals(b) : a.equals(b));
    }

    private boolean isEquals(Player p1, Player p2) {
        return p1 != null && p2 != null ? this.isEquals(p1.getVer(), p2.getVer()) && this.isEquals(p1.getName(), p2.getName()) && this.isEquals(p1.getRarity(), p2.getRarity()) : false;
    }

    private boolean isEqualsWithRarity(String a, String b, String c, String d) {
        return "".equals(a) ? true : ("\u767d".equals(a) ? this.isInclude("RE", b) || this.isInclude("YGS", b) && this.isInclude("16-17", d) : (!"\u767d\uff08\u30ec\u30a2\uff09".equals(a) ? ("\u9ed2".equals(a) ? this.isEquals("SP", b) : ("EXTRA".equals(a) ? this.isInclude("EXT", b) || this.isInclude("EXT", c) : ("\u767dEXTRA".equals(a) ? this.isInclude("RE", b) && this.isInclude("EXT", c) : ("\u9ed2EXTRA".equals(a) ? this.isEquals("SP", b) && this.isInclude("EXT", c) : ("\u30ec\u30a2EXTRA".equals(a) ? this.isInclude("EXT", b) : ("\u30ec\u30a2".equals(a) ? !("".equals(b) || this.isInclude("RE", b) || this.isEquals("SP", b)) : a.equals(b))))))) : this.isInclude("ATLE-RE", b) || this.isInclude("YGS", b) && this.isInclude("16-17", d) || this.isInclude("SS-RE", b)));
    }

    private boolean isEqualsWithOldClub(String a, Player b, String c) {
        return b == null ? false : ("1".equals(c) ? this.isEquals(a, b.getTeam()) || this.isOldClub(a, b.getOldclub(), b.getTeam()) : this.isEquals(a, b.getTeam()));
    }

    private boolean isEqualsWithVer(String a, String b) {
        return "".equals(a) ? true : (a.endsWith("\u5168\u3066") ? b.startsWith(a.substring(0, 5)) : a.equals(b));
    }

    private boolean isStarted(String a, String b) {
        return !"".equals(a) && !"".equals(b) ? b.startsWith(a) : true;
    }

    private boolean isOldClub(String a, String b, String c) {
        boolean retb = false;
        String[] oldclub = b.split("<br>");
        int i = 0;
        while (i < oldclub.length) {
            String oldC;
            String[] clubs = oldclub[i].split(" ");
            String string = oldC = clubs.length > 1 ? clubs[1] : clubs[0];
            if (this.isSimiler(c, oldC)) break;
            if (a.equals(oldC)) {
                retb = true;
                break;
            }
            ++i;
        }
        return retb;
    }

    private boolean isInclude(String a, String b) {
        return b.indexOf(a) > -1;
    }

    private boolean isSimiler(String a, String b) {
        LevenshteinDistance levensteinDistance = new LevenshteinDistance();
        return levensteinDistance.getDistance(a, b) >= 0.8f;
    }

    private boolean isCompared(String a, String b, int c) {
        if ("".equals(a)) {
            return true;
        }
        int ai = Integer.parseInt(a);
        return "\u4ee5\u4e0b".equals(b) ? ai >= c && c > 0 : ("\u4ee5\u4e0a".equals(b) ? ai <= c : ai == c);
    }

    private boolean isCompared(String a, String b, float c) {
        if ("".equals(a)) {
            return true;
        }
        float ai = Float.parseFloat(a);
        return "\u4ee5\u4e0b".equals(b) ? ai >= c && c > 0.0f : ("\u4ee5\u4e0a".equals(b) ? ai <= c : ai == c);
    }

    private boolean isCombiKp(String combi, Player vo) {
        if (combi != null && !"".equals(combi)) {
            List cb = combikp.stream().filter(st -> combi.equals(st[0])).collect(Collectors.toList());
            if (cb.size() < 1) {
                return false;
            }
            String[] arr = (String[])cb.get(0);
            int i = 1;
            while (i < arr.length) {
                if (arr[i].equals(vo.getVer()) && arr[i + 1].equals(vo.getNo()) && arr[i + 2].equals(vo.getName()) && arr[i + 3].equals(vo.getRarity()) && arr[i + 4].equals(vo.getKp())) {
                    return true;
                }
                i += 5;
            }
            return false;
        }
        return true;
    }

    private boolean isRareKp(String rare, Player vo) {
        if (rare != null && !"".equals(rare)) {
            List cb = rarekp.stream().filter(st -> rare.equals(st[0])).collect(Collectors.toList());
            if (cb.size() < 1) {
                return false;
            }
            String[] arr = (String[])cb.get(0);
            int i = 1;
            while (i < arr.length) {
                if (arr[i].equals(vo.getVer()) && arr[i + 1].equals(vo.getNo()) && arr[i + 2].equals(vo.getName()) && arr[i + 3].equals(vo.getRarity()) && arr[i + 4].equals(vo.getKp())) {
                    return true;
                }
                i += 5;
            }
            return false;
        }
        return true;
    }

    private boolean isBetween(String gene, Date birth) {
        if (birth == null) {
            return false;
        }
        if (gene != null && !"".equals(gene)) {
            String start = String.valueOf(gene.split("\uff5e")[0]) + "/01/01";
            String end = String.valueOf(gene.split("\uff5e")[1]) + "/12/31";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            try {
                Date s_date = sdf.parse(start);
                Date e_date = sdf.parse(end);
                if (birth.compareTo(s_date) > 0 && birth.compareTo(e_date) < 0) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public List<Player> getList() {
        return all;
    }

    public List<Player> getHave() {
        return have == null ? (have = new ArrayList<Player>()) : have;
    }

    public boolean isHave(Player vo) {
        if (have == null) {
            return false;
        }
        long cnt = have.stream().filter(ivo -> this.isEqualsWithVer(ivo.getVer(), vo.getVer())).filter(ivo -> this.isInclude(ivo.getName(), vo.getName())).filter(ivo -> this.isEquals(ivo.getCountry(), vo.getCountry())).filter(ivo -> this.isEquals(ivo.getRegion(), vo.getRegion())).filter(ivo -> this.isEquals(ivo.getPos(), vo.getPos())).filter(ivo -> this.isEquals(ivo.getKp(), vo.getKp())).count();
        return cnt > 0L;
    }

    public void setHave(List<Player> lst) {
        have = lst.stream().distinct().collect(Collectors.toList());
    }

    public void saveHave() {
        if (have != null) {
            try {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(new File("own.lst")), false, "UTF-8"));
            }
            catch (Exception arg1) {
                this.logger.info(arg1.getMessage());
                return;
            }
            ArrayList<Player> newHave = new ArrayList<Player>(new HashSet<Player>(have));
            newHave.stream().forEach(vo -> System.out.println(vo.toString()));
        }
    }

    public List<Player> removeHave(Player vo) {
        if (have.stream().filter(ivo -> this.isEqualsWithVer(ivo.getVer(), vo.getVer())).filter(ivo -> this.isInclude(ivo.getName(), vo.getName())).filter(ivo -> this.isEquals(ivo.getCountry(), vo.getCountry())).filter(ivo -> this.isEquals(ivo.getRegion(), vo.getRegion())).filter(ivo -> this.isEquals(ivo.getPos(), vo.getPos())).filter(ivo -> this.isEquals(ivo.getKp(), vo.getKp())).count() > 0L) {
            Player removeVo = (Player)have.stream().filter(ivo -> this.isEqualsWithVer(ivo.getVer(), vo.getVer())).filter(ivo -> this.isInclude(ivo.getName(), vo.getName())).filter(ivo -> this.isEquals(ivo.getCountry(), vo.getCountry())).filter(ivo -> this.isEquals(ivo.getRegion(), vo.getRegion())).filter(ivo -> this.isEquals(ivo.getPos(), vo.getPos())).filter(ivo -> this.isEquals(ivo.getKp(), vo.getKp())).collect(Collectors.toList()).get(0);
            have.remove(removeVo);
        }
        return have;
    }

    public List<Player> getTeamList() {
        return team;
    }

    public List<String[]> getTeamKp() {
        return teamkp;
    }

    public List<String[]> getNationalKp() {
        return nationalkp;
    }

    public List<String[]> getCombiKp() {
        return combikp;
    }

    public List<String[]> getRareKp() {
        return rarekp;
    }

    public List<String[]> getKpInfo() {
        return kpinfo;
    }

    public int setTeamList(Player vo) {
        if (team.size() == 16) {
            return -1;
        }
        if (team.stream().anyMatch(x -> x.getName().equals(vo.getName()))) {
            return 1;
        }
        team.add(vo);
        return 0;
    }

    public void removeTeamList(Player vo) {
        team.remove(vo);
        if (this.isEquals(vo, this.player1)) {
            this.player1 = null;
        } else if (this.isEquals(vo, this.player2)) {
            this.player2 = null;
        } else if (this.isEquals(vo, this.player3)) {
            this.player3 = null;
        } else if (this.isEquals(vo, this.player4)) {
            this.player4 = null;
        } else if (this.isEquals(vo, this.player5)) {
            this.player5 = null;
        } else if (this.isEquals(vo, this.player6)) {
            this.player6 = null;
        } else if (this.isEquals(vo, this.player7)) {
            this.player7 = null;
        } else if (this.isEquals(vo, this.player8)) {
            this.player8 = null;
        } else if (this.isEquals(vo, this.player9)) {
            this.player9 = null;
        } else if (this.isEquals(vo, this.player10)) {
            this.player10 = null;
        } else if (this.isEquals(vo, this.player11)) {
            this.player11 = null;
        } else if (this.isEquals(vo, this.player12)) {
            this.player12 = null;
        } else if (this.isEquals(vo, this.player13)) {
            this.player13 = null;
        } else if (this.isEquals(vo, this.player14)) {
            this.player14 = null;
        } else if (this.isEquals(vo, this.player15)) {
            this.player15 = null;
        } else if (this.isEquals(vo, this.player16)) {
            this.player16 = null;
        }
    }

    public int replaceTeamList(Player vo1, Player vo2) {
        if (team.stream().anyMatch(x -> x.getName().equals(vo2.getName()) && !x.getName().equals(vo1.getName()))) {
            return 1;
        }
        this.vpos = 0;
        this.cpos = 0;
        team.stream().forEach(vo0 -> {
            if (this.isEquals(vo0.getVer(), vo1.getVer()) && this.isEquals(vo0.getNo(), vo1.getNo()) && this.isEquals(vo0.getName(), vo1.getName()) && this.isEquals(vo0.getRarity(), vo1.getRarity()) && this.isEquals(vo0.getKp(), vo1.getKp())) {
                this.cpos = this.vpos;
            }
            ++this.vpos;
        });
        team.set(this.cpos, vo2);
        if (this.isEquals(vo1, this.player1)) {
            this.player1 = vo2;
        } else if (this.isEquals(vo1, this.player2)) {
            this.player2 = vo2;
        } else if (this.isEquals(vo1, this.player3)) {
            this.player3 = vo2;
        } else if (this.isEquals(vo1, this.player4)) {
            this.player4 = vo2;
        } else if (this.isEquals(vo1, this.player5)) {
            this.player5 = vo2;
        } else if (this.isEquals(vo1, this.player6)) {
            this.player6 = vo2;
        } else if (this.isEquals(vo1, this.player7)) {
            this.player7 = vo2;
        } else if (this.isEquals(vo1, this.player8)) {
            this.player8 = vo2;
        } else if (this.isEquals(vo1, this.player9)) {
            this.player9 = vo2;
        } else if (this.isEquals(vo1, this.player10)) {
            this.player10 = vo2;
        } else if (this.isEquals(vo1, this.player11)) {
            this.player11 = vo2;
        } else if (this.isEquals(vo1, this.player12)) {
            this.player12 = vo2;
        } else if (this.isEquals(vo1, this.player13)) {
            this.player13 = vo2;
        } else if (this.isEquals(vo1, this.player14)) {
            this.player14 = vo2;
        } else if (this.isEquals(vo1, this.player15)) {
            this.player15 = vo2;
        } else if (this.isEquals(vo1, this.player16)) {
            this.player16 = vo2;
        }
        return 0;
    }

    public Player getTeamListPlayer(Player vo) {
        return (Player)team.stream().filter(vo1 -> this.isEquals(vo.getVer(), vo1.getVer())).filter(vo1 -> this.isEquals(vo.getNo(), vo1.getNo())).filter(vo1 -> this.isEquals(vo.getName(), vo1.getName())).filter(vo1 -> this.isEquals(vo.getRarity(), vo1.getRarity())).filter(vo1 -> this.isEquals(vo.getKp(), vo1.getKp())).collect(Collectors.toList()).get(0);
    }

    public void movePosTeamListPalyer(Player vo1, int upOrDown) {
        this.vpos = 0;
        this.cpos = 0;
        team.stream().forEach(vo0 -> {
            if (this.isEquals(vo0.getVer(), vo1.getVer()) && this.isEquals(vo0.getNo(), vo1.getNo()) && this.isEquals(vo0.getName(), vo1.getName()) && this.isEquals(vo0.getRarity(), vo1.getRarity()) && this.isEquals(vo0.getKp(), vo1.getKp())) {
                this.cpos = this.vpos;
            }
            ++this.vpos;
        });
        if (upOrDown == 1) {
            if (this.cpos == 0) {
                return;
            }
            Player vo2 = team.get(this.cpos - 1);
            team.set(this.cpos - 1, vo1);
            team.set(this.cpos, vo2);
        } else if (upOrDown == 2) {
            if (this.cpos == team.size() - 1) {
                return;
            }
            Player vo2 = team.get(this.cpos + 1);
            team.set(this.cpos + 1, vo1);
            team.set(this.cpos, vo2);
        }
    }

    public Player getListPlayer(Player vo) {
        return (Player)all.stream().filter(vo1 -> this.isStarted(vo.getVer(), vo1.getVer())).filter(vo1 -> this.isEquals(vo.getNo(), vo1.getNo())).filter(vo1 -> this.isEquals(vo.getName(), vo1.getName())).filter(vo1 -> this.isEquals(vo.getKp(), vo1.getKp())).collect(Collectors.toList()).get(0);
    }

    public void setPlayer(Player vo) {
        this.vo = vo;
    }

    public Player getPlayer() {
        return this.vo;
    }

    public void setFormation(String Formation) {
        this.Formation = Formation;
    }

    public String getFormation() {
        return this.Formation;
    }

    public void setPlayer(Label label, Player vo) {
        if ("label_1".equals(label.getData())) {
            this.player1 = vo;
        } else if ("label_2".equals(label.getData())) {
            this.player2 = vo;
        } else if ("label_3".equals(label.getData())) {
            this.player3 = vo;
        } else if ("label_4".equals(label.getData())) {
            this.player4 = vo;
        } else if ("label_5".equals(label.getData())) {
            this.player5 = vo;
        } else if ("label_6".equals(label.getData())) {
            this.player6 = vo;
        } else if ("label_7".equals(label.getData())) {
            this.player7 = vo;
        } else if ("label_8".equals(label.getData())) {
            this.player8 = vo;
        } else if ("label_9".equals(label.getData())) {
            this.player9 = vo;
        } else if ("label_10".equals(label.getData())) {
            this.player10 = vo;
        } else if ("label_11".equals(label.getData())) {
            this.player11 = vo;
        } else if ("label_12".equals(label.getData())) {
            this.player12 = vo;
        } else if ("label_13".equals(label.getData())) {
            this.player13 = vo;
        } else if ("label_14".equals(label.getData())) {
            this.player14 = vo;
        } else if ("label_15".equals(label.getData())) {
            this.player15 = vo;
        } else if ("label_16".equals(label.getData())) {
            this.player16 = vo;
        } else {
            this.player1 = vo;
        }
    }

    public Player getPlayer(Label label) {
        return "label_1".equals(label.getData()) ? this.player1 : ("label_2".equals(label.getData()) ? this.player2 : ("label_3".equals(label.getData()) ? this.player3 : ("label_4".equals(label.getData()) ? this.player4 : ("label_5".equals(label.getData()) ? this.player5 : ("label_6".equals(label.getData()) ? this.player6 : ("label_7".equals(label.getData()) ? this.player7 : ("label_8".equals(label.getData()) ? this.player8 : ("label_9".equals(label.getData()) ? this.player9 : ("label_10".equals(label.getData()) ? this.player10 : ("label_11".equals(label.getData()) ? this.player11 : ("label_12".equals(label.getData()) ? this.player12 : ("label_13".equals(label.getData()) ? this.player13 : ("label_14".equals(label.getData()) ? this.player14 : ("label_15".equals(label.getData()) ? this.player15 : ("label_16".equals(label.getData()) ? this.player16 : this.player1)))))))))))))));
    }

    public Color selectColor1(String pos, Display display) {
        Color defalut = new Color(display, 255, 255, 255);
        return this.useColor ? ("FW".equals(pos) ? this.FW_BA : ("MF".equals(pos) ? this.MF_BA : ("DF".equals(pos) ? this.DF_BA : ("GK".equals(pos) ? this.GK_BA : defalut)))) : defalut;
    }

    public Color selectColor2(String pos, Display display) {
        Color defalut = new Color(display, 0, 0, 0);
        return this.useColor ? ("FW".equals(pos) ? this.FW_FO : ("MF".equals(pos) ? this.MF_FO : ("DF".equals(pos) ? this.DF_FO : ("GK".equals(pos) ? this.GK_FO : defalut)))) : defalut;
    }

    public Color selectColor3(String rarity, Display display) {
        Color defalut = new Color(display, 255, 255, 255);
        return this.useColor ? (this.isStarted("HOLE", rarity) ? this.HOLE_BA : (this.isStarted("KOLE", rarity) ? this.KOLE_BA : (this.isEquals("SATLE", rarity) ? this.SATLE_BA : (this.isEquals("ATLE-RE", rarity) ? this.ATLERE_BA : (this.isEquals("ATLE", rarity) ? this.ATLE_BA : (this.isEquals("LEOC", rarity) ? this.LEOC_BA : (this.isStarted("LE", rarity) ? this.LE_BA : (this.isInclude("RE", rarity) ? this.RE_BA : (this.isEquals("SP", rarity) ? this.SP_BA : this.RARE_BA))))))))) : defalut;
    }

    public Color selectColor4(String rarity, Display display) {
        Color defalut = new Color(display, 0, 0, 0);
        return this.useColor ? (this.isStarted("HOLE", rarity) ? this.HOLE_FO : (this.isStarted("KOLE", rarity) ? this.KOLE_FO : (this.isEquals("SATLE", rarity) ? this.SATLE_FO : (this.isEquals("ATLE-RE", rarity) ? this.ATLERE_FO : (this.isEquals("ATLE", rarity) ? this.ATLE_FO : (this.isEquals("LEOC", rarity) ? this.LEOC_FO : (this.isStarted("LE", rarity) ? this.LE_FO : (this.isInclude("RE", rarity) ? this.RE_FO : (this.isEquals("SP", rarity) ? this.SP_FO : this.RARE_FO))))))))) : defalut;
    }

    public Color selectColor5(Player vo, Display display) {
        Color defalut = new Color(display, 255, 255, 255);
        return this.useColor ? (this.isRareKp(vo.getSkill(), vo) ? this.KOJINRARE_BA : (this.isCombiKp(vo.getSkill(), vo) ? this.COMBIRARE_BA : defalut)) : defalut;
    }

    public Color selectColor6(Player vo, Display display) {
        Color defalut = new Color(display, 0, 0, 0);
        return this.useColor ? (this.isRareKp(vo.getSkill(), vo) ? this.KOJINRARE_FO : (this.isCombiKp(vo.getSkill(), vo) ? this.COMBIRARE_FO : defalut)) : defalut;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public boolean openSaveData(Shell shell) {
        BufferedReader br = null;
        String[] ext = new String[]{"*.fdt"};
        FileDialog openDialog = new FileDialog(shell, 4096);
        openDialog.setFilterExtensions(ext);
        this.openFile = openDialog.open();
        if (this.openFile != null && !"".equals(this.openFile)) {
            shell.setText("WCCF Team Builder [" + this.openFile + "]");
            Path path = Paths.get(this.openFile, new String[0]);
            try {
                br = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            }
            catch (IOException arg8) {
                return false;
            }
            team.clear();
            br.lines().forEach(buffer -> {
                String liner = buffer.substring(0, 5);
                if ("TEAM:".equals(liner)) {
                    team.add(this.getListPlayer(this.splitData(buffer.substring(5))));
                }
                if ("FORM:".equals(liner)) {
                    this.Formation = buffer.substring(5);
                }
                if (liner.equals("KP01:")) {
                    this.kp1 = buffer.substring(5);
                }
                if (liner.equals("KP02:")) {
                    this.kp2 = buffer.substring(5);
                }
                if (liner.equals("KP03:")) {
                    this.kp3 = buffer.substring(5);
                }
                if (liner.startsWith("FP")) {
                    this.choicePosition(liner, buffer.substring(5));
                }
                if ("UserSet".equals(this.Formation) && liner.startsWith("P")) {
                    this.choiseFormationLabelXY(liner, buffer.substring(5));
                }
            });
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean writeSaveData(Shell shell) {
        String saveFile = "";
        if (this.openFile == null || "".equals(this.openFile)) {
            String[] ext = new String[]{"*.fdt"};
            FileDialog saveDialog = new FileDialog(shell, 8192);
            saveDialog.setFilterExtensions(ext);
            saveFile = saveDialog.open();
        } else {
            saveFile = this.openFile;
        }
        if (saveFile != null && !"".equals(saveFile)) {
            shell.setText("WCCF Team Builder [" + saveFile + "]");
            try {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(new File(saveFile)), false, "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            team.stream().forEach(vo -> System.out.println("TEAM:" + vo.toString()));
            System.out.println("FORM:" + this.Formation);
            System.out.println(this.player1 == null ? "FP01:" : "FP01:" + this.player1.toString());
            System.out.println(this.player2 == null ? "FP02:" : "FP02:" + this.player2.toString());
            System.out.println(this.player3 == null ? "FP03:" : "FP03:" + this.player3.toString());
            System.out.println(this.player4 == null ? "FP04:" : "FP04:" + this.player4.toString());
            System.out.println(this.player5 == null ? "FP05:" : "FP05:" + this.player5.toString());
            System.out.println(this.player6 == null ? "FP06:" : "FP06:" + this.player6.toString());
            System.out.println(this.player7 == null ? "FP07:" : "FP07:" + this.player7.toString());
            System.out.println(this.player8 == null ? "FP08:" : "FP08:" + this.player8.toString());
            System.out.println(this.player9 == null ? "FP09:" : "FP09:" + this.player9.toString());
            System.out.println(this.player10 == null ? "FP10:" : "FP10:" + this.player10.toString());
            System.out.println(this.player11 == null ? "FP11:" : "FP11:" + this.player11.toString());
            System.out.println(this.player12 == null ? "FP12:" : "FP12:" + this.player12.toString());
            System.out.println(this.player13 == null ? "FP13:" : "FP13:" + this.player13.toString());
            System.out.println(this.player14 == null ? "FP14:" : "FP14:" + this.player14.toString());
            System.out.println(this.player15 == null ? "FP15:" : "FP15:" + this.player15.toString());
            System.out.println(this.player16 == null ? "FP16:" : "FP16:" + this.player16.toString());
            System.out.println(this.kp1 == null ? "KP01:" : "KP01:" + this.kp1);
            System.out.println(this.kp2 == null ? "KP02:" : "KP02:" + this.kp2);
            System.out.println(this.kp3 == null ? "KP03:" : "KP03:" + this.kp3);
            if ("UserSet".equals(this.Formation)) {
                System.out.println("P01X:" + String.valueOf(this.lbl1x));
                System.out.println("P01Y:" + String.valueOf(this.lbl1y));
                System.out.println("P02X:" + String.valueOf(this.lbl2x));
                System.out.println("P02Y:" + String.valueOf(this.lbl2y));
                System.out.println("P03X:" + String.valueOf(this.lbl3x));
                System.out.println("P03Y:" + String.valueOf(this.lbl3y));
                System.out.println("P04X:" + String.valueOf(this.lbl4x));
                System.out.println("P04Y:" + String.valueOf(this.lbl4y));
                System.out.println("P05X:" + String.valueOf(this.lbl5x));
                System.out.println("P05Y:" + String.valueOf(this.lbl5y));
                System.out.println("P06X:" + String.valueOf(this.lbl6x));
                System.out.println("P06Y:" + String.valueOf(this.lbl6y));
                System.out.println("P07X:" + String.valueOf(this.lbl7x));
                System.out.println("P07Y:" + String.valueOf(this.lbl7y));
                System.out.println("P08X:" + String.valueOf(this.lbl8x));
                System.out.println("P08Y:" + String.valueOf(this.lbl8y));
                System.out.println("P09X:" + String.valueOf(this.lbl9x));
                System.out.println("P09Y:" + String.valueOf(this.lbl9y));
                System.out.println("P10X:" + String.valueOf(this.lbl10x));
                System.out.println("P10Y:" + String.valueOf(this.lbl10y));
            }
            this.setChangeData(false);
            return true;
        }
        return false;
    }

    private Player splitData(String buffer) {
        if (buffer != null && !"".equals(buffer)) {
            String[] col = buffer.split(",", -1);
            int size = col.length;
            Player vo = new Player();
            vo.setVer(col[0]);
            vo.setNo(col[1]);
            vo.setName(col[2]);
            vo.setCountry(col[3]);
            vo.setRegion(col[4]);
            vo.setRarity(col[5]);
            vo.setTeam(col[6]);
            vo.setPos(col[7]);
            if ("".equals(col[8])) {
                vo.setOff(0);
            } else {
                vo.setOff(Integer.parseInt(col[8]));
            }
            if ("".equals(col[9])) {
                vo.setDef(0);
            } else {
                vo.setDef(Integer.parseInt(col[9]));
            }
            if ("".equals(col[10])) {
                vo.setTec(0);
            } else {
                vo.setTec(Integer.parseInt(col[10]));
            }
            if ("".equals(col[11])) {
                vo.setPow(0);
            } else {
                vo.setPow(Integer.parseInt(col[11]));
            }
            if ("".equals(col[12])) {
                vo.setSpe(0);
            } else {
                vo.setSpe(Integer.parseInt(col[12]));
            }
            if ("".equals(col[13])) {
                vo.setSta(0);
            } else {
                vo.setSta(Integer.parseInt(col[13]));
            }
            if ("".equals(col[14])) {
                vo.setTotal(100);
            } else if ("0".equals(col[14])) {
                vo.setTotal(100);
            } else {
                vo.setTotal(Integer.parseInt(col[14]));
            }
            vo.setSkill(col[15]);
            vo.setKp(col[16]);
            if (size < 41) {
                try {
                    vo = this.getListPlayer(vo);
                }
                catch (Exception arg5) {
                    System.out.println(vo);
                    throw arg5;
                }
                return vo;
            }
            vo.setSs(col[17]);
            vo.setBp(col[18]);
            vo.setGk(col[19]);
            vo.setCap(col[20]);
            vo.setFk(col[21]);
            vo.setCk(col[22]);
            vo.setPk(col[23]);
            vo.setKpdid(col[24]);
            vo.setCp(col[25]);
            vo.setBackno(col[26]);
            vo.setBirth(col[27]);
            try {
                vo.setBirth_d(new SimpleDateFormat("yyyy/MM/dd").parse(vo.getBirth()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if ("".equals(col[28])) {
                vo.setHeight(0.0f);
            } else {
                vo.setHeight(Float.parseFloat(col[28]));
            }
            if ("".equals(col[29])) {
                vo.setWeight(0.0f);
            } else {
                vo.setWeight(Float.parseFloat(col[29]));
            }
            vo.setFoot(col[30]);
            vo.setGp(col[31]);
            vo.setLt(col[32]);
            vo.setTra(col[33]);
            vo.setRole(col[34]);
            vo.setCond(col[35]);
            vo.setLive(col[36]);
            vo.setOldclub(col[37]);
            vo.setSp_collabo(col[38]);
            vo.setSp_decollabo(col[39]);
            vo.setImage(col[40]);
            return vo;
        }
        return null;
    }

    private void choicePosition(String liner, String buffer) {
        if ("FP01:".equals(liner)) {
            this.player1 = this.splitData(buffer);
        } else if ("FP02:".equals(liner)) {
            this.player2 = this.splitData(buffer);
        } else if ("FP03:".equals(liner)) {
            this.player3 = this.splitData(buffer);
        } else if ("FP04:".equals(liner)) {
            this.player4 = this.splitData(buffer);
        } else if ("FP05:".equals(liner)) {
            this.player5 = this.splitData(buffer);
        } else if ("FP06:".equals(liner)) {
            this.player6 = this.splitData(buffer);
        } else if ("FP07:".equals(liner)) {
            this.player7 = this.splitData(buffer);
        } else if ("FP08:".equals(liner)) {
            this.player8 = this.splitData(buffer);
        } else if ("FP09:".equals(liner)) {
            this.player9 = this.splitData(buffer);
        } else if ("FP10:".equals(liner)) {
            this.player10 = this.splitData(buffer);
        } else if ("FP11:".equals(liner)) {
            this.player11 = this.splitData(buffer);
        } else if ("FP12:".equals(liner)) {
            this.player12 = this.splitData(buffer);
        } else if ("FP13:".equals(liner)) {
            this.player13 = this.splitData(buffer);
        } else if ("FP14:".equals(liner)) {
            this.player14 = this.splitData(buffer);
        } else if ("FP15:".equals(liner)) {
            this.player15 = this.splitData(buffer);
        } else if ("FP16:".equals(liner)) {
            this.player16 = this.splitData(buffer);
        }
    }

    public void setFormationLabelXY(Label label) {
        this.setFormationLabelXY(label, label.getBounds().x, label.getBounds().y);
    }

    public void setFormationLabelXY(Label label, int x, int y) {
        if ("label_1".equals(label.getData())) {
            this.lbl1x = x;
            this.lbl1y = y;
        } else if ("label_2".equals(label.getData())) {
            this.lbl2x = x;
            this.lbl2y = y;
        } else if ("label_3".equals(label.getData())) {
            this.lbl3x = x;
            this.lbl3y = y;
        } else if ("label_4".equals(label.getData())) {
            this.lbl4x = x;
            this.lbl4y = y;
        } else if ("label_5".equals(label.getData())) {
            this.lbl5x = x;
            this.lbl5y = y;
        } else if ("label_6".equals(label.getData())) {
            this.lbl6x = x;
            this.lbl6y = y;
        } else if ("label_7".equals(label.getData())) {
            this.lbl7x = x;
            this.lbl7y = y;
        } else if ("label_8".equals(label.getData())) {
            this.lbl8x = x;
            this.lbl8y = y;
        } else if ("label_9".equals(label.getData())) {
            this.lbl9x = x;
            this.lbl9y = y;
        } else if ("label_10".equals(label.getData())) {
            this.lbl10x = x;
            this.lbl10y = y;
        }
    }

    public void getFormationLabelXY(Label label) {
        if ("label_1".equals(label.getData())) {
            label.setBounds(this.lbl1x, this.lbl1y, label.getBounds().width, label.getBounds().height);
        } else if ("label_2".equals(label.getData())) {
            label.setBounds(this.lbl2x, this.lbl2y, label.getBounds().width, label.getBounds().height);
        } else if ("label_3".equals(label.getData())) {
            label.setBounds(this.lbl3x, this.lbl3y, label.getBounds().width, label.getBounds().height);
        } else if ("label_4".equals(label.getData())) {
            label.setBounds(this.lbl4x, this.lbl4y, label.getBounds().width, label.getBounds().height);
        } else if ("label_5".equals(label.getData())) {
            label.setBounds(this.lbl5x, this.lbl5y, label.getBounds().width, label.getBounds().height);
        } else if ("label_6".equals(label.getData())) {
            label.setBounds(this.lbl6x, this.lbl6y, label.getBounds().width, label.getBounds().height);
        } else if ("label_7".equals(label.getData())) {
            label.setBounds(this.lbl7x, this.lbl7y, label.getBounds().width, label.getBounds().height);
        } else if ("label_8".equals(label.getData())) {
            label.setBounds(this.lbl8x, this.lbl8y, label.getBounds().width, label.getBounds().height);
        } else if ("label_9".equals(label.getData())) {
            label.setBounds(this.lbl9x, this.lbl9y, label.getBounds().width, label.getBounds().height);
        } else if ("label_10".equals(label.getData())) {
            label.setBounds(this.lbl10x, this.lbl10y, label.getBounds().width, label.getBounds().height);
        }
    }

    private void choiseFormationLabelXY(String liner, String buffer) {
        if ("P01X:".equals(liner)) {
            this.lbl1x = Integer.parseInt(buffer);
        } else if ("P01Y:".equals(liner)) {
            this.lbl1y = Integer.parseInt(buffer);
        } else if ("P02X:".equals(liner)) {
            this.lbl2x = Integer.parseInt(buffer);
        } else if ("P02Y:".equals(liner)) {
            this.lbl2y = Integer.parseInt(buffer);
        } else if ("P03X:".equals(liner)) {
            this.lbl3x = Integer.parseInt(buffer);
        } else if ("P03Y:".equals(liner)) {
            this.lbl3y = Integer.parseInt(buffer);
        } else if ("P04X:".equals(liner)) {
            this.lbl4x = Integer.parseInt(buffer);
        } else if ("P04Y:".equals(liner)) {
            this.lbl4y = Integer.parseInt(buffer);
        } else if ("P05X:".equals(liner)) {
            this.lbl5x = Integer.parseInt(buffer);
        } else if ("P05Y:".equals(liner)) {
            this.lbl5y = Integer.parseInt(buffer);
        } else if ("P06X:".equals(liner)) {
            this.lbl6x = Integer.parseInt(buffer);
        } else if ("P06Y:".equals(liner)) {
            this.lbl6y = Integer.parseInt(buffer);
        } else if ("P07X:".equals(liner)) {
            this.lbl7x = Integer.parseInt(buffer);
        } else if ("P07Y:".equals(liner)) {
            this.lbl7y = Integer.parseInt(buffer);
        } else if ("P08X:".equals(liner)) {
            this.lbl8x = Integer.parseInt(buffer);
        } else if ("P08Y:".equals(liner)) {
            this.lbl8y = Integer.parseInt(buffer);
        } else if ("P09X:".equals(liner)) {
            this.lbl9x = Integer.parseInt(buffer);
        } else if ("P09Y:".equals(liner)) {
            this.lbl9y = Integer.parseInt(buffer);
        } else if ("P10X:".equals(liner)) {
            this.lbl10x = Integer.parseInt(buffer);
        } else if ("P10Y:".equals(liner)) {
            this.lbl10y = Integer.parseInt(buffer);
        }
    }

    public String getKp1() {
        return this.kp1;
    }

    public void setKp1(String kp1) {
        this.kp1 = kp1;
    }

    public String getKp2() {
        return this.kp2;
    }

    public void setKp2(String kp2) {
        this.kp2 = kp2;
    }

    public String getKp3() {
        return this.kp3;
    }

    public void setKp3(String kp3) {
        this.kp3 = kp3;
    }

    public boolean isUseColor() {
        return this.useColor;
    }

    public void setUseColor(boolean useColor) {
        this.useColor = useColor;
    }

    public TeamFrame getTf() {
        return this.tf;
    }

    public void setTf(TeamFrame tf) {
        this.tf = tf;
    }

    public FormationFrame getFf() {
        return this.ff;
    }

    public void setFf(FormationFrame ff) {
        this.ff = ff;
    }

    public ResponceFrame getRf() {
        return this.rf;
    }

    public void setRf(ResponceFrame rf) {
        this.rf = rf;
    }

    public KpInfoFrame getKif() {
        return this.kif;
    }

    public void setKif(KpInfoFrame kif) {
        this.kif = kif;
    }

    public ColorSettingsFrame getCsf() {
        return this.csf;
    }

    public void setCsf(ColorSettingsFrame csf) {
        this.csf = csf;
    }

    public SplashFrame getSf() {
        return this.sf;
    }

    public void setSf(SplashFrame sf) {
        this.sf = sf;
    }

    public boolean isChangeData() {
        return this.changeData;
    }

    public void setChangeData(boolean changeData) {
        this.changeData = changeData;
    }

    public SingleCardFrame getScf() {
        return this.scf;
    }

    public void setScf(SingleCardFrame scf) {
        this.scf = scf;
    }

    public OwnCardListFrame getOclf() {
        return this.oclf;
    }

    public void setOclf(OwnCardListFrame oclf) {
        this.oclf = oclf;
    }

    public void setColor(Color FW_BA, Color FW_FO, Color MF_BA, Color MF_FO, Color DF_BA, Color DF_FO, Color GK_BA, Color GK_FO, Color HOLE_BA, Color HOLE_FO, Color KOLE_BA, Color KOLE_FO, Color SATLE_BA, Color SATLE_FO, Color ATLERE_BA, Color ATLERE_FO, Color ATLE_BA, Color ATLE_FO, Color LEOC_BA, Color LEOC_FO, Color LE_BA, Color LE_FO, Color RE_BA, Color RE_FO, Color SP_BA, Color SP_FO, Color RARE_BA, Color RARE_FO, Color KOJINRARE_BA, Color KOJINRARE_FO, Color COMBIRARE_BA, Color COMBIRARE_FO) {
        this.FW_BA = FW_BA;
        this.FW_FO = FW_FO;
        this.MF_BA = MF_BA;
        this.MF_FO = MF_FO;
        this.DF_BA = DF_BA;
        this.DF_FO = DF_FO;
        this.GK_BA = GK_BA;
        this.GK_FO = GK_FO;
        this.HOLE_BA = HOLE_BA;
        this.HOLE_FO = HOLE_FO;
        this.KOLE_BA = KOLE_BA;
        this.KOLE_FO = KOLE_FO;
        this.SATLE_BA = SATLE_BA;
        this.SATLE_FO = SATLE_FO;
        this.ATLERE_BA = ATLERE_BA;
        this.ATLERE_FO = ATLERE_FO;
        this.ATLE_BA = ATLE_BA;
        this.ATLE_FO = ATLE_FO;
        this.LEOC_BA = LEOC_BA;
        this.LEOC_FO = LEOC_FO;
        this.LE_BA = LE_BA;
        this.LE_FO = LE_FO;
        this.RE_BA = RE_BA;
        this.RE_FO = RE_FO;
        this.SP_BA = SP_BA;
        this.SP_FO = SP_FO;
        this.RARE_BA = RARE_BA;
        this.RARE_FO = RARE_FO;
        this.KOJINRARE_BA = KOJINRARE_BA;
        this.KOJINRARE_FO = KOJINRARE_FO;
        this.COMBIRARE_BA = COMBIRARE_BA;
        this.COMBIRARE_FO = COMBIRARE_FO;
    }

    public void getColor(Label lblFw, Label lblMf, Label lblDf, Label lblGk, Label lblHole, Label lblKole, Label lblSatle, Label lblAtlere, Label lblAtle, Label lblLeoc, Label lblLe, Label lblRe, Label lblSp, Label lblRare, Label lblKojin, Label lblCombi) {
        lblFw.setBackground(this.FW_BA);
        lblFw.setForeground(this.FW_FO);
        lblMf.setBackground(this.MF_BA);
        lblMf.setForeground(this.MF_FO);
        lblDf.setBackground(this.DF_BA);
        lblDf.setForeground(this.DF_FO);
        lblGk.setBackground(this.GK_BA);
        lblGk.setForeground(this.GK_FO);
        lblHole.setBackground(this.HOLE_BA);
        lblHole.setForeground(this.HOLE_FO);
        lblKole.setBackground(this.KOLE_BA);
        lblKole.setForeground(this.KOLE_FO);
        lblSatle.setBackground(this.SATLE_BA);
        lblSatle.setForeground(this.SATLE_FO);
        lblAtlere.setBackground(this.ATLERE_BA);
        lblAtlere.setForeground(this.ATLERE_FO);
        lblAtle.setBackground(this.ATLE_BA);
        lblAtle.setForeground(this.ATLE_FO);
        lblLeoc.setBackground(this.LEOC_BA);
        lblLeoc.setForeground(this.LEOC_FO);
        lblLe.setBackground(this.LE_BA);
        lblLe.setForeground(this.LE_FO);
        lblRe.setBackground(this.RE_BA);
        lblRe.setForeground(this.RE_FO);
        lblSp.setBackground(this.SP_BA);
        lblSp.setForeground(this.SP_FO);
        lblRare.setBackground(this.RARE_BA);
        lblRare.setForeground(this.RARE_FO);
        lblKojin.setBackground(this.KOJINRARE_BA);
        lblKojin.setForeground(this.KOJINRARE_FO);
        lblCombi.setBackground(this.COMBIRARE_BA);
        lblCombi.setForeground(this.COMBIRARE_FO);
    }

    private void splitColorData(String buffer, Display display) {
        String[] work1 = buffer.split(":");
        String[] work2 = work1[1].split(",");
        int red = Integer.parseInt(work2[0]);
        int green = Integer.parseInt(work2[1]);
        int blue = Integer.parseInt(work2[2]);
        if ("FW_BA".equals(work1[0])) {
            this.FW_BA = new Color(display, red, green, blue);
        } else if ("FW_FO".equals(work1[0])) {
            this.FW_FO = new Color(display, red, green, blue);
        } else if ("MF_BA".equals(work1[0])) {
            this.MF_BA = new Color(display, red, green, blue);
        } else if ("MF_FO".equals(work1[0])) {
            this.MF_FO = new Color(display, red, green, blue);
        } else if ("DF_BA".equals(work1[0])) {
            this.DF_BA = new Color(display, red, green, blue);
        } else if ("DF_FO".equals(work1[0])) {
            this.DF_FO = new Color(display, red, green, blue);
        } else if ("GK_BA".equals(work1[0])) {
            this.GK_BA = new Color(display, red, green, blue);
        } else if ("GK_FO".equals(work1[0])) {
            this.GK_FO = new Color(display, red, green, blue);
        } else if ("HOLE_BA".equals(work1[0])) {
            this.HOLE_BA = new Color(display, red, green, blue);
        } else if ("HOLE_FO".equals(work1[0])) {
            this.HOLE_FO = new Color(display, red, green, blue);
        } else if ("KOLE_BA".equals(work1[0])) {
            this.KOLE_BA = new Color(display, red, green, blue);
        } else if ("KOLE_FO".equals(work1[0])) {
            this.KOLE_FO = new Color(display, red, green, blue);
        } else if ("SATLE_BA".equals(work1[0])) {
            this.SATLE_BA = new Color(display, red, green, blue);
        } else if ("SATLE_FO".equals(work1[0])) {
            this.SATLE_FO = new Color(display, red, green, blue);
        } else if ("ATLERE_BA".equals(work1[0])) {
            this.ATLERE_BA = new Color(display, red, green, blue);
        } else if ("ATLERE_FO".equals(work1[0])) {
            this.ATLERE_FO = new Color(display, red, green, blue);
        } else if ("ATLE_BA".equals(work1[0])) {
            this.ATLE_BA = new Color(display, red, green, blue);
        } else if ("ATLE_FO".equals(work1[0])) {
            this.ATLE_FO = new Color(display, red, green, blue);
        } else if ("LEOC_BA".equals(work1[0])) {
            this.LEOC_BA = new Color(display, red, green, blue);
        } else if ("LEOC_FO".equals(work1[0])) {
            this.LEOC_FO = new Color(display, red, green, blue);
        } else if ("LE_BA".equals(work1[0])) {
            this.LE_BA = new Color(display, red, green, blue);
        } else if ("LE_FO".equals(work1[0])) {
            this.LE_FO = new Color(display, red, green, blue);
        } else if ("RE_BA".equals(work1[0])) {
            this.RE_BA = new Color(display, red, green, blue);
        } else if ("RE_FO".equals(work1[0])) {
            this.RE_FO = new Color(display, red, green, blue);
        } else if ("SP_BA".equals(work1[0])) {
            this.SP_BA = new Color(display, red, green, blue);
        } else if ("SP_FO".equals(work1[0])) {
            this.SP_FO = new Color(display, red, green, blue);
        } else if ("RARE_BA".equals(work1[0])) {
            this.RARE_BA = new Color(display, red, green, blue);
        } else if ("RARE_FO".equals(work1[0])) {
            this.RARE_FO = new Color(display, red, green, blue);
        } else if ("KOJINRARE_BA".equals(work1[0])) {
            this.KOJINRARE_BA = new Color(display, red, green, blue);
        } else if ("KOJINRARE_FO".equals(work1[0])) {
            this.KOJINRARE_FO = new Color(display, red, green, blue);
        } else if ("COMBIRARE_BA".equals(work1[0])) {
            this.COMBIRARE_BA = new Color(display, red, green, blue);
        } else if ("COMBIRARE_FO".equals(work1[0])) {
            this.COMBIRARE_FO = new Color(display, red, green, blue);
        }
    }

    public void writeColorSettings() {
        try {
            System.setOut(new PrintStream((OutputStream)new FileOutputStream(new File("color.inf")), false, "UTF-8"));
        }
        catch (Exception arg1) {
            this.logger.info(arg1.getMessage());
            return;
        }
        System.out.println(this.isUseColor() ? "1" : "0");
        System.out.println("FW_BA:" + this.color2CSV(this.FW_BA));
        System.out.println("FW_FO:" + this.color2CSV(this.FW_FO));
        System.out.println("MF_BA:" + this.color2CSV(this.MF_BA));
        System.out.println("MF_FO:" + this.color2CSV(this.MF_FO));
        System.out.println("DF_BA:" + this.color2CSV(this.DF_BA));
        System.out.println("DF_FO:" + this.color2CSV(this.DF_FO));
        System.out.println("GK_BA:" + this.color2CSV(this.GK_BA));
        System.out.println("GK_FO:" + this.color2CSV(this.GK_FO));
        System.out.println("HOLE_BA:" + this.color2CSV(this.HOLE_BA));
        System.out.println("HOLE_FO:" + this.color2CSV(this.HOLE_FO));
        System.out.println("KOLE_BA:" + this.color2CSV(this.KOLE_BA));
        System.out.println("KOLE_FO:" + this.color2CSV(this.KOLE_FO));
        System.out.println("SATLE_BA:" + this.color2CSV(this.SATLE_BA));
        System.out.println("SATLE_FO:" + this.color2CSV(this.SATLE_FO));
        System.out.println("ATLERE_BA:" + this.color2CSV(this.ATLERE_BA));
        System.out.println("ATLERE_FO:" + this.color2CSV(this.ATLERE_FO));
        System.out.println("ATLE_BA:" + this.color2CSV(this.ATLE_BA));
        System.out.println("ATLE_FO:" + this.color2CSV(this.ATLE_FO));
        System.out.println("LEOC_BA:" + this.color2CSV(this.LEOC_BA));
        System.out.println("LEOC_FO:" + this.color2CSV(this.LEOC_FO));
        System.out.println("LE_BA:" + this.color2CSV(this.LE_BA));
        System.out.println("LE_FO:" + this.color2CSV(this.LE_FO));
        System.out.println("RE_BA:" + this.color2CSV(this.RE_BA));
        System.out.println("RE_FO:" + this.color2CSV(this.RE_FO));
        System.out.println("SP_BA:" + this.color2CSV(this.SP_BA));
        System.out.println("SP_FO:" + this.color2CSV(this.SP_FO));
        System.out.println("RARE_BA:" + this.color2CSV(this.RARE_BA));
        System.out.println("RARE_FO:" + this.color2CSV(this.RARE_FO));
        System.out.println("KOJINRARE_BA:" + this.color2CSV(this.KOJINRARE_BA));
        System.out.println("KOJINRARE_FO:" + this.color2CSV(this.KOJINRARE_FO));
        System.out.println("COMBIRARE_BA:" + this.color2CSV(this.COMBIRARE_BA));
        System.out.println("COMBIRARE_FO:" + this.color2CSV(this.COMBIRARE_FO));
    }

    private String color2CSV(Color clr) {
        return String.valueOf(clr.getRGB().red) + "," + clr.getRGB().green + "," + clr.getRGB().blue;
    }

    public Point getPnt() {
        return this.pnt;
    }

    public void setPnt(Point pnt) {
        this.pnt = pnt;
    }

    public void setOpenFile(String openFile) {
        this.openFile = openFile;
    }

    public static void deleteDirectory(String dirPath) throws Exception {
        File file = new File(dirPath);
        MainControl.recursiveDeleteFile(file);
    }

    private static void recursiveDeleteFile(File file) throws Exception {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                MainControl.recursiveDeleteFile(child);
                ++n2;
            }
        }
        file.delete();
    }

    public void startTime() {
        this.printTime("start");
    }

    public void endTime() {
        this.printTime("end");
    }

    private void printTime(String head) {
        this.getLogger().info(String.valueOf(head) + " time : " + new SimpleDateFormat("Y/M/D H:m:s S").format(new Date()));
    }
}

