/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n = theme.notebookHandle;
        int n2 = this.gtk_widget_get_style(n);
        int n3 = OS.GTK3 ? gC.getGCData().cairo : gC.getGCData().drawable;
        theme.transferClipping(gC, n2);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        n7 -= this.tabsHeight;
        int n8 = this.selectedX;
        int n9 = this.selectedWidth;
        int n10 = 2;
        if ((this.style & 0x400) != 0) {
            n10 = 3;
        } else {
            n5 += this.tabsHeight;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "notebook", true);
        this.gtk_render_frame_gap(n2, n3, this.getStateType(0), 2, null, n, byArray, n4, n5, n6, n7, n10, n8, n9);
        if (this.tabsArea != null) {
            this.tabsArea.x = rectangle.x;
            this.tabsArea.y = rectangle.y;
            this.tabsArea.width = rectangle.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += rectangle.height - this.tabsHeight;
            }
        }
    }

    @Override
    int getStateType(int n) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }

    void gtk_render_frame_gap(int n, int n2, int n3, int n4, GdkRectangle gdkRectangle, int n5, byte[] byArray, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (OS.GTK3) {
            OS.gtk_render_frame_gap(n, n2, n, n7, n12, n9, n10, n11, n11 + n12);
        } else {
            OS.gtk_paint_box_gap(n, n2, n3, n4, gdkRectangle, n5, byArray, n6, n7, n8, n9, n10, n11, n12);
        }
    }
}

