/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.BLENDFUNCTION;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_WIDTH = 16;
    static final int LINE_CAP = 32;
    static final int LINE_JOIN = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_TEXT = 256;
    static final int BACKGROUND_TEXT = 512;
    static final int BRUSH = 1024;
    static final int PEN = 2048;
    static final int NULL_BRUSH = 4096;
    static final int NULL_PEN = 8192;
    static final int DRAW_OFFSET = 16384;
    static final int DRAW = 22777;
    static final int FILL = 9218;
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, n2);
        this.init();
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    void checkGC(int n) {
        int n2;
        int n3 = this.data.state;
        if ((n3 & n) == n) {
            return;
        }
        n3 = (n3 ^ n) & n;
        this.data.state |= n;
        int n4 = this.data.gdipGraphics;
        if (n4 != 0) {
            int n5;
            int n6;
            int n7;
            Object object;
            int n8 = this.data.gdipPen;
            float f = this.data.lineWidth;
            if ((n3 & 1) != 0 || n8 == 0 && (n3 & 0xF8) != 0) {
                int n9;
                if (this.data.gdipFgBrush != 0) {
                    Gdip.SolidBrush_delete(this.data.gdipFgBrush);
                }
                this.data.gdipFgBrush = 0;
                object = this.data.foregroundPattern;
                if (object != null) {
                    n9 = ((Pattern)object).handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(n9)) {
                            case 2: {
                                n9 = Gdip.Brush_Clone(n9);
                                if (n9 == 0) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(n9, -1.0f, 1.0f, 0);
                                this.data.gdipFgBrush = n9;
                            }
                        }
                    }
                } else {
                    n7 = this.data.foreground;
                    n6 = n7 >> 16 & 0xFF | n7 & 0xFF00 | (n7 & 0xFF) << 16;
                    n5 = Gdip.Color_new(this.data.alpha << 24 | n6);
                    if (n5 == 0) {
                        SWT.error(2);
                    }
                    if ((n9 = Gdip.SolidBrush_new(n5)) == 0) {
                        SWT.error(2);
                    }
                    Gdip.Color_delete(n5);
                    this.data.gdipFgBrush = n9;
                }
                if (n8 != 0) {
                    Gdip.Pen_SetBrush(n8, n9);
                } else {
                    n8 = this.data.gdipPen = Gdip.Pen_new(n9, f);
                }
            }
            if ((n3 & 0x10) != 0) {
                Gdip.Pen_SetWidth(n8, f);
                switch (this.data.lineStyle) {
                    case 6: {
                        n3 |= 8;
                    }
                }
            }
            if ((n3 & 8) != 0) {
                float[] fArray = null;
                float f2 = 0.0f;
                n7 = 0;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        n7 = 2;
                        if (f != 0.0f) break;
                        fArray = LINE_DOT_ZERO;
                        break;
                    }
                    case 2: {
                        n7 = 1;
                        if (f != 0.0f) break;
                        fArray = LINE_DASH_ZERO;
                        break;
                    }
                    case 4: {
                        n7 = 3;
                        if (f != 0.0f) break;
                        fArray = LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        n7 = 4;
                        if (f != 0.0f) break;
                        fArray = LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        if (this.data.lineDashes == null) break;
                        f2 = this.data.lineDashesOffset / Math.max(1.0f, f);
                        fArray = new float[this.data.lineDashes.length * 2];
                        for (n6 = 0; n6 < this.data.lineDashes.length; ++n6) {
                            float f3;
                            fArray[n6] = f3 = this.data.lineDashes[n6] / Math.max(1.0f, f);
                            fArray[n6 + this.data.lineDashes.length] = f3;
                        }
                        break;
                    }
                }
                if (fArray != null) {
                    Gdip.Pen_SetDashPattern(n8, fArray, fArray.length);
                    Gdip.Pen_SetDashStyle(n8, 5);
                    Gdip.Pen_SetDashOffset(n8, f2);
                } else {
                    Gdip.Pen_SetDashStyle(n8, n7);
                }
            }
            if ((n3 & 0x80) != 0) {
                Gdip.Pen_SetMiterLimit(n8, this.data.lineMiterLimit);
            }
            if ((n3 & 0x40) != 0) {
                int n10 = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        n10 = 0;
                        break;
                    }
                    case 3: {
                        n10 = 1;
                        break;
                    }
                    case 2: {
                        n10 = 2;
                    }
                }
                Gdip.Pen_SetLineJoin(n8, n10);
            }
            if ((n3 & 0x20) != 0) {
                int n11 = 0;
                int n12 = 0;
                switch (this.data.lineCap) {
                    case 1: {
                        n12 = 0;
                        break;
                    }
                    case 2: {
                        n12 = 2;
                        n11 = 2;
                        break;
                    }
                    case 3: {
                        n12 = 1;
                    }
                }
                Gdip.Pen_SetLineCap(n8, n12, n12, n11);
            }
            if ((n3 & 2) != 0) {
                if (this.data.gdipBgBrush != 0) {
                    Gdip.SolidBrush_delete(this.data.gdipBgBrush);
                }
                this.data.gdipBgBrush = 0;
                Pattern pattern = this.data.backgroundPattern;
                if (pattern != null) {
                    this.data.gdipBrush = pattern.handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(this.data.gdipBrush)) {
                            case 2: {
                                int n13 = Gdip.Brush_Clone(this.data.gdipBrush);
                                if (n13 == 0) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(n13, -1.0f, 1.0f, 0);
                                this.data.gdipBrush = this.data.gdipBgBrush = n13;
                            }
                        }
                    }
                } else {
                    int n14 = this.data.background;
                    n7 = n14 >> 16 & 0xFF | n14 & 0xFF00 | (n14 & 0xFF) << 16;
                    n6 = Gdip.Color_new(this.data.alpha << 24 | n7);
                    if (n6 == 0) {
                        SWT.error(2);
                    }
                    if ((n5 = Gdip.SolidBrush_new(n6)) == 0) {
                        SWT.error(2);
                    }
                    Gdip.Color_delete(n6);
                    this.data.gdipBrush = this.data.gdipBgBrush = n5;
                }
            }
            if ((n3 & 4) != 0) {
                Font font = this.data.font;
                OS.SelectObject(this.handle, font.handle);
                object = new int[1];
                n7 = GC.createGdipFont(this.handle, font.handle, n4, this.device.fontCollection, null, (int[])object);
                if (object[0] != false) {
                    OS.SelectObject(this.handle, (int)object[0]);
                }
                if (this.data.hGDIFont != 0) {
                    OS.DeleteObject(this.data.hGDIFont);
                }
                this.data.hGDIFont = (int)object[0];
                if (this.data.gdipFont != 0) {
                    Gdip.Font_delete(this.data.gdipFont);
                }
                this.data.gdipFont = n7;
            }
            if ((n3 & 0x4000) != 0) {
                float f4;
                this.data.gdipYOffset = 0.0f;
                this.data.gdipXOffset = 0.0f;
                int n15 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                object = new PointF();
                ((PointF)object).Y = 1.0f;
                ((PointF)object).X = 1.0f;
                Gdip.Graphics_GetTransform(n4, n15);
                Gdip.Matrix_TransformVectors(n15, (PointF)object, 1);
                Gdip.Matrix_delete(n15);
                float f5 = ((PointF)object).X;
                if (f5 < 0.0f) {
                    f5 = -f5;
                }
                if ((f4 = this.data.lineWidth * f5) == 0.0f || (int)f4 % 2 == 1) {
                    this.data.gdipXOffset = 0.5f / f5;
                }
                if ((f5 = ((PointF)object).Y) < 0.0f) {
                    f5 = -f5;
                }
                if ((f4 = this.data.lineWidth * f5) == 0.0f || (int)f4 % 2 == 1) {
                    this.data.gdipYOffset = 0.5f / f5;
                }
            }
            return;
        }
        if ((n3 & 0x79) != 0) {
            int n16;
            int n17;
            n2 = this.data.foreground;
            int n18 = (int)this.data.lineWidth;
            int[] nArray = null;
            int n19 = 0;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n19 = 1;
                    break;
                }
                case 3: {
                    n19 = 2;
                    break;
                }
                case 4: {
                    n19 = 3;
                    break;
                }
                case 5: {
                    n19 = 4;
                    break;
                }
                case 6: {
                    if (this.data.lineDashes == null) break;
                    n19 = 7;
                    nArray = new int[this.data.lineDashes.length];
                    for (n17 = 0; n17 < nArray.length; ++n17) {
                        nArray[n17] = (int)this.data.lineDashes[n17];
                    }
                    break;
                }
            }
            if ((n3 & 8) != 0) {
                OS.SetBkMode(this.handle, this.data.lineStyle == 1 ? 2 : 1);
            }
            n17 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n17 = 8192;
                    break;
                }
                case 2: {
                    n17 = 0;
                    break;
                }
                case 3: {
                    n17 = 4096;
                }
            }
            int n20 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n20 = 0;
                    break;
                }
                case 1: {
                    n20 = 512;
                    break;
                }
                case 3: {
                    n20 = 256;
                }
            }
            int n21 = n19 | n17 | n20;
            if (OS.IsWinCE || n18 == 0 && n19 != 7 || n21 == 0) {
                n16 = OS.CreatePen(n21 & 0xF, n18, n2);
            } else {
                LOGBRUSH lOGBRUSH = new LOGBRUSH();
                lOGBRUSH.lbStyle = 0;
                lOGBRUSH.lbColor = n2;
                n16 = OS.ExtCreatePen(n21 | 0x10000, Math.max(1, n18), lOGBRUSH, nArray != null ? nArray.length : 0, nArray);
            }
            OS.SelectObject(this.handle, n16);
            this.data.state |= 0x800;
            this.data.state &= 0xFFFFDFFF;
            if (this.data.hPen != 0) {
                OS.DeleteObject(this.data.hPen);
            }
            this.data.hPen = this.data.hOldPen = n16;
        } else if ((n3 & 0x800) != 0) {
            OS.SelectObject(this.handle, this.data.hOldPen);
            this.data.state &= 0xFFFFDFFF;
        } else if ((n3 & 0x2000) != 0) {
            this.data.hOldPen = OS.SelectObject(this.handle, OS.GetStockObject(8));
            this.data.state &= 0xFFFFF7FF;
        }
        if ((n3 & 2) != 0) {
            n2 = OS.CreateSolidBrush(this.data.background);
            OS.SelectObject(this.handle, n2);
            this.data.state |= 0x400;
            this.data.state &= 0xFFFFEFFF;
            if (this.data.hBrush != 0) {
                OS.DeleteObject(this.data.hBrush);
            }
            this.data.hOldBrush = this.data.hBrush = n2;
        } else if ((n3 & 0x400) != 0) {
            OS.SelectObject(this.handle, this.data.hOldBrush);
            this.data.state &= 0xFFFFEFFF;
        } else if ((n3 & 0x1000) != 0) {
            this.data.hOldBrush = OS.SelectObject(this.handle, OS.GetStockObject(5));
            this.data.state &= 0xFFFFFBFF;
        }
        if ((n3 & 0x200) != 0) {
            OS.SetBkColor(this.handle, this.data.background);
        }
        if ((n3 & 0x100) != 0) {
            OS.SetTextColor(this.handle, this.data.foreground);
        }
        if ((n3 & 4) != 0) {
            Font font = this.data.font;
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void copyArea(Image image, int n, int n2) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.copyAreaInPixels(image, n, n2);
    }

    void copyAreaInPixels(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBoundsInPixels();
        int n3 = OS.CreateCompatibleDC(this.handle);
        int n4 = OS.SelectObject(n3, image.handle);
        OS.BitBlt(n3, 0, 0, rectangle.width, rectangle.height, this.handle, n, n2, 0xCC0020);
        OS.SelectObject(n3, n4);
        OS.DeleteDC(n3);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        this.copyAreaInPixels(n, n2, n3, n4, n5, n6, bl);
    }

    void copyAreaInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n7 = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, n5, n6, n3, n4, this.handle, n, n2, 0xCC0020);
        } else {
            RECT rECT = null;
            int n8 = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, n8) == 1) {
                rECT = new RECT();
                OS.GetRgnBox(n8, rECT);
            }
            OS.DeleteObject(n8);
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, n, n2, n + n3, n2 + n4);
            int n9 = bl ? 6 : 0;
            int n10 = OS.ScrollWindowEx(n7, n5 - n, n6 - n2, rECT2, rECT, 0, null, n9);
            if (n10 == 0 && OS.IsWinCE) {
                OS.BitBlt(this.handle, n5, n6, n3, n4, this.handle, n, n2, 0xCC0020);
                if (bl) {
                    boolean bl2;
                    int n11 = n5 - n;
                    int n12 = n6 - n2;
                    boolean bl3 = bl2 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
                    if (bl2) {
                        OS.InvalidateRect(n7, rECT2, true);
                    } else {
                        int n13;
                        if (n11 != 0) {
                            n13 = n5 - n11;
                            if (n11 < 0) {
                                n13 = n5 + n3;
                            }
                            OS.SetRect(rECT2, n13, n2, n13 + Math.abs(n11), n2 + n4);
                            OS.InvalidateRect(n7, rECT2, true);
                        }
                        if (n12 != 0) {
                            n13 = n6 - n12;
                            if (n12 < 0) {
                                n13 = n6 + n4;
                            }
                            OS.SetRect(rECT2, n, n13, n + n3, n13 + Math.abs(n12));
                            OS.InvalidateRect(n7, rECT2, true);
                        }
                    }
                }
            }
        }
    }

    static int createGdipFont(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = Gdip.Font_new(n, n2);
        if (n5 == 0) {
            SWT.error(2);
        }
        int n6 = 0;
        if (!Gdip.Font_IsAvailable(n5)) {
            int n7;
            char[] cArray;
            Gdip.Font_delete(n5);
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.GetObject(n2, LOGFONT.sizeof, lOGFONT);
            int n8 = Math.abs(lOGFONT.lfHeight);
            int n9 = 0;
            if (lOGFONT.lfWeight == 700) {
                n9 |= 1;
            }
            if (lOGFONT.lfItalic != 0) {
                n9 |= 2;
            }
            if (OS.IsUnicode) {
                cArray = lOGFONT.lfFaceName;
            } else {
                cArray = new char[32];
                byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
                OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
            }
            for (n7 = 0; n7 < cArray.length && cArray[n7] != '\u0000'; ++n7) {
            }
            String string = new String(cArray, 0, n7);
            if (string.equalsIgnoreCase("Courier")) {
                string = "Courier New";
            }
            char[] cArray2 = new char[string.length() + 1];
            string.getChars(0, string.length(), cArray2, 0);
            if (n4 != 0 && !Gdip.FontFamily_IsAvailable(n6 = Gdip.FontFamily_new(cArray2, n4))) {
                Gdip.FontFamily_delete(n6);
                n6 = Gdip.FontFamily_new(cArray2, 0);
                if (!Gdip.FontFamily_IsAvailable(n6)) {
                    Gdip.FontFamily_delete(n6);
                    n6 = 0;
                }
            }
            n5 = n6 != 0 ? Gdip.Font_new(n6, n8, n9, 2) : Gdip.Font_new(cArray2, n8, n9, 2, 0);
            if (nArray2 != null && n5 != 0) {
                int n10 = OS.GetProcessHeap();
                int n11 = OS.HeapAlloc(n10, 8, LOGFONTW.sizeof);
                Gdip.Font_GetLogFontW(n5, n3, n11);
                nArray2[0] = OS.CreateFontIndirectW(n11);
                OS.HeapFree(n10, 0, n11);
            }
        }
        if (nArray != null && n5 != 0) {
            if (n6 == 0) {
                n6 = Gdip.FontFamily_new();
                Gdip.Font_GetFamily(n5, n6);
            }
            nArray[0] = n6;
        } else if (n6 != 0) {
            Gdip.FontFamily_delete(n6);
        }
        if (n5 == 0) {
            SWT.error(2);
        }
        return n5;
    }

    static void destroyGdipBrush(int n) {
        int n2 = Gdip.Brush_GetType(n);
        switch (n2) {
            case 0: {
                Gdip.SolidBrush_delete(n);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete(n);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete(n);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete(n);
            }
        }
    }

    @Override
    void destroy() {
        Image image;
        int n;
        boolean bl = this.data.gdipGraphics != 0;
        this.disposeGdip();
        if (bl && (this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) | 1);
        }
        if (this.data.hPen != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
        if ((n = this.data.hNullBitmap) != 0) {
            OS.SelectObject(this.handle, n);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        this.data = null;
    }

    void disposeGdip() {
        if (this.data.gdipPen != 0) {
            Gdip.Pen_delete(this.data.gdipPen);
        }
        if (this.data.gdipBgBrush != 0) {
            GC.destroyGdipBrush(this.data.gdipBgBrush);
        }
        if (this.data.gdipFgBrush != 0) {
            GC.destroyGdipBrush(this.data.gdipFgBrush);
        }
        if (this.data.gdipFont != 0) {
            Gdip.Font_delete(this.data.gdipFont);
        }
        if (this.data.hGDIFont != 0) {
            OS.DeleteObject(this.data.hGDIFont);
        }
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_delete(this.data.gdipGraphics);
        }
        this.data.hGDIFont = 0;
        this.data.gdipPen = 0;
        this.data.gdipFont = 0;
        this.data.gdipFgBrush = 0;
        this.data.gdipBgBrush = 0;
        this.data.gdipBrush = 0;
        this.data.gdipGraphics = 0;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawArcInPixels(n, n2, n3, n4, n5, n6);
    }

    void drawArcInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.gdipGraphics;
        if (n7 != 0) {
            Gdip.Graphics_TranslateTransform(n7, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            if (n3 == n4) {
                Gdip.Graphics_DrawArc(n7, this.data.gdipPen, n, n2, n3, n4, -n5, -n6);
            } else {
                int n8;
                int n9 = Gdip.GraphicsPath_new(0);
                if (n9 == 0) {
                    SWT.error(2);
                }
                if ((n8 = Gdip.Matrix_new(n3, 0.0f, 0.0f, n4, n, n2)) == 0) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc(n9, 0.0f, 0.0f, 1.0f, 1.0f, -n5, -n6);
                Gdip.GraphicsPath_Transform(n9, n8);
                Gdip.Graphics_DrawPath(n7, this.data.gdipPen, n9);
                Gdip.Matrix_delete(n8);
                Gdip.GraphicsPath_delete(n9);
            }
            Gdip.Graphics_TranslateTransform(n7, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n;
        }
        if (OS.IsWinCE) {
            if (n6 < 0) {
                n5 += n6;
                n6 = -n6;
            }
            if (n6 > 360) {
                n6 = 360;
            }
            int[] nArray = new int[(n6 + 1) * 2];
            int n10 = 2 * n + n3;
            int n11 = 2 * n2 + n4;
            int n12 = 0;
            for (int i = 0; i <= n6; ++i) {
                nArray[n12++] = GC.cos(n5 + i, n3) + n10 >> 1;
                nArray[n12++] = n11 - GC.sin(n5 + i, n4) >> 1;
            }
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            int n13;
            int n14;
            int n15;
            int n16;
            if (n6 >= 360 || n6 <= -360) {
                n15 = n16 = n + n3;
                n13 = n14 = n2 + n4 / 2;
            } else {
                boolean bl = n6 < 0;
                n6 += n5;
                if (bl) {
                    int n17 = n5;
                    n5 = n6;
                    n6 = n17;
                }
                n15 = GC.cos(n5, n3) + n + n3 / 2;
                n13 = -1 * GC.sin(n5, n4) + n2 + n4 / 2;
                n16 = GC.cos(n6, n3) + n + n3 / 2;
                n14 = -1 * GC.sin(n6, n4) + n2 + n4 / 2;
            }
            OS.Arc(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n15, n13, n16, n14);
        }
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawFocusInPixels(n, n2, n3, n4);
    }

    void drawFocusInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((this.data.uiState & 1) != 0) {
            return;
        }
        this.data.focusDrawn = true;
        int n5 = this.handle;
        int n6 = 0;
        int n7 = this.data.gdipGraphics;
        if (n7 != 0) {
            int n8 = 0;
            Gdip.Graphics_SetPixelOffsetMode(n7, 3);
            int n9 = Gdip.Region_new();
            if (n9 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetClip(n7, n9);
            if (!Gdip.Region_IsInfinite(n9, n7)) {
                n8 = Gdip.Region_GetHRGN(n9, n7);
            }
            Gdip.Region_delete(n9);
            Gdip.Graphics_SetPixelOffsetMode(n7, 4);
            float[] fArray = null;
            int n10 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (n10 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(n7, n10);
            if (!Gdip.Matrix_IsIdentity(n10)) {
                fArray = new float[6];
                Gdip.Matrix_GetElements(n10, fArray);
            }
            Gdip.Matrix_delete(n10);
            n5 = Gdip.Graphics_GetHDC(n7);
            n6 = OS.SaveDC(n5);
            if (fArray != null) {
                OS.SetGraphicsMode(n5, 2);
                OS.SetWorldTransform(n5, fArray);
            }
            if (n8 != 0) {
                OS.SelectClipRgn(n5, n8);
                OS.DeleteObject(n8);
            }
        }
        OS.SetBkColor(n5, 0xFFFFFF);
        OS.SetTextColor(n5, 0);
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        OS.DrawFocusRect(n5, rECT);
        if (n7 != 0) {
            OS.RestoreDC(n5, n6);
            Gdip.Graphics_ReleaseHDC(n7, n5);
        } else {
            this.data.state &= 0xFFFFFCFF;
        }
    }

    public void drawImage(Image image, int n, int n2) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawImageInPixels(image, n, n2);
    }

    void drawImageInPixels(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        Rectangle rectangle2 = DPIUtil.autoScaleUp(new Rectangle(n5, n6, n7, n8));
        int n9 = DPIUtil.getDeviceZoom();
        if (n9 != 100) {
            Rectangle rectangle3 = image.getBoundsInPixels();
            int n10 = rectangle.x + rectangle.width - rectangle3.width;
            int n11 = rectangle.y + rectangle.height - rectangle3.height;
            if (n10 != 0 || n11 != 0) {
                if (n10 <= n9 / 100 && n11 <= n9 / 100) {
                    rectangle.intersect(rectangle3);
                } else {
                    SWT.error(5);
                }
            }
        }
        this.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        image.refreshImageForZoom();
        if (this.data.gdipGraphics != 0) {
            int[] nArray = image.createGdipImage();
            int n9 = nArray[0];
            int n10 = Gdip.Image_GetWidth(n9);
            int n11 = Gdip.Image_GetHeight(n9);
            if (bl) {
                n3 = n7 = n10;
                n4 = n8 = n11;
            } else {
                if (n + n3 > n10 || n2 + n4 > n11) {
                    SWT.error(5);
                }
                bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n10 && n4 == n8 && n8 == n11;
            }
            Rect rect = new Rect();
            rect.X = n5;
            rect.Y = n6;
            rect.Width = n7;
            rect.Height = n8;
            int n12 = Gdip.ImageAttributes_new();
            Gdip.ImageAttributes_SetWrapMode(n12, 3);
            if (this.data.alpha != 255) {
                float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)this.data.alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                Gdip.ImageAttributes_SetColorMatrix(n12, fArray, 0, 1);
            }
            int n13 = 0;
            if ((this.data.style & 0x8000000) != 0) {
                n13 = Gdip.Graphics_Save(this.data.gdipGraphics);
                Gdip.Graphics_ScaleTransform(this.data.gdipGraphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(this.data.gdipGraphics, -2 * n5 - n7, 0.0f, 0);
            }
            Gdip.Graphics_DrawImage(this.data.gdipGraphics, n9, rect, n, n2, n3, n4, 2, n12, 0, 0);
            if ((this.data.style & 0x8000000) != 0) {
                Gdip.Graphics_Restore(this.data.gdipGraphics, n13);
            }
            Gdip.ImageAttributes_delete(n12);
            Gdip.Bitmap_delete(n9);
            if (nArray[1] != 0) {
                int n14 = OS.GetProcessHeap();
                OS.HeapFree(n14, 0, nArray[1]);
            }
            return;
        }
        switch (image.type) {
            case 0: {
                this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 1: {
                this.drawIcon(image, n, n2, n3, n4, n5, n6, n7, n8, bl);
            }
        }
    }

    void drawIcon(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        boolean bl2;
        Object object;
        int n9 = OS.GetDeviceCaps(this.handle, 2);
        boolean bl3 = true;
        int n10 = 3;
        int n11 = 0;
        int n12 = 0;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            if ((OS.GetLayout(this.handle) & 1) != 0) {
                n10 |= 0x10;
                object = new POINT();
                OS.GetWindowOrgEx(this.handle, (POINT)object);
                n11 = ((POINT)object).x;
                n12 = ((POINT)object).y;
            }
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl4 = bl3 = (OS.GetLayout(this.handle) & 1) == 0;
        }
        if (bl && n9 != 2 && bl3) {
            if (n11 != 0 || n12 != 0) {
                OS.SetWindowOrgEx(this.handle, 0, 0, null);
            }
            OS.DrawIconEx(this.handle, n5 - n11, n6 - n12, image.handle, 0, 0, 0, 0, n10);
            if (n11 != 0 || n12 != 0) {
                OS.SetWindowOrgEx(this.handle, n11, n12, null);
            }
            return;
        }
        object = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(image, (ICONINFO)object);
        } else {
            OS.GetIconInfo(image.handle, (ICONINFO)object);
        }
        int n13 = ((ICONINFO)object).hbmColor;
        if (n13 == 0) {
            n13 = ((ICONINFO)object).hbmMask;
        }
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n13, BITMAP.sizeof, bITMAP);
        int n14 = bITMAP.bmWidth;
        int n15 = bITMAP.bmHeight;
        if (n13 == ((ICONINFO)object).hbmMask) {
            n15 /= 2;
        }
        if (bl) {
            n3 = n7 = n14;
            n4 = n8 = n15;
        }
        boolean bl5 = bl2 = n + n3 > n14 || n2 + n4 > n15;
        if (!bl2) {
            boolean bl6 = bl = n == 0 && n2 == 0 && n3 == n7 && n4 == n8 && n3 == n14 && n4 == n15;
            if (!bl3) {
                this.drawBitmapMask(image, ((ICONINFO)object).hbmColor, ((ICONINFO)object).hbmMask, n, n2, n3, n4, n5, n6, n7, n8, bl, n14, n15, false);
            } else if (bl && n9 != 2) {
                if (n11 != 0 || n12 != 0) {
                    OS.SetWindowOrgEx(this.handle, 0, 0, null);
                }
                OS.DrawIconEx(this.handle, n5 - n11, n6 - n12, image.handle, 0, 0, 0, 0, n10);
                if (n11 != 0 || n12 != 0) {
                    OS.SetWindowOrgEx(this.handle, n11, n12, null);
                }
            } else {
                boolean bl7;
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                int n16 = OS.CreateCompatibleDC(this.handle);
                int n17 = OS.CreateCompatibleDC(this.handle);
                int n18 = n2;
                int n19 = ((ICONINFO)object).hbmColor;
                if (n19 == 0) {
                    n19 = ((ICONINFO)object).hbmMask;
                    n18 += n15;
                }
                int n20 = OS.SelectObject(n16, n19);
                iCONINFO.hbmColor = OS.CreateCompatibleBitmap(n16, n7, n8);
                if (iCONINFO.hbmColor == 0) {
                    SWT.error(2);
                }
                int n21 = OS.SelectObject(n17, iCONINFO.hbmColor);
                boolean bl8 = bl7 = !bl && (n3 != n7 || n4 != n8);
                if (bl7) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n17, 3);
                    }
                    OS.StretchBlt(n17, 0, 0, n7, n8, n16, n, n18, n3, n4, 0xCC0020);
                } else {
                    OS.BitBlt(n17, 0, 0, n7, n8, n16, n, n18, 0xCC0020);
                }
                OS.SelectObject(n16, ((ICONINFO)object).hbmMask);
                iCONINFO.hbmMask = OS.CreateBitmap(n7, n8, 1, 1, null);
                if (iCONINFO.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(n17, iCONINFO.hbmMask);
                if (bl7) {
                    OS.StretchBlt(n17, 0, 0, n7, n8, n16, n, n2, n3, n4, 0xCC0020);
                } else {
                    OS.BitBlt(n17, 0, 0, n7, n8, n16, n, n2, 0xCC0020);
                }
                if (n9 == 2) {
                    OS.SelectObject(n16, iCONINFO.hbmColor);
                    OS.SelectObject(n17, iCONINFO.hbmMask);
                    this.drawBitmapTransparentByClipping(n16, n17, 0, 0, n7, n8, n5, n6, n7, n8, true, n7, n8);
                    OS.SelectObject(n16, n20);
                    OS.SelectObject(n17, n21);
                } else {
                    OS.SelectObject(n16, n20);
                    OS.SelectObject(n17, n21);
                    int n22 = OS.CreateIconIndirect(iCONINFO);
                    if (n22 == 0) {
                        SWT.error(2);
                    }
                    if (n11 != 0 || n12 != 0) {
                        OS.SetWindowOrgEx(this.handle, 0, 0, null);
                    }
                    OS.DrawIconEx(this.handle, n5 - n11, n6 - n12, n22, n7, n8, 0, 0, n10);
                    if (n11 != 0 || n12 != 0) {
                        OS.SetWindowOrgEx(this.handle, n11, n12, null);
                    }
                    OS.DestroyIcon(n22);
                }
                OS.DeleteObject(iCONINFO.hbmMask);
                OS.DeleteObject(iCONINFO.hbmColor);
                OS.DeleteDC(n17);
                OS.DeleteDC(n16);
            }
        }
        OS.DeleteObject(((ICONINFO)object).hbmMask);
        if (((ICONINFO)object).hbmColor != 0) {
            OS.DeleteObject(((ICONINFO)object).hbmColor);
        }
        if (bl2) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(image.handle, BITMAP.sizeof, bITMAP);
        int n9 = bITMAP.bmWidth;
        int n10 = bITMAP.bmHeight;
        if (bl) {
            n3 = n7 = n9;
            n4 = n8 = n10;
        } else {
            if (n + n3 > n9 || n2 + n4 > n10) {
                SWT.error(5);
            }
            bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n9 && n4 == n8 && n8 == n10;
        }
        boolean bl2 = false;
        GC gC = image.memGC;
        if (gC != null && !gC.isDisposed()) {
            gC.flush();
            bl2 = true;
            GCData gCData = gC.data;
            if (gCData.hNullBitmap != 0) {
                OS.SelectObject(gC.handle, gCData.hNullBitmap);
                gCData.hNullBitmap = 0;
            }
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawBitmapAlpha(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        } else if (image.transparentPixel != -1) {
            this.drawBitmapTransparent(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        } else {
            this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        }
        if (bl2) {
            int n11;
            gC.data.hNullBitmap = n11 = OS.SelectObject(gC.handle, image.handle);
        }
    }

    void drawBitmapAlpha(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12;
        int n13;
        int n14;
        boolean bl2;
        int n15;
        boolean bl3;
        if (image.alpha == 0) {
            return;
        }
        if (image.alpha == 255) {
            this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
            return;
        }
        boolean bl4 = OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10);
        boolean bl5 = bl3 = OS.GetDeviceCaps(this.handle, 2) == 2;
        if (bl4 && bl3 && (n15 = OS.GetDeviceCaps(this.handle, 120)) != 0) {
            if (image.alpha != -1) {
                bl4 = (n15 & 1) != 0;
            } else {
                boolean bl6 = bl4 = (n15 & 2) != 0;
            }
        }
        if (bl4) {
            BLENDFUNCTION bLENDFUNCTION = new BLENDFUNCTION();
            bLENDFUNCTION.BlendOp = 0;
            int n16 = OS.CreateCompatibleDC(this.handle);
            int n17 = OS.SelectObject(n16, image.handle);
            if (image.alpha != -1) {
                bLENDFUNCTION.SourceConstantAlpha = (byte)image.alpha;
                OS.AlphaBlend(this.handle, n5, n6, n7, n8, n16, n, n2, n3, n4, bLENDFUNCTION);
            } else {
                int n18 = Image.createDIB(n3, n4, 32);
                if (n18 == 0) {
                    SWT.error(2);
                }
                int n19 = OS.CreateCompatibleDC(this.handle);
                int n20 = OS.SelectObject(n19, n18);
                BITMAP bITMAP2 = new BITMAP();
                OS.GetObject(n18, BITMAP.sizeof, bITMAP2);
                OS.BitBlt(n19, 0, 0, n3, n4, n16, n, n2, 0xCC0020);
                byte[] byArray = new byte[bITMAP2.bmWidthBytes * bITMAP2.bmHeight];
                OS.MoveMemory(byArray, bITMAP2.bmBits, byArray.length);
                int n21 = n9 - n3;
                int n22 = n2 * n9 + n;
                int n23 = 0;
                byte[] byArray2 = image.alphaData;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n24 = byArray2[n22++] & 0xFF;
                        int n25 = (byArray[n23 + 0] & 0xFF) * n24 + 128;
                        n25 = n25 + (n25 >> 8) >> 8;
                        int n26 = (byArray[n23 + 1] & 0xFF) * n24 + 128;
                        n26 = n26 + (n26 >> 8) >> 8;
                        int n27 = (byArray[n23 + 2] & 0xFF) * n24 + 128;
                        n27 = n27 + (n27 >> 8) >> 8;
                        byArray[n23 + 0] = (byte)n25;
                        byArray[n23 + 1] = (byte)n26;
                        byArray[n23 + 2] = (byte)n27;
                        byArray[n23 + 3] = (byte)n24;
                        n23 += 4;
                    }
                    n22 += n21;
                }
                OS.MoveMemory(bITMAP2.bmBits, byArray, byArray.length);
                bLENDFUNCTION.SourceConstantAlpha = (byte)-1;
                bLENDFUNCTION.AlphaFormat = 1;
                OS.AlphaBlend(this.handle, n5, n6, n7, n8, n19, 0, 0, n3, n4, bLENDFUNCTION);
                OS.SelectObject(n19, n20);
                OS.DeleteDC(n19);
                OS.DeleteObject(n18);
            }
            OS.SelectObject(n16, n17);
            OS.DeleteDC(n16);
            return;
        }
        Rectangle rectangle = this.getClippingInPixels();
        if ((rectangle = rectangle.intersection(new Rectangle(n5, n6, n7, n8))).isEmpty()) {
            return;
        }
        int n28 = n + (rectangle.x - n5) * n3 / n7;
        int n29 = n + (rectangle.x + rectangle.width - n5) * n3 / n7;
        int n30 = n2 + (rectangle.y - n6) * n4 / n8;
        int n31 = n2 + (rectangle.y + rectangle.height - n6) * n4 / n8;
        n5 = rectangle.x;
        n6 = rectangle.y;
        n7 = rectangle.width;
        n8 = rectangle.height;
        n = n28;
        n2 = n30;
        n3 = Math.max(1, n29 - n28);
        n4 = Math.max(1, n31 - n30);
        int n32 = OS.CreateCompatibleDC(this.handle);
        int n33 = OS.SelectObject(n32, image.handle);
        int n34 = OS.CreateCompatibleDC(this.handle);
        int n35 = Image.createDIB(Math.max(n3, n7), Math.max(n4, n8), 32);
        if (n35 == 0) {
            SWT.error(2);
        }
        int n36 = OS.SelectObject(n34, n35);
        BITMAP bITMAP3 = new BITMAP();
        OS.GetObject(n35, BITMAP.sizeof, bITMAP3);
        int n37 = bITMAP3.bmWidthBytes * bITMAP3.bmHeight;
        OS.BitBlt(n34, 0, 0, n7, n8, this.handle, n5, n6, 0xCC0020);
        byte[] byArray = new byte[n37];
        OS.MoveMemory(byArray, bITMAP3.bmBits, n37);
        OS.BitBlt(n34, 0, 0, n3, n4, n32, n, n2, 0xCC0020);
        byte[] byArray3 = new byte[n37];
        OS.MoveMemory(byArray3, bITMAP3.bmBits, n37);
        int n38 = image.alpha;
        boolean bl7 = bl2 = image.alpha == -1;
        if (bl2) {
            n14 = n9 - n3;
            n13 = bITMAP3.bmWidthBytes - n3 * 4;
            n12 = n2 * n9 + n;
            n11 = 3;
            byte[] byArray4 = image.alphaData;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    byArray3[n11] = byArray4[n12++];
                    n11 += 4;
                }
                n12 += n14;
                n11 += n13;
            }
        }
        OS.MoveMemory(bITMAP3.bmBits, byArray3, n37);
        if (OS.IsWinCE && (n7 > n3 || n8 > n4) || !OS.IsWinNT && !OS.IsWinCE || bl3) {
            n14 = OS.CreateCompatibleDC(this.handle);
            n13 = Image.createDIB(n7, n8, 32);
            if (n13 == 0) {
                SWT.error(2);
            }
            n12 = OS.SelectObject(n14, n13);
            if (!(bl || n3 == n7 && n4 == n8)) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(n34, 3);
                }
                OS.StretchBlt(n14, 0, 0, n7, n8, n34, 0, 0, n3, n4, 0xCC0020);
            } else {
                OS.BitBlt(n14, 0, 0, n7, n8, n34, 0, 0, 0xCC0020);
            }
            OS.BitBlt(n34, 0, 0, n7, n8, n14, 0, 0, 0xCC0020);
            OS.SelectObject(n14, n12);
            OS.DeleteObject(n13);
            OS.DeleteDC(n14);
        } else if (!(bl || n3 == n7 && n4 == n8)) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n34, 3);
            }
            OS.StretchBlt(n34, 0, 0, n7, n8, n34, 0, 0, n3, n4, 0xCC0020);
        } else {
            OS.BitBlt(n34, 0, 0, n7, n8, n34, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(byArray3, bITMAP3.bmBits, n37);
        n14 = bITMAP3.bmWidthBytes - n7 * 4;
        n13 = 0;
        for (n12 = 0; n12 < n8; ++n12) {
            for (n11 = 0; n11 < n7; ++n11) {
                if (bl2) {
                    n38 = byArray3[n13 + 3] & 0xFF;
                }
                int n39 = n13;
                byArray[n39] = (byte)(byArray[n39] + ((byArray3[n13] & 0xFF) - (byArray[n13] & 0xFF)) * n38 / 255);
                int n40 = n13 + 1;
                byArray[n40] = (byte)(byArray[n40] + ((byArray3[n13 + 1] & 0xFF) - (byArray[n13 + 1] & 0xFF)) * n38 / 255);
                int n41 = n13 + 2;
                byArray[n41] = (byte)(byArray[n41] + ((byArray3[n13 + 2] & 0xFF) - (byArray[n13 + 2] & 0xFF)) * n38 / 255);
                n13 += 4;
            }
            n13 += n14;
        }
        OS.MoveMemory(bITMAP3.bmBits, byArray, n37);
        OS.BitBlt(this.handle, n5, n6, n7, n8, n34, 0, 0, 0xCC0020);
        OS.SelectObject(n34, n36);
        OS.DeleteDC(n34);
        OS.DeleteObject(n35);
        OS.SelectObject(n32, n33);
        OS.DeleteDC(n32);
    }

    void drawBitmapTransparentByClipping(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, int n11, int n12) {
        int n13;
        int n14;
        int n15 = OS.CreateRectRgn(0, 0, 0, 0);
        for (n14 = 0; n14 < n12; ++n14) {
            for (int i = 0; i < n11; ++i) {
                if (OS.GetPixel(n2, i, n14) != 0) continue;
                int n16 = OS.CreateRectRgn(i, n14, i + 1, n14 + 1);
                OS.CombineRgn(n15, n15, n16, 2);
                OS.DeleteObject(n16);
            }
        }
        if (n9 != n5 || n10 != n6) {
            n14 = OS.GetRegionData(n15, 0, null);
            int[] nArray = new int[n14 / 4];
            OS.GetRegionData(n15, n14, nArray);
            float[] fArray = new float[]{(float)n9 / (float)n5, 0.0f, 0.0f, (float)n10 / (float)n6, 0.0f, 0.0f};
            n13 = OS.ExtCreateRegion(fArray, n14, nArray);
            OS.DeleteObject(n15);
            n15 = n13;
        }
        OS.OffsetRgn(n15, n7, n8);
        n14 = OS.CreateRectRgn(0, 0, 0, 0);
        int n17 = OS.GetClipRgn(this.handle, n14);
        if (n17 == 1) {
            OS.CombineRgn(n15, n15, n14, 1);
        }
        OS.SelectClipRgn(this.handle, n15);
        int n18 = 0;
        if (!OS.IsWinCE) {
            n18 = OS.GetROP2(this.handle);
        } else {
            n18 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n18);
        }
        int n19 = n13 = n18 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl || n5 == n9 && n6 == n10)) {
            int n20 = 0;
            if (!OS.IsWinCE) {
                n20 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n7, n8, n9, n10, n, n3, n4, n5, n6, n13);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n20);
            }
        } else {
            OS.BitBlt(this.handle, n7, n8, n9, n10, n, n3, n4, n13);
        }
        OS.SelectClipRgn(this.handle, n17 == 1 ? n14 : 0);
        OS.DeleteObject(n14);
        OS.DeleteObject(n15);
    }

    void drawBitmapMask(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, int n11, int n12, boolean bl2) {
        int n13 = n4;
        if (n == 0) {
            n = n2;
            n13 += n12;
        }
        int n14 = OS.CreateCompatibleDC(this.handle);
        int n15 = OS.SelectObject(n14, n);
        int n16 = this.handle;
        int n17 = n7;
        int n18 = n8;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        if (bl2) {
            n19 = OS.CreateCompatibleDC(this.handle);
            n20 = OS.CreateCompatibleBitmap(this.handle, n9, n10);
            n21 = OS.SelectObject(n19, n20);
            OS.BitBlt(n19, 0, 0, n9, n10, this.handle, n7, n8, 0xCC0020);
            n16 = n19;
            n18 = 0;
            n17 = 0;
        } else {
            n22 = OS.SetBkColor(this.handle, 0xFFFFFF);
            n23 = OS.SetTextColor(this.handle, 0);
        }
        if (!(bl || n5 == n9 && n6 == n10)) {
            int n24 = 0;
            if (!OS.IsWinCE) {
                n24 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(n16, n17, n18, n9, n10, n14, n3, n13, n5, n6, 0x660046);
            OS.SelectObject(n14, n2);
            OS.StretchBlt(n16, n17, n18, n9, n10, n14, n3, n4, n5, n6, 8913094);
            OS.SelectObject(n14, n);
            OS.StretchBlt(n16, n17, n18, n9, n10, n14, n3, n13, n5, n6, 0x660046);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n24);
            }
        } else {
            OS.BitBlt(n16, n17, n18, n9, n10, n14, n3, n13, 0x660046);
            OS.SetTextColor(n16, 0);
            OS.SelectObject(n14, n2);
            OS.BitBlt(n16, n17, n18, n9, n10, n14, n3, n4, 8913094);
            OS.SelectObject(n14, n);
            OS.BitBlt(n16, n17, n18, n9, n10, n14, n3, n13, 0x660046);
        }
        if (bl2) {
            OS.BitBlt(this.handle, n7, n8, n9, n10, n19, 0, 0, 0xCC0020);
            OS.SelectObject(n19, n21);
            OS.DeleteDC(n19);
            OS.DeleteObject(n20);
        } else {
            OS.SetBkColor(this.handle, n22);
            OS.SetTextColor(this.handle, n23);
        }
        OS.SelectObject(n14, n15);
        OS.DeleteDC(n14);
    }

    void drawBitmapTransparent(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        boolean bl2 = bITMAP.bmBits != 0;
        int n16 = image.handle;
        int n17 = OS.CreateCompatibleDC(this.handle);
        int n18 = OS.SelectObject(n17, n16);
        byte[] byArray = null;
        int n19 = image.transparentColor;
        if (n19 == -1) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            if (bITMAP.bmBitsPixel <= 8) {
                if (bl2) {
                    if (OS.IsWinCE) {
                        byte[] byArray2 = new byte[1];
                        OS.MoveMemory(byArray2, bITMAP.bmBits, 1);
                        n11 = byArray2[0];
                        int n20 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                        byArray2[0] = (byte)(image.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray2[0] & ~n20);
                        OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                        int n21 = OS.GetPixel(n17, 0, 0);
                        byArray2[0] = n11;
                        OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                        n15 = (n21 & 0xFF0000) >> 16;
                        n14 = (n21 & 0xFF00) >> 8;
                        n13 = n21 & 0xFF;
                    } else {
                        int n22 = 1 << bITMAP.bmBitsPixel;
                        byte[] byArray3 = new byte[n22 * 4];
                        OS.GetDIBColorTable(n17, 0, n22, byArray3);
                        int n23 = image.transparentPixel * 4;
                        for (int i = 0; i < byArray3.length; i += 4) {
                            if (i == n23 || byArray3[n23] != byArray3[i] || byArray3[n23 + 1] != byArray3[i + 1] || byArray3[n23 + 2] != byArray3[i + 2]) continue;
                            n12 = 1;
                            break;
                        }
                        if (n12 != 0) {
                            byte[] byArray4 = new byte[byArray3.length];
                            n15 = 255;
                            n14 = 255;
                            n13 = 255;
                            byArray4[n23] = (byte)n15;
                            byArray4[n23 + 1] = (byte)n14;
                            byArray4[n23 + 2] = (byte)n13;
                            OS.SetDIBColorTable(n17, 0, n22, byArray4);
                            byArray = byArray3;
                        } else {
                            n15 = byArray3[n23] & 0xFF;
                            n14 = byArray3[n23 + 1] & 0xFF;
                            n13 = byArray3[n23 + 2] & 0xFF;
                        }
                    }
                } else {
                    int n24 = 1 << bITMAP.bmBitsPixel;
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biPlanes = bITMAP.bmPlanes;
                    bITMAPINFOHEADER.biBitCount = bITMAP.bmBitsPixel;
                    byte[] byArray5 = new byte[BITMAPINFOHEADER.sizeof + n24 * 4];
                    OS.MoveMemory(byArray5, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n17, image.handle, 0, 0, null, byArray5, 0);
                    int n25 = BITMAPINFOHEADER.sizeof + 4 * image.transparentPixel;
                    n13 = byArray5[n25 + 2] & 0xFF;
                    n14 = byArray5[n25 + 1] & 0xFF;
                    n15 = byArray5[n25] & 0xFF;
                }
            } else {
                int n26 = image.transparentPixel;
                switch (bITMAP.bmBitsPixel) {
                    case 16: {
                        n15 = (n26 & 0x1F) << 3;
                        n14 = (n26 & 0x3E0) >> 2;
                        n13 = (n26 & 0x7C00) >> 7;
                        break;
                    }
                    case 24: {
                        n15 = (n26 & 0xFF0000) >> 16;
                        n14 = (n26 & 0xFF00) >> 8;
                        n13 = n26 & 0xFF;
                        break;
                    }
                    case 32: {
                        n15 = (n26 & 0xFF000000) >>> 24;
                        n14 = (n26 & 0xFF0000) >> 16;
                        n13 = (n26 & 0xFF00) >> 8;
                    }
                }
            }
            n19 = n15 << 16 | n14 << 8 | n13;
            if (n12 == 0) {
                image.transparentColor = n19;
            }
        }
        if (OS.IsWinCE) {
            OS.TransparentImage(this.handle, n5, n6, n7, n8, n17, n, n2, n3, n4, n19);
        } else if (byArray == null && OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            n15 = OS.SetStretchBltMode(this.handle, 3);
            OS.TransparentBlt(this.handle, n5, n6, n7, n8, n17, n, n2, n3, n4, n19);
            OS.SetStretchBltMode(this.handle, n15);
        } else {
            n15 = OS.CreateCompatibleDC(this.handle);
            n14 = OS.CreateBitmap(n9, n10, 1, 1, null);
            n13 = OS.SelectObject(n15, n14);
            OS.SetBkColor(n17, n19);
            OS.BitBlt(n15, 0, 0, n9, n10, n17, 0, 0, 0xCC0020);
            if (byArray != null) {
                OS.SetDIBColorTable(n17, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(n17, n15, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10);
            } else {
                n12 = OS.CreateCompatibleDC(this.handle);
                int n27 = OS.CreateCompatibleBitmap(this.handle, n7, n8);
                n11 = OS.SelectObject(n12, n27);
                OS.BitBlt(n12, 0, 0, n7, n8, this.handle, n5, n6, 0xCC0020);
                if (!(bl || n3 == n7 && n4 == n8)) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n12, 3);
                    }
                    OS.StretchBlt(n12, 0, 0, n7, n8, n17, n, n2, n3, n4, 0x660046);
                    OS.StretchBlt(n12, 0, 0, n7, n8, n15, n, n2, n3, n4, 8913094);
                    OS.StretchBlt(n12, 0, 0, n7, n8, n17, n, n2, n3, n4, 0x660046);
                } else {
                    OS.BitBlt(n12, 0, 0, n7, n8, n17, n, n2, 0x660046);
                    OS.BitBlt(n12, 0, 0, n7, n8, n15, n, n2, 8913094);
                    OS.BitBlt(n12, 0, 0, n7, n8, n17, n, n2, 0x660046);
                }
                OS.BitBlt(this.handle, n5, n6, n7, n8, n12, 0, 0, 0xCC0020);
                OS.SelectObject(n12, n11);
                OS.DeleteDC(n12);
                OS.DeleteObject(n27);
            }
            OS.SelectObject(n15, n13);
            OS.DeleteDC(n15);
            OS.DeleteObject(n14);
        }
        OS.SelectObject(n17, n18);
        if (n16 != image.handle) {
            OS.DeleteObject(n16);
        }
        OS.DeleteDC(n17);
    }

    void drawBitmap(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12 = OS.CreateCompatibleDC(this.handle);
        int n13 = OS.SelectObject(n12, image.handle);
        int n14 = 0;
        if (!OS.IsWinCE) {
            n14 = OS.GetROP2(this.handle);
        } else {
            n14 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n14);
        }
        int n15 = n11 = n14 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl || n3 == n7 && n4 == n8)) {
            int n16 = 0;
            if (!OS.IsWinCE) {
                n16 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n5, n6, n7, n8, n12, n, n2, n3, n4, n11);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n16);
            }
        } else {
            OS.BitBlt(this.handle, n5, n6, n7, n8, n12, n, n2, n11);
        }
        OS.SelectObject(n12, n13);
        OS.DeleteDC(n12);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n3 = DPIUtil.autoScaleUp(n3);
        n2 = DPIUtil.autoScaleUp(n2);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawLineInPixels(n, n2, n3, n4);
    }

    void drawLineInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            Gdip.Graphics_TranslateTransform(n5, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLine(n5, this.data.gdipPen, n, n2, n3, n4);
            Gdip.Graphics_TranslateTransform(n5, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n;
            --n3;
        }
        if (OS.IsWinCE) {
            int[] nArray = new int[]{n, n2, n3, n4};
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            OS.MoveToEx(this.handle, n, n2, 0);
            OS.LineTo(this.handle, n3, n4);
        }
        if (this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, n3, n4, this.data.foreground);
        }
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawOvalInPixels(n, n2, n3, n4);
    }

    void drawOvalInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            Gdip.Graphics_TranslateTransform(n5, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawEllipse(n5, this.data.gdipPen, n, n2, n3, n4);
            Gdip.Graphics_TranslateTransform(n5, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n;
        }
        OS.Ellipse(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(22777);
        int n = this.data.gdipGraphics;
        Gdip.Graphics_TranslateTransform(n, this.data.gdipXOffset, this.data.gdipYOffset, 0);
        Gdip.Graphics_DrawPath(n, this.data.gdipPen, path.handle);
        Gdip.Graphics_TranslateTransform(n, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
    }

    public void drawPoint(int n, int n2) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawPointInPixels(n, n2);
    }

    void drawPointInPixels(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0) {
            this.checkGC(22777);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.getFgBrush(), n, n2, 1, 1);
            return;
        }
        OS.SetPixel(this.handle, n, n2, this.data.foreground);
    }

    public void drawPolygon(int[] nArray) {
        if (nArray == null) {
            SWT.error(4);
        }
        this.drawPolygonInPixels(DPIUtil.autoScaleUp(nArray));
    }

    void drawPolygonInPixels(int[] nArray) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n2 = this.data.gdipGraphics;
        if (n2 != 0) {
            Gdip.Graphics_TranslateTransform(n2, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawPolygon(n2, this.data.gdipPen, nArray, nArray.length / 2);
            Gdip.Graphics_TranslateTransform(n2, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n = 0; n < nArray.length; n += 2) {
                int n3 = n;
                nArray[n3] = nArray[n3] - 1;
            }
        }
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n = 0; n < nArray.length; n += 2) {
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
            }
        }
    }

    public void drawPolyline(int[] nArray) {
        this.drawPolylineInPixels(DPIUtil.autoScaleUp(nArray));
    }

    void drawPolylineInPixels(int[] nArray) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(22777);
        int n2 = this.data.gdipGraphics;
        if (n2 != 0) {
            Gdip.Graphics_TranslateTransform(n2, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLines(n2, this.data.gdipPen, nArray, nArray.length / 2);
            Gdip.Graphics_TranslateTransform(n2, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (n = 0; n < nArray.length; n += 2) {
                int n3 = n;
                nArray[n3] = nArray[n3] - 1;
            }
        }
        OS.Polyline(this.handle, nArray, nArray.length / 2);
        n = nArray.length;
        if (n >= 2 && this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, nArray[n - 2], nArray[n - 1], this.data.foreground);
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (int i = 0; i < nArray.length; i += 2) {
                int n4 = i;
                nArray[n4] = nArray[n4] + 1;
            }
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.drawRectangleInPixels(n, n2, n3, n4);
    }

    void drawRectangleInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        int n5 = this.data.gdipGraphics;
        if (n5 != 0) {
            if (n3 < 0) {
                n += n3;
                n3 = -n3;
            }
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            Gdip.Graphics_TranslateTransform(n5, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawRectangle(n5, this.data.gdipPen, n, n2, n3, n4);
            Gdip.Graphics_TranslateTransform(n5, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            if (this.data.lineWidth > 1.0f) {
                if (this.data.lineWidth % 2.0f == 1.0f) {
                    ++n;
                }
            } else if (this.data.hPen != 0 && OS.GetObject(this.data.hPen, 0, 0) != LOGPEN.sizeof) {
                ++n;
            }
        }
        OS.Rectangle(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        this.drawRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        this.drawRoundRectangleInPixels(n, n2, n3, n4, n5, n6);
    }

    void drawRoundRectangleInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (this.data.gdipGraphics != 0) {
            this.drawRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipPen, n, n2, n3, n4, n5, n6);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --n;
        }
        if (OS.IsWinCE) {
            if (n3 == 0 || n4 == 0) {
                return;
            }
            if (n5 == 0 || n6 == 0) {
                this.drawRectangleInPixels(n, n2, n3, n4);
                return;
            }
            if (n3 < 0) {
                n += n3;
                n3 = -n3;
            }
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            if (n5 < n3) {
                this.drawLineInPixels(n + n5 / 2, n2, n + n3 - n5 / 2, n2);
                this.drawLineInPixels(n + n5 / 2, n2 + n4, n + n3 - n5 / 2, n2 + n4);
            }
            if (n6 < n4) {
                this.drawLineInPixels(n, n2 + n6 / 2, n, n2 + n4 - n6 / 2);
                this.drawLineInPixels(n + n3, n2 + n6 / 2, n + n3, n2 + n4 - n6 / 2);
            }
            if (n5 != 0 && n6 != 0) {
                this.drawArcInPixels(n, n2, n5, n6, 90, 90);
                this.drawArcInPixels(n + n3 - n5, n2, n5, n6, 0, 90);
                this.drawArcInPixels(n + n3 - n5, n2 + n4 - n6, n5, n6, 0, -90);
                this.drawArcInPixels(n, n2 + n4 - n6, n5, n6, 180, 90);
            }
        } else {
            OS.RoundRect(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n5, n6);
        }
    }

    void drawRoundRectangleGdip(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        int n14 = n8;
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
            n10 -= n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if (n14 < 0) {
            n14 = 0 - n14;
        }
        Gdip.Graphics_TranslateTransform(n, this.data.gdipXOffset, this.data.gdipYOffset, 0);
        if (n13 == 0 || n14 == 0) {
            Gdip.Graphics_DrawRectangle(n, this.data.gdipPen, n3, n4, n5, n6);
        } else {
            int n15 = Gdip.GraphicsPath_new(0);
            if (n15 == 0) {
                SWT.error(2);
            }
            if (n11 > n13) {
                if (n12 > n14) {
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10, n13, n14, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10, n13, n14, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10 + n12 - n14, n13, n14, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10 + n12 - n14, n13, n14, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10, n13, n12, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10, n13, n12, -90.0f, -180.0f);
                }
            } else if (n12 > n14) {
                Gdip.GraphicsPath_AddArc(n15, n9, n10, n11, n14, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(n15, n9, n10 + n12 - n14, n11, n14, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(n15, n9, n10, n11, n12, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(n15);
            Gdip.Graphics_DrawPath(n, n2, n15);
            Gdip.GraphicsPath_delete(n15);
        }
        Gdip.Graphics_TranslateTransform(n, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
    }

    public void drawString(String string, int n, int n2) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawStringInPixels(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawStringInPixels(string, n, n2, bl);
    }

    void drawStringInPixels(String string, int n, int n2, boolean bl) {
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n3 = string.length()) == 0) {
            return;
        }
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = this.data.gdipGraphics;
        if (n4 != 0) {
            this.checkGC(5 | (bl ? 0 : 2));
            this.drawText(n4, string, n, n2, bl ? 1 : 0, null);
            return;
        }
        int n5 = 0;
        if (OS.IsWinCE) {
            n5 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n5);
        } else {
            n5 = OS.GetROP2(this.handle);
        }
        this.checkGC(772);
        int n6 = OS.SetBkMode(this.handle, bl ? 1 : 2);
        RECT rECT = null;
        SIZE sIZE = null;
        int n7 = 0;
        if ((this.data.style & 0x8000000) != 0) {
            if (!bl) {
                sIZE = new SIZE();
                OS.GetTextExtentPoint32W(this.handle, cArray, n3, sIZE);
                rECT = new RECT();
                rECT.left = n;
                rECT.right = n + sIZE.cx;
                rECT.top = n2;
                rECT.bottom = n2 + sIZE.cy;
                n7 = 4;
            }
            --n;
        }
        if (n5 != 7) {
            OS.ExtTextOutW(this.handle, n, n2, n7, rECT, cArray, n3, null);
        } else {
            int n8 = OS.GetTextColor(this.handle);
            if (bl) {
                int n9;
                int n10;
                int n11;
                if (sIZE == null) {
                    sIZE = new SIZE();
                    OS.GetTextExtentPoint32W(this.handle, cArray, n3, sIZE);
                }
                if ((n11 = OS.CreateCompatibleBitmap(this.handle, n10 = sIZE.cx, n9 = sIZE.cy)) == 0) {
                    SWT.error(2);
                }
                int n12 = OS.CreateCompatibleDC(this.handle);
                int n13 = OS.SelectObject(n12, n11);
                OS.PatBlt(n12, 0, 0, n10, n9, 66);
                OS.SetBkMode(n12, 1);
                OS.SetTextColor(n12, n8);
                OS.SelectObject(n12, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOutW(n12, 0, 0, 0, null, cArray, n3, null);
                OS.BitBlt(this.handle, n, n2, n10, n9, n12, 0, 0, 0x660046);
                OS.SelectObject(n12, n13);
                OS.DeleteDC(n12);
                OS.DeleteObject(n11);
            } else {
                int n14 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n8 ^ n14);
                OS.ExtTextOutW(this.handle, n, n2, n7, rECT, cArray, n3, null);
                OS.SetTextColor(this.handle, n8);
            }
        }
        OS.SetBkMode(this.handle, n6);
    }

    public void drawText(String string, int n, int n2) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawTextInPixels(string, n, n2);
    }

    void drawTextInPixels(String string, int n, int n2) {
        this.drawTextInPixels(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawTextInPixels(string, n, n2, bl);
    }

    void drawTextInPixels(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawTextInPixels(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        this.drawTextInPixels(string, n, n2, n3);
    }

    void drawTextInPixels(String string, int n, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n4 = this.data.gdipGraphics;
        if (n4 != 0) {
            this.checkGC(5 | ((n3 & 1) != 0 ? 0 : 2));
            this.drawText(n4, string, n, n2, n3, null);
            return;
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n5 = tCHAR.length();
        if (n5 == 0) {
            return;
        }
        RECT rECT = new RECT();
        int n6 = OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF;
        OS.SetRect(rECT, n, n2, n6, n6);
        int n7 = 0;
        if ((n3 & 2) == 0) {
            n7 |= 0x20;
        }
        if ((n3 & 4) != 0) {
            n7 |= 0x40;
        }
        if ((n3 & 8) == 0) {
            n7 |= 0x800;
        }
        if ((n3 & 8) != 0 && (this.data.uiState & 2) != 0) {
            n7 |= 0x100000;
        }
        int n8 = 0;
        if (OS.IsWinCE) {
            n8 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n8);
        } else {
            n8 = OS.GetROP2(this.handle);
        }
        this.checkGC(772);
        int n9 = OS.SetBkMode(this.handle, (n3 & 1) != 0 ? 1 : 2);
        if (n8 != 7) {
            OS.DrawText(this.handle, tCHAR, n5, rECT, n7);
        } else {
            int n10 = OS.GetTextColor(this.handle);
            if ((n3 & 1) != 0) {
                OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n7 | 0x400);
                int n11 = rECT.right - rECT.left;
                int n12 = rECT.bottom - rECT.top;
                int n13 = OS.CreateCompatibleBitmap(this.handle, n11, n12);
                if (n13 == 0) {
                    SWT.error(2);
                }
                int n14 = OS.CreateCompatibleDC(this.handle);
                int n15 = OS.SelectObject(n14, n13);
                OS.PatBlt(n14, 0, 0, n11, n12, 66);
                OS.SetBkMode(n14, 1);
                OS.SetTextColor(n14, n10);
                OS.SelectObject(n14, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rECT, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(n14, tCHAR, n5, rECT, n7);
                OS.BitBlt(this.handle, n, n2, n11, n12, n14, 0, 0, 0x660046);
                OS.SelectObject(n14, n15);
                OS.DeleteDC(n14);
                OS.DeleteObject(n13);
            } else {
                int n16 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n10 ^ n16);
                OS.DrawText(this.handle, tCHAR, n5, rECT, n7);
                OS.SetTextColor(this.handle, n10);
            }
        }
        OS.SetBkMode(this.handle, n9);
    }

    boolean useGDIP(int n, char[] cArray) {
        if (OS.IsWinCE || !OS.IsUnicode) {
            return false;
        }
        short[] sArray = new short[cArray.length];
        OS.GetGlyphIndicesW(n, cArray, cArray.length, sArray, 1);
        block3: for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != -1) continue;
            switch (cArray[i]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    void drawText(int n, String string, int n2, int n3, int n4, Point point) {
        int n5 = string.length();
        char[] cArray = new char[n5];
        string.getChars(0, n5, cArray, 0);
        int n6 = Gdip.Graphics_GetHDC(n);
        int n7 = this.data.hGDIFont;
        if (n7 == 0 && this.data.font != null) {
            n7 = this.data.font.handle;
        }
        int n8 = 0;
        if (n7 != 0) {
            n8 = OS.SelectObject(n6, n7);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n6, tEXTMETRIC);
        boolean bl = this.useGDIP(n6, cArray);
        if (n7 != 0) {
            OS.SelectObject(n6, n8);
        }
        Gdip.Graphics_ReleaseHDC(n, n6);
        if (bl) {
            this.drawTextGDIP(n, string, n2, n3, n4, point == null, point);
            return;
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = n2;
        int n13 = n3;
        int n14 = 0;
        int n15 = -1;
        if ((n4 & 0xE) != 0) {
            int n16 = tEXTMETRIC.tmAveCharWidth * 8;
            while (n9 < n5) {
                int n17 = n11++;
                char c = cArray[n9++];
                cArray[n17] = c;
                char c2 = c;
                switch (c2) {
                    case '\t': {
                        if ((n4 & 4) == 0) break;
                        int n18 = n11 - n10 - 1;
                        RectF rectF = this.drawText(n, cArray, n10, n18, n12, n13, n4, n15, tEXTMETRIC, point == null);
                        n12 = (int)((double)n12 + Math.ceil(rectF.Width));
                        n12 = n2 + ((n12 - n2) / n16 + 1) * n16;
                        n15 = -1;
                        n10 = n11;
                        break;
                    }
                    case '&': {
                        if ((n4 & 8) == 0) break;
                        if (n9 == n5) {
                            --n11;
                            break;
                        }
                        if (cArray[n9] == '&') {
                            ++n9;
                            break;
                        }
                        n15 = --n11 - n10;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((n4 & 2) == 0) break;
                        int n18 = n11 - n10 - 1;
                        if (c2 == '\r' && n11 != n5 && cArray[n11] == '\n') {
                            ++n11;
                            ++n9;
                        }
                        RectF rectF = this.drawText(n, cArray, n10, n18, n12, n13, n4, n15, tEXTMETRIC, point == null);
                        n13 = (int)((double)n13 + Math.ceil(rectF.Height));
                        n14 = Math.max(n14, n12 + (int)Math.ceil(rectF.Width));
                        n12 = n2;
                        n15 = -1;
                        n10 = n11;
                    }
                }
            }
            n5 = n11;
        }
        RectF rectF = this.drawText(n, cArray, n10, n5 - n10, n12, n13, n4, n15, tEXTMETRIC, point == null);
        if (point != null) {
            n13 = (int)((double)n13 + Math.ceil(rectF.Height));
            point.x = n14 = Math.max(n14, n12 + (int)Math.ceil(rectF.Width));
            point.y = n13;
        }
    }

    RectF drawText(int n, char[] cArray, int n2, int n3, int n4, int n5, int n6, int n7, TEXTMETRIC tEXTMETRIC, boolean bl) {
        boolean bl2;
        boolean bl3 = bl && n7 != -1 && (this.data.uiState & 2) == 0;
        boolean bl4 = bl2 = !bl || bl3 || (n6 & 1) == 0 || (this.data.style & 0x8000000) != 0 || (n6 & 2) != 0;
        if (n3 <= 0) {
            RectF rectF = null;
            if (bl2) {
                rectF = new RectF();
                rectF.Height = tEXTMETRIC.tmHeight;
            }
            return rectF;
        }
        int n8 = n3 * 3 / 2 + 16;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n8;
        int n9 = OS.GetProcessHeap();
        int n10 = gCP_RESULTS.lpDx = OS.HeapAlloc(n9, 8, n8 * 4);
        int n11 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(n9, 8, n8 * 2);
        int n12 = 0;
        int n13 = 50;
        if (bl3) {
            n12 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n9, 8, n8 * 4);
        }
        int n14 = Gdip.Graphics_GetHDC(n);
        int n15 = this.data.hGDIFont;
        if (n15 == 0 && this.data.font != null) {
            n15 = this.data.font.handle;
        }
        int n16 = 0;
        if (n15 != 0) {
            n16 = OS.SelectObject(n14, n15);
        }
        if (n2 != 0) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            cArray = cArray2;
        }
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(n14, OS.GetLayout(n14) | 1);
        }
        OS.GetCharacterPlacementW(n14, cArray, n3, 0, gCP_RESULTS, n13);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(n14, OS.GetLayout(n14) & 0xFFFFFFFE);
        }
        if (n15 != 0) {
            OS.SelectObject(n14, n16);
        }
        Gdip.Graphics_ReleaseHDC(n, n14);
        n8 = gCP_RESULTS.nGlyphs;
        int n17 = n4;
        int n18 = n5 + tEXTMETRIC.tmAscent;
        int[] nArray = new int[n8];
        OS.MoveMemory(nArray, gCP_RESULTS.lpDx, n8 * 4);
        float[] fArray = new float[nArray.length * 2];
        int n19 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            fArray[n19++] = n17;
            fArray[n19++] = n18;
            n17 += nArray[i];
        }
        RectF rectF = null;
        if (bl2) {
            rectF = new RectF();
            Gdip.Graphics_MeasureDriverString(n, n11, n8, this.data.gdipFont, fArray, 0, 0, rectF);
        }
        if (bl) {
            int n20;
            if ((n6 & 1) == 0) {
                Gdip.Graphics_FillRectangle(n, this.data.gdipBrush, n4, n5, (int)Math.ceil(rectF.Width), (int)Math.ceil(rectF.Height));
            }
            n19 = 0;
            int n21 = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n21)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(n21, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(n21, (float)(-2 * n4) - rectF.Width, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(n21, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(n21, (float)(-2 * n4) - rectF.Width, 0.0f, 0);
                    }
                }
                n19 = Gdip.Graphics_Save(n);
                Gdip.Graphics_ScaleTransform(n, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n, (float)(-2 * n4) - rectF.Width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(n, n11, gCP_RESULTS.nGlyphs, this.data.gdipFont, n21, fArray, 0, 0);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n21)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(n21);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(n21);
                    }
                }
                Gdip.Graphics_Restore(n, n19);
            }
            if (bl3 && (n20 = Gdip.Pen_new(n21, 1.0f)) != 0) {
                int n22;
                int n23;
                int[] nArray2 = new int[1];
                OS.MoveMemory(nArray2, gCP_RESULTS.lpOrder + n7 * 4, 4);
                if ((this.data.style & 0x8000000) != 0) {
                    n23 = (int)Math.ceil(rectF.Width) - (int)fArray[nArray2[0] * 2] + 2 * n4;
                    n22 = n23 - nArray[nArray2[0]];
                } else {
                    n23 = (int)fArray[nArray2[0] * 2];
                    n22 = n23 + nArray[nArray2[0]];
                }
                int n24 = n5 + tEXTMETRIC.tmAscent + 2;
                int n25 = Gdip.Graphics_GetSmoothingMode(n);
                Gdip.Graphics_SetSmoothingMode(n, 3);
                Gdip.Graphics_DrawLine(n, n20, n23, n24, n22, n24);
                Gdip.Graphics_SetSmoothingMode(n, n25);
                Gdip.Pen_delete(n20);
            }
        }
        if (n12 != 0) {
            OS.HeapFree(n9, 0, n12);
        }
        OS.HeapFree(n9, 0, n11);
        OS.HeapFree(n9, 0, n10);
        return rectF;
    }

    void drawTextGDIP(int n, String string, int n2, int n3, int n4, boolean bl, Point point) {
        int n5;
        float[] fArray;
        char[] cArray;
        boolean bl2 = !bl || (n4 & 1) == 0;
        int n6 = string.length();
        if (n6 != 0) {
            cArray = new char[n6];
            string.getChars(0, n6, cArray, 0);
        } else {
            if (bl) {
                return;
            }
            cArray = new char[]{' '};
        }
        PointF pointF = new PointF();
        int n7 = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
        int n8 = Gdip.StringFormat_GetFormatFlags(n7) | 0x800;
        if ((this.data.style & 0x8000000) != 0) {
            n8 |= 1;
        }
        Gdip.StringFormat_SetFormatFlags(n7, n8);
        if ((n4 & 4) != 0) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = this.measureSpace(this.data.gdipFont, n7) * 8.0f;
        } else {
            fArray = new float[1];
        }
        float[] fArray3 = fArray;
        Gdip.StringFormat_SetTabStops(n7, 0.0f, fArray3.length, fArray3);
        int n9 = n5 = (n4 & 8) != 0 ? 1 : 0;
        if ((n4 & 8) != 0 && (this.data.uiState & 2) != 0) {
            n5 = 2;
        }
        Gdip.StringFormat_SetHotkeyPrefix(n7, n5);
        RectF rectF = null;
        if (bl2) {
            rectF = new RectF();
            Gdip.Graphics_MeasureString(n, cArray, cArray.length, this.data.gdipFont, pointF, n7, rectF);
        }
        if (bl) {
            if ((n4 & 1) == 0) {
                Gdip.Graphics_FillRectangle(n, this.data.gdipBrush, n2, n3, (int)Math.ceil(rectF.Width), (int)Math.ceil(rectF.Height));
            }
            int n10 = 0;
            int n11 = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n11)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(n11, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(n11, -2 * n2, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(n11, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(n11, -2 * n2, 0.0f, 0);
                    }
                }
                n10 = Gdip.Graphics_Save(n);
                Gdip.Graphics_ScaleTransform(n, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n, -2 * n2, 0.0f, 0);
            }
            pointF.X = n2;
            pointF.Y = n3;
            Gdip.Graphics_DrawString(n, cArray, cArray.length, this.data.gdipFont, pointF, n7, n11);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(n11)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(n11);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(n11);
                    }
                }
                Gdip.Graphics_Restore(n, n10);
            }
        }
        Gdip.StringFormat_delete(n7);
        if (n6 == 0) {
            rectF.Width = 0.0f;
        }
        if (point != null) {
            point.x = (int)Math.ceil(rectF.Width);
            point.y = (int)Math.ceil(rectF.Height);
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.fillArcInPixels(n, n2, n3, n4, n5, n6);
    }

    void fillArcInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.gdipGraphics;
        if (n7 != 0) {
            if (n3 == n4) {
                Gdip.Graphics_FillPie(n7, this.data.gdipBrush, n, n2, n3, n4, -n5, -n6);
            } else {
                int n8 = Gdip.Graphics_Save(n7);
                Gdip.Graphics_TranslateTransform(n7, n, n2, 0);
                Gdip.Graphics_ScaleTransform(n7, n3, n4, 0);
                Gdip.Graphics_FillPie(n7, this.data.gdipBrush, 0, 0, 1, 1, -n5, -n6);
                Gdip.Graphics_Restore(n7, n8);
            }
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n;
        }
        if (OS.IsWinCE) {
            if (n6 < 0) {
                n5 += n6;
                n6 = -n6;
            }
            boolean bl = true;
            if (n6 >= 360) {
                n6 = 360;
                bl = false;
            }
            int[] nArray = new int[(n6 + 1) * 2 + (bl ? 4 : 0)];
            int n9 = 2 * n + n3;
            int n10 = 2 * n2 + n4;
            int n11 = bl ? 2 : 0;
            for (int i = 0; i <= n6; ++i) {
                nArray[n11++] = GC.cos(n5 + i, n3) + n9 >> 1;
                nArray[n11++] = n10 - GC.sin(n5 + i, n4) >> 1;
            }
            if (bl) {
                int n12 = n9 >> 1;
                nArray[nArray.length - 2] = n12;
                nArray[0] = n12;
                int n13 = n10 >> 1;
                nArray[nArray.length - 1] = n13;
                nArray[1] = n13;
            }
            OS.Polygon(this.handle, nArray, nArray.length / 2);
        } else {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n6 >= 360 || n6 <= -360) {
                n16 = n17 = n + n3;
                n14 = n15 = n2 + n4 / 2;
            } else {
                boolean bl = n6 < 0;
                n6 += n5;
                if (bl) {
                    int n18 = n5;
                    n5 = n6;
                    n6 = n18;
                }
                n16 = GC.cos(n5, n3) + n + n3 / 2;
                n14 = -1 * GC.sin(n5, n4) + n2 + n4 / 2;
                n17 = GC.cos(n6, n3) + n + n3 / 2;
                n15 = -1 * GC.sin(n6, n4) + n2 + n4 / 2;
            }
            OS.Pie(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n16, n14, n17, n15);
        }
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.fillGradientRectangleInPixels(n, n2, n3, n4, bl);
    }

    void fillGradientRectangleInPixels(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        RGB rGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangleInPixels(n, n2, n3, n4);
            return;
        }
        if (this.data.gdipGraphics != 0) {
            int n7;
            this.initGdip();
            PointF pointF = new PointF();
            PointF pointF2 = new PointF();
            pointF.X = n;
            pointF.Y = n2;
            if (bl) {
                pointF2.X = pointF.X;
                pointF2.Y = pointF.Y + (float)n4;
            } else {
                pointF2.X = pointF.X + (float)n3;
                pointF2.Y = pointF.Y;
            }
            int n8 = (rGB3.red & 0xFF) << 16 | (rGB3.green & 0xFF) << 8 | rGB3.blue & 0xFF;
            int n9 = Gdip.Color_new(this.data.alpha << 24 | n8);
            if (n9 == 0) {
                SWT.error(2);
            }
            if ((n7 = Gdip.Color_new(this.data.alpha << 24 | (n8 = (rGB4.red & 0xFF) << 16 | (rGB4.green & 0xFF) << 8 | rGB4.blue & 0xFF))) == 0) {
                SWT.error(2);
            }
            int n10 = Gdip.LinearGradientBrush_new(pointF, pointF2, n9, n7);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, n10, n, n2, n3, n4);
            Gdip.LinearGradientBrush_delete(n10);
            Gdip.Color_delete(n9);
            Gdip.Color_delete(n7);
            return;
        }
        int n11 = 0;
        if (OS.IsWinCE) {
            n11 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n11);
        } else {
            n11 = OS.GetROP2(this.handle);
        }
        if (OS.IsWinNT && n11 != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            n6 = OS.GetProcessHeap();
            n5 = OS.HeapAlloc(n6, 8, GRADIENT_RECT.sizeof + TRIVERTEX.sizeof * 2);
            if (n5 == 0) {
                SWT.error(2);
            }
            int n12 = n5 + GRADIENT_RECT.sizeof;
            GRADIENT_RECT gRADIENT_RECT = new GRADIENT_RECT();
            gRADIENT_RECT.UpperLeft = 0;
            gRADIENT_RECT.LowerRight = 1;
            OS.MoveMemory(n5, gRADIENT_RECT, GRADIENT_RECT.sizeof);
            TRIVERTEX tRIVERTEX = new TRIVERTEX();
            tRIVERTEX.x = n;
            tRIVERTEX.y = n2;
            tRIVERTEX.Red = (short)(rGB3.red << 8 | rGB3.red);
            tRIVERTEX.Green = (short)(rGB3.green << 8 | rGB3.green);
            tRIVERTEX.Blue = (short)(rGB3.blue << 8 | rGB3.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n12, tRIVERTEX, TRIVERTEX.sizeof);
            tRIVERTEX.x = n + n3;
            tRIVERTEX.y = n2 + n4;
            tRIVERTEX.Red = (short)(rGB4.red << 8 | rGB4.red);
            tRIVERTEX.Green = (short)(rGB4.green << 8 | rGB4.green);
            tRIVERTEX.Blue = (short)(rGB4.blue << 8 | rGB4.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n12 + TRIVERTEX.sizeof, tRIVERTEX, TRIVERTEX.sizeof);
            boolean bl3 = OS.GradientFill(this.handle, n12, 2, n5, 1, bl ? 1 : 0);
            OS.HeapFree(n6, 0, n5);
            if (bl3) {
                return;
            }
        }
        n5 = (n6 = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (n6 >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB3, rGB4, n5, n5, n5);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.fillOvalInPixels(n, n2, n3, n4);
    }

    void fillOvalInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_FillEllipse(this.data.gdipGraphics, this.data.gdipBrush, n, n2, n3, n4);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n;
        }
        OS.Ellipse(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(9218);
        int n = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(path.handle, n);
        Gdip.Graphics_FillPath(this.data.gdipGraphics, this.data.gdipBrush, path.handle);
    }

    public void fillPolygon(int[] nArray) {
        if (nArray == null) {
            SWT.error(4);
        }
        this.fillPolygonInPixels(DPIUtil.autoScaleUp(nArray));
    }

    void fillPolygonInPixels(int[] nArray) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            int n2 = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.Graphics_FillPolygon(this.data.gdipGraphics, this.data.gdipBrush, nArray, nArray.length / 2, n2);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            for (n = 0; n < nArray.length; n += 2) {
                int n3 = n;
                nArray[n3] = nArray[n3] - 1;
            }
        }
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        if ((this.data.style & 0x8000000) != 0) {
            for (n = 0; n < nArray.length; n += 2) {
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
            }
        }
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.fillRectangleInPixels(n, n2, n3, n4);
    }

    void fillRectangleInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            if (n3 < 0) {
                n += n3;
                n3 = -n3;
            }
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, n, n2, n3, n4);
            return;
        }
        int n5 = 0;
        if (OS.IsWinCE) {
            n5 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n5);
        } else {
            n5 = OS.GetROP2(this.handle);
        }
        int n6 = n5 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, n, n2, n3, n4, n6);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        this.fillRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        this.fillRoundRectangleInPixels(n, n2, n3, n4, n5, n6);
    }

    void fillRoundRectangleInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0) {
            this.fillRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipBrush, n, n2, n3, n4, n5, n6);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --n;
        }
        OS.RoundRect(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n5, n6);
    }

    void fillRoundRectangleGdip(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        int n14 = n8;
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
            n10 -= n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if (n14 < 0) {
            n14 = 0 - n14;
        }
        if (n13 == 0 || n14 == 0) {
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, n3, n4, n5, n6);
        } else {
            int n15 = Gdip.GraphicsPath_new(0);
            if (n15 == 0) {
                SWT.error(2);
            }
            if (n11 > n13) {
                if (n12 > n14) {
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10, n13, n14, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10, n13, n14, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10 + n12 - n14, n13, n14, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10 + n12 - n14, n13, n14, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(n15, n9 + n11 - n13, n10, n13, n12, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(n15, n9, n10, n13, n12, -90.0f, -180.0f);
                }
            } else if (n12 > n14) {
                Gdip.GraphicsPath_AddArc(n15, n9, n10, n11, n14, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(n15, n9, n10 + n12 - n14, n11, n14, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(n15, n9, n10, n11, n12, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(n15);
            Gdip.Graphics_FillPath(n, n2, n15);
            Gdip.GraphicsPath_delete(n15);
        }
    }

    void flush() {
        if (this.data.gdipGraphics != 0) {
            Gdip.Graphics_Flush(this.data.gdipGraphics, 0);
            int n = Gdip.Graphics_GetHDC(this.data.gdipGraphics);
            Gdip.Graphics_ReleaseHDC(this.data.gdipGraphics, n);
        }
    }

    public int getAdvanceWidth(char n) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        if (OS.IsWinCE) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{n}, 1, sIZE);
            return sIZE.cx;
        }
        int n2 = n;
        if (n > 127) {
            object = new TCHAR(this.getCodePage(), (char)n, false);
            n2 = ((TCHAR)object).tcharAt(0);
        }
        object = new int[1];
        OS.GetCharWidth(this.handle, n2, n2, (int[])object);
        return (int)object[0];
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.gdipGraphics != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n = Gdip.Graphics_GetSmoothingMode(this.data.gdipGraphics);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char n) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        if (!OS.IsWinCE) {
            int n2 = n;
            if (n > 127) {
                object = new TCHAR(this.getCodePage(), (char)n, false);
                n2 = object.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, n2, n2, object = new int[3])) {
                return object[1];
            }
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        object = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{n}, 1, (SIZE)object);
        return object.cx - tEXTMETRIC.tmOverhang;
    }

    public Rectangle getClipping() {
        return DPIUtil.autoScaleDown(this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = this.data.gdipGraphics) != 0) {
            Rect rect = new Rect();
            Gdip.Graphics_SetPixelOffsetMode(n, 3);
            Gdip.Graphics_GetVisibleClipBounds(n, rect);
            Gdip.Graphics_SetPixelOffsetMode(n, 4);
            return new Rectangle(rect.X, rect.Y, rect.Width, rect.Height);
        }
        RECT rECT = new RECT();
        OS.GetClipBox(this.handle, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public void getClipping(Region region) {
        int n;
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = this.data.gdipGraphics) != 0) {
            int n3 = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, n3);
            if (Gdip.Region_IsInfinite(n3, n2)) {
                Rect rect = new Rect();
                Gdip.Graphics_SetPixelOffsetMode(n2, 3);
                Gdip.Graphics_GetVisibleClipBounds(n2, rect);
                Gdip.Graphics_SetPixelOffsetMode(n2, 4);
                OS.SetRectRgn(region.handle, rect.X, rect.Y, rect.X + rect.Width, rect.Y + rect.Height);
            } else {
                int n4 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                int n5 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                Gdip.Graphics_GetTransform(n2, n4);
                Gdip.Graphics_SetTransform(n2, n5);
                int n6 = Gdip.Region_GetHRGN(n3, this.data.gdipGraphics);
                Gdip.Graphics_SetTransform(n2, n4);
                Gdip.Matrix_delete(n5);
                Gdip.Matrix_delete(n4);
                if (!OS.IsWinCE) {
                    POINT pOINT = new POINT();
                    OS.GetWindowOrgEx(this.handle, pOINT);
                    OS.OffsetRgn(n6, pOINT.x, pOINT.y);
                }
                OS.CombineRgn(region.handle, n6, 0, 5);
                OS.DeleteObject(n6);
            }
            Gdip.Region_delete(n3);
            return;
        }
        POINT pOINT = new POINT();
        if (!OS.IsWinCE) {
            OS.GetWindowOrgEx(this.handle, pOINT);
        }
        if ((n = OS.GetClipRgn(this.handle, region.handle)) != 1) {
            RECT rECT = new RECT();
            OS.GetClipBox(this.handle, rECT);
            OS.SetRectRgn(region.handle, rECT.left, rECT.top, rECT.right, rECT.bottom);
        } else {
            OS.OffsetRgn(region.handle, pOINT.x, pOINT.y);
        }
        if (!OS.IsWinCE) {
            int n7 = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetMetaRgn(this.handle, n7) != 0) {
                OS.OffsetRgn(n7, pOINT.x, pOINT.y);
                OS.CombineRgn(region.handle, n7, region.handle, 1);
            }
            OS.DeleteObject(n7);
            int n8 = this.data.hwnd;
            if (n8 != 0 && this.data.ps != null) {
                int n9 = OS.CreateRectRgn(0, 0, 0, 0);
                if (OS.GetRandomRgn(this.handle, n9, 4) == 1) {
                    if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (OS.GetLayout(this.handle) & 1) != 0) {
                        int n10 = OS.GetRegionData(n9, 0, null);
                        int[] nArray = new int[n10 / 4];
                        OS.GetRegionData(n9, n10, nArray);
                        int n11 = OS.ExtCreateRegion(new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, n10, nArray);
                        OS.DeleteObject(n9);
                        n9 = n11;
                    }
                    if (OS.IsWinNT) {
                        OS.MapWindowPoints(0, n8, pOINT, 1);
                        OS.OffsetRgn(n9, pOINT.x, pOINT.y);
                    }
                    OS.CombineRgn(region.handle, n9, region.handle, 1);
                }
                OS.DeleteObject(n9);
            }
        }
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int[] nArray = new int[8];
        int n = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(n, nArray, 1);
        return nArray[1];
    }

    int getFgBrush() {
        return this.data.foregroundPattern != null ? this.data.foregroundPattern.handle : this.data.gdipFgBrush;
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return 1;
        }
        return OS.GetPolyFillMode(this.handle) == 2 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n = Gdip.Graphics_GetInterpolationMode(this.data.gdipGraphics);
        switch (n) {
            case 0: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        LineAttributes lineAttributes = this.getLineAttributesInPixels();
        lineAttributes.width = DPIUtil.autoScaleDown(lineAttributes.width);
        return lineAttributes;
    }

    LineAttributes getLineAttributesInPixels() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)this.data.lineDashes[i];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        return DPIUtil.autoScaleDown(this.getLineWidthInPixels());
    }

    int getLineWidthInPixels() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0) {
            return -1;
        }
        int n = Gdip.Graphics_GetTextRenderingHint(this.data.gdipGraphics);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.data.gdipGraphics) != 0) {
            Gdip.Graphics_GetTransform(n, transform.handle);
            int n2 = this.identity();
            Gdip.Matrix_Invert(n2);
            Gdip.Matrix_Multiply(transform.handle, n2, 1);
            Gdip.Matrix_delete(n2);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = 0;
        if (OS.IsWinCE) {
            n = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n);
        } else {
            n = OS.GetROP2(this.handle);
        }
        return n == 7;
    }

    void initGdip() {
        this.data.device.checkGDIP();
        int n = this.data.gdipGraphics;
        if (n != 0) {
            return;
        }
        int n2 = OS.CreateRectRgn(0, 0, 0, 0);
        int n3 = OS.GetClipRgn(this.handle, n2);
        if (!OS.IsWinCE) {
            POINT pOINT = new POINT();
            OS.GetWindowOrgEx(this.handle, pOINT);
            OS.OffsetRgn(n2, pOINT.x, pOINT.y);
        }
        OS.SelectClipRgn(this.handle, 0);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) & 0xFFFFFFFE);
        }
        if ((n = (this.data.gdipGraphics = Gdip.Graphics_new(this.handle))) == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_SetPageUnit(n, 2);
        Gdip.Graphics_SetPixelOffsetMode(n, 4);
        if ((this.data.style & 0x8000000) != 0) {
            int n4 = this.identity();
            Gdip.Graphics_SetTransform(n, n4);
            Gdip.Matrix_delete(n4);
        }
        if (n3 == 1) {
            this.setClipping(n2);
        }
        OS.DeleteObject(n2);
        this.data.state = 0;
        if (this.data.hPen != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
    }

    int identity() {
        if ((this.data.style & 0x8000000) != 0) {
            Object object;
            int n = 0;
            int n2 = OS.GetDeviceCaps(this.handle, 2);
            if (n2 == 2) {
                n = OS.GetDeviceCaps(this.handle, 110);
            } else {
                object = this.data.image;
                if (object != null) {
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(((Image)object).handle, BITMAP.sizeof, bITMAP);
                    n = bITMAP.bmWidth;
                } else {
                    int n3;
                    int n4 = n3 = OS.IsWinCE ? this.data.hwnd : OS.WindowFromDC(this.handle);
                    if (n3 != 0) {
                        RECT rECT = new RECT();
                        OS.GetClientRect(n3, rECT);
                        n = rECT.right - rECT.left;
                    } else {
                        int n5 = OS.GetCurrentObject(this.handle, 7);
                        BITMAP bITMAP = new BITMAP();
                        OS.GetObject(n5, BITMAP.sizeof, bITMAP);
                        n = bITMAP.bmWidth;
                    }
                }
            }
            object = new POINT();
            if (!OS.IsWinCE) {
                OS.GetWindowOrgEx(this.handle, (POINT)object);
            }
            return Gdip.Matrix_new(-1.0f, 0.0f, 0.0f, 1.0f, n + 2 * ((POINT)object).x, 0.0f);
        }
        return Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    void init(Drawable drawable, GCData gCData, int n) {
        int n2;
        Image image;
        int n3 = gCData.foreground;
        if (n3 != -1) {
            gCData.state &= 0xFFFFF6FE;
        } else {
            gCData.foreground = OS.GetTextColor(n);
        }
        int n4 = gCData.background;
        if (n4 != -1) {
            gCData.state &= 0xFFFFF9FD;
        } else {
            gCData.background = OS.GetBkColor(n);
        }
        gCData.state &= 0xFFFFCFFF;
        Font font = gCData.font;
        if (font != null) {
            gCData.state &= 0xFFFFFFFB;
        } else {
            gCData.font = Font.win32_new(this.device, OS.GetCurrentObject(n, 6));
        }
        int n5 = gCData.device.hPalette;
        if (n5 != 0) {
            OS.SelectPalette(n, n5, true);
            OS.RealizePalette(n);
        }
        if ((image = gCData.image) != null) {
            gCData.hNullBitmap = OS.SelectObject(n, image.handle);
            image.memGC = this;
        }
        if ((n2 = gCData.layout) != -1 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            int n6 = OS.GetLayout(n);
            if ((n6 & 1) != (n2 & 1)) {
                OS.SetLayout(n, (n6 &= 0xFFFFFFFE) | n2);
            }
            if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = this.data.gdipGraphics) != 0) {
            int n2 = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, n2);
            boolean bl = Gdip.Region_IsInfinite(n2, n);
            Gdip.Region_delete(n2);
            return !bl;
        }
        int n3 = OS.CreateRectRgn(0, 0, 0, 0);
        int n4 = OS.GetClipRgn(this.handle, n3);
        OS.DeleteObject(n3);
        return n4 > 0;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    float measureSpace(int n, int n2) {
        PointF pointF = new PointF();
        RectF rectF = new RectF();
        Gdip.Graphics_MeasureString(this.data.gdipGraphics, new char[]{' '}, 1, n, pointF, n2, rectF);
        return rectF.Width;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (bl && this.data.gdipGraphics != 0) {
            return;
        }
        if (bl) {
            try {
                this.initGdip();
            }
            catch (SWTException sWTException) {}
        } else {
            this.disposeGdip();
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
            if ((this.data.style & 0x8000000) != 0) {
                OS.SetLayout(this.handle, OS.GetLayout(this.handle) | 1);
            }
        }
    }

    public void setAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetSmoothingMode(this.data.gdipGraphics, n2);
    }

    public void setAlpha(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && (n & 0xFF) == 255) {
            return;
        }
        this.initGdip();
        this.data.alpha = n & 0xFF;
        this.data.state &= 0xFFFFFFFC;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == null && this.data.background == color.handle) {
            return;
        }
        this.data.backgroundPattern = null;
        this.data.background = color.handle;
        this.data.state &= 0xFFFFFDFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    void setClipping(int n) {
        int n2 = n;
        int n3 = this.data.gdipGraphics;
        if (n3 != 0) {
            if (n2 != 0) {
                int n4 = Gdip.Region_new(n2);
                Gdip.Graphics_SetClip(n3, n4, 0);
                Gdip.Region_delete(n4);
            } else {
                Gdip.Graphics_ResetClip(n3);
            }
        } else {
            POINT pOINT = null;
            if (n2 != 0 && !OS.IsWinCE) {
                pOINT = new POINT();
                OS.GetWindowOrgEx(this.handle, pOINT);
                OS.OffsetRgn(n2, -pOINT.x, -pOINT.y);
            }
            OS.SelectClipRgn(this.handle, n2);
            if (n2 != 0 && !OS.IsWinCE) {
                OS.OffsetRgn(n2, pOINT.x, pOINT.y);
            }
        }
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        this.setClippingInPixels(n, n2, n3, n4);
    }

    void setClippingInPixels(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = OS.CreateRectRgn(n, n2, n + n3, n2 + n4);
        this.setClipping(n5);
        OS.DeleteObject(n5);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            this.initGdip();
            int n = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            Gdip.GraphicsPath_SetFillMode(path.handle, n);
            Gdip.Graphics_SetClipPath(this.data.gdipGraphics, path.handle);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping(0);
        } else {
            rectangle = DPIUtil.autoScaleUp(rectangle);
            this.setClippingInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFillRule(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            return;
        }
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetPolyFillMode(this.handle, n2);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == null && color.handle == this.data.foreground) {
            return;
        }
        this.data.foregroundPattern = null;
        this.data.foreground = color.handle;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 5;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetInterpolationMode(this.data.gdipGraphics, n2);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        if (lineAttributes == null) {
            SWT.error(4);
        }
        lineAttributes.width = DPIUtil.autoScaleUp(lineAttributes.width);
        this.setLineAttributesInPixels(lineAttributes);
    }

    void setLineAttributesInPixels(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x4010;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x40;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x20;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl || fArray2[i] == f3) continue;
                bl = true;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        this.initGdip();
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n;
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (bl || fArray[n] == (float)n2) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.data.lineDashes[n] = nArray[n];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFBF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        n = DPIUtil.autoScaleUp(n);
        this.setLineWidthInPixels(n);
    }

    void setLineWidthInPixels(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFBFEF;
    }

    @Deprecated
    public void setXORMode(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetROP2(this.handle, bl ? 7 : 13);
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                int[] nArray = new int[1];
                OS.SystemParametersInfo(8202, 0, nArray, 0);
                if (nArray[0] == 2) {
                    n2 = 5;
                    break;
                }
                n2 = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetTextRenderingHint(this.data.gdipGraphics, n2);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0 && transform == null) {
            return;
        }
        this.initGdip();
        int n = this.identity();
        if (transform != null) {
            Gdip.Matrix_Multiply(n, transform.handle, 0);
        }
        Gdip.Graphics_SetTransform(this.data.gdipGraphics, n);
        Gdip.Matrix_delete(n);
        this.data.state &= 0xFFFFBFFF;
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return DPIUtil.autoScaleDown(this.stringExtentInPixels(string));
    }

    Point stringExtentInPixels(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int n = string.length();
        int n2 = this.data.gdipGraphics;
        if (n2 != 0) {
            Point point = new Point(0, 0);
            this.drawText(n2, string, 0, 0, 0, point);
            return point;
        }
        SIZE sIZE = new SIZE();
        if (n == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        OS.GetTextExtentPoint32W(this.handle, cArray, n, sIZE);
        return new Point(sIZE.cx, sIZE.cy);
    }

    public Point textExtent(String string) {
        return DPIUtil.autoScaleDown(this.textExtentInPixels(string, 6));
    }

    public Point textExtent(String string, int n) {
        return DPIUtil.autoScaleDown(this.textExtentInPixels(string, n));
    }

    Point textExtentInPixels(String string, int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        int n2 = this.data.gdipGraphics;
        if (n2 != 0) {
            Point point = new Point(0, 0);
            this.drawText(n2, string, 0, 0, n, point);
            return point;
        }
        if (string.length() == 0) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n3 = 1024;
        if ((n & 2) == 0) {
            n3 |= 0x20;
        }
        if ((n & 4) != 0) {
            n3 |= 0x40;
        }
        if ((n & 8) == 0) {
            n3 |= 0x800;
        }
        OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n3);
        return new Point(rECT.right, rECT.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, n);
        return gC;
    }

    public static GC win32_new(int n, GCData gCData) {
        int n2;
        GC gC = new GC();
        gC.device = gCData.device;
        gCData.style |= 0x2000000;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && ((n2 = OS.GetLayout(n)) & 1) != 0) {
            gCData.style |= 0xC000000;
        }
        gC.init(null, gCData, n);
        return gC;
    }

    private static int cos(int n, int n2) {
        return (int)(Math.cos((double)n * (Math.PI / 180)) * (double)n2);
    }

    private static int sin(int n, int n2) {
        return (int)(Math.sin((double)n * (Math.PI / 180)) * (double)n2);
    }
}

