/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.GdiplusStartupInput;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    public int hPalette = 0;
    int[] colorRefCount;
    Font systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    int[] scripts;
    int[] gdipToken;
    int fontCollection;
    String[] loadedFonts;
    boolean disposed;
    boolean enableAutoScaling = true;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void addFont(String string) {
        int n;
        if (this.loadedFonts == null) {
            this.loadedFonts = new String[4];
        }
        int n2 = this.loadedFonts.length;
        for (n = 0; n < n2; ++n) {
            if (!string.equals(this.loadedFonts[n])) continue;
            return;
        }
        for (n = 0; n < n2 && this.loadedFonts[n] != null; ++n) {
        }
        if (n == n2) {
            String[] stringArray = new String[n2 + 4];
            System.arraycopy(this.loadedFonts, 0, stringArray, 0, n2);
            this.loadedFonts = stringArray;
        }
        this.loadedFonts[n] = string;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkGDIP() {
        if (this.gdipToken != null) {
            return;
        }
        int n = 0;
        if (!OS.IsWinCE) {
            n = OS.SetErrorMode(1);
        }
        try {
            int[] nArray = new int[1];
            GdiplusStartupInput gdiplusStartupInput = new GdiplusStartupInput();
            gdiplusStartupInput.GdiplusVersion = 1;
            if (Gdip.GdiplusStartup(nArray, gdiplusStartupInput, 0) == 0) {
                this.gdipToken = nArray;
                if (this.loadedFonts != null) {
                    String string;
                    this.fontCollection = Gdip.PrivateFontCollection_new();
                    if (this.fontCollection == 0) {
                        SWT.error(2);
                    }
                    for (int i = 0; i < this.loadedFonts.length && (string = this.loadedFonts[i]) != null; ++i) {
                        int n2 = string.length();
                        char[] cArray = new char[n2 + 1];
                        string.getChars(0, n2, cArray, 0);
                        Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                    }
                    this.loadedFonts = null;
                }
            }
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [GDI+ is required]");
        }
        finally {
            if (!OS.IsWinCE) {
                OS.SetErrorMode(n);
            }
        }
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(float f) {
        int n = this.internal_new_GC(null);
        int n2 = -((int)(0.5f + f * (float)OS.GetDeviceCaps(n, 90) / 72.0f));
        this.internal_dispose_GC(n, null);
        return n2;
    }

    float computePoints(LOGFONT lOGFONT, int n) {
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 90);
        int n4 = 0;
        if (lOGFONT.lfHeight > 0) {
            int n5 = OS.SelectObject(n2, n);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n2, tEXTMETRIC);
            OS.SelectObject(n2, n5);
            n4 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n4 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(n2, null);
        return (float)n4 * 72.0f / (float)n3;
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    int EnumFontFamProc(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = bl = n4 == 1;
        if (bl2 == bl) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
                int[] nArray = new int[((LOGFONT[])object).length];
                System.arraycopy(this.pixels, 0, nArray, 0, this.nFonts);
                this.pixels = nArray;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, n, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = object;
            if (object.lfHeight > 0) {
                OS.MoveMemory(this.metrics, n2, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = object.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -object.lfHeight;
            }
            ++this.nFonts;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 8);
        int n3 = OS.GetDeviceCaps(n, 10);
        this.internal_dispose_GC(n, null);
        return new Rectangle(0, 0, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = this.objects.length;
                for (n = 0; n < n3; ++n) {
                    if (this.objects[n] == null) continue;
                    ++n2;
                }
                n = 0;
                deviceData.objects = new Object[n2];
                deviceData.errors = new Error[n2];
                for (int i = 0; i < n3; ++i) {
                    if (this.objects[i] == null) continue;
                    deviceData.objects[n] = this.objects[i];
                    deviceData.errors[n] = this.errors[i];
                    ++n;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 12);
        int n3 = OS.GetDeviceCaps(n, 14);
        this.internal_dispose_GC(n, null);
        return n2 * n3;
    }

    public Point getDPI() {
        this.checkDevice();
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 88);
        int n3 = OS.GetDeviceCaps(n, 90);
        this.internal_dispose_GC(n, null);
        return DPIUtil.autoScaleDown(new Point(n2, n3));
    }

    int _getDPIx() {
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 88);
        this.internal_dispose_GC(n, null);
        return n2;
    }

    public FontData[] getFontList(String string, boolean bl) {
        int n;
        int n2;
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int n3 = callback.getAddress();
        if (n3 == 0) {
            SWT.error(3);
        }
        this.metrics = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        for (n2 = 0; n2 < this.logFonts.length; ++n2) {
            this.logFonts[n2] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        }
        this.nFonts = 0;
        n2 = 0;
        int n4 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(n4, null, n3, bl ? 1 : 0);
            n2 = this.nFonts;
            for (n = 0; n < n2; ++n) {
                LOGFONT lOGFONT = this.logFonts[n];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(n4, ((LOGFONTW)lOGFONT).lfFaceName, n3, bl ? 1 : 0);
                    continue;
                }
                OS.EnumFontFamiliesA(n4, ((LOGFONTA)lOGFONT).lfFaceName, n3, bl ? 1 : 0);
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(n4, tCHAR, n3, bl ? 1 : 0);
        }
        n = OS.GetDeviceCaps(n4, 90);
        this.internal_dispose_GC(n4, null);
        int n5 = 0;
        FontData[] fontDataArray = new FontData[this.nFonts - n2];
        for (int i = n2; i < this.nFonts; ++i) {
            int n6;
            FontData fontData = FontData.win32_new(this.logFonts[i], (float)this.pixels[i] * 72.0f / (float)n);
            for (n6 = 0; n6 < n5 && !fontData.equals(fontDataArray[n6]); ++n6) {
            }
            if (n6 != n5) continue;
            fontDataArray[n5++] = fontData;
        }
        if (n5 != fontDataArray.length) {
            FontData[] fontDataArray2 = new FontData[n5];
            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n5);
            fontDataArray = fontDataArray2;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return fontDataArray;
    }

    String getLastError() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n) + "]";
    }

    String getLastErrorText() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        int n2 = 4864;
        int[] nArray = new int[1];
        int n3 = OS.FormatMessage(n2, 0, n, 1024, nArray, 0, 0);
        if (n3 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n3);
        OS.MoveMemory(tCHAR, nArray[0], n3 * TCHAR.sizeof);
        if (nArray[0] != 0) {
            OS.LocalFree(nArray[0]);
        }
        return tCHAR.toString(0, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0;
        int n3 = 255;
        switch (n) {
            case 37: {
                n3 = 0;
            }
            case 1: {
                n2 = 0xFFFFFF;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 255;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 65280;
                break;
            }
            case 6: {
                n2 = 32768;
                break;
            }
            case 7: {
                n2 = 65535;
                break;
            }
            case 8: {
                n2 = 32896;
                break;
            }
            case 9: {
                n2 = 0xFF0000;
                break;
            }
            case 10: {
                n2 = 0x800000;
                break;
            }
            case 11: {
                n2 = 0xFF00FF;
                break;
            }
            case 12: {
                n2 = 0x800080;
                break;
            }
            case 13: {
                n2 = 0xFFFF00;
                break;
            }
            case 14: {
                n2 = 0x808000;
                break;
            }
            case 15: {
                n2 = 0xC0C0C0;
                break;
            }
            case 16: {
                n2 = 0x808080;
            }
        }
        return Color.win32_new(this, n2, n3);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n = OS.GetStockObject(13);
        return Font.win32_new(this, n);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        this.systemFont = this.getSystemFont();
        if (!OS.IsWinCE) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ScriptGetProperties(nArray, nArray2);
            this.scripts = new int[nArray2[0]];
            OS.MoveMemory(this.scripts, nArray[0], this.scripts.length * OS.PTR_SIZEOF);
        }
        int n = this.internal_new_GC(null);
        int n2 = OS.GetDeviceCaps(n, 38);
        int n3 = OS.GetDeviceCaps(n, 12);
        int n4 = OS.GetDeviceCaps(n, 14);
        if ((n2 & 0x100) == 0 || (n3 *= n4) != 8) {
            this.internal_dispose_GC(n, null);
            return;
        }
        int n5 = OS.GetDeviceCaps(n, 106);
        int n6 = OS.GetDeviceCaps(n, 104);
        if (OS.IsWinCE && n5 == 0 && n6 >= 20) {
            n5 = 20;
        }
        this.colorRefCount = new int[n6];
        byte[] byArray = new byte[4 + 4 * n6];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n6];
        OS.GetSystemPaletteEntries(n, 0, n6, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n6);
        for (int i = 0; i < n5 / 2; ++i) {
            this.colorRefCount[i] = 1;
            this.colorRefCount[n6 - 1 - i] = 1;
        }
        this.internal_dispose_GC(n, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    @Override
    public abstract int internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl;
            TCHAR tCHAR = new TCHAR(0, string, true);
            boolean bl2 = bl = OS.AddFontResourceEx(tCHAR, 16, 0) != 0;
            if (bl) {
                if (this.gdipToken != null) {
                    if (this.fontCollection == 0) {
                        this.fontCollection = Gdip.PrivateFontCollection_new();
                        if (this.fontCollection == 0) {
                            SWT.error(2);
                        }
                    }
                    int n = string.length();
                    char[] cArray = new char[n + 1];
                    string.getChars(0, n, cArray, 0);
                    Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                } else {
                    this.addFont(string);
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (int i = 0; i < this.objects.length; ++i) {
                    Object object2 = this.objects[i];
                    if (object2 == null) continue;
                    ++n;
                    if (object2 instanceof Color) {
                        ++n2;
                    }
                    if (object2 instanceof Cursor) {
                        ++n3;
                    }
                    if (object2 instanceof Font) {
                        ++n4;
                    }
                    if (object2 instanceof GC) {
                        ++n5;
                    }
                    if (object2 instanceof Image) {
                        ++n6;
                    }
                    if (object2 instanceof Path) {
                        ++n7;
                    }
                    if (object2 instanceof Pattern) {
                        ++n8;
                    }
                    if (object2 instanceof Region) {
                        ++n9;
                    }
                    if (object2 instanceof TextLayout) {
                        ++n10;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++n11;
                }
                if (n != 0) {
                    String string = "Summary: ";
                    if (n2 != 0) {
                        string = string + n2 + " Color(s), ";
                    }
                    if (n3 != 0) {
                        string = string + n3 + " Cursor(s), ";
                    }
                    if (n4 != 0) {
                        string = string + n4 + " Font(s), ";
                    }
                    if (n5 != 0) {
                        string = string + n5 + " GC(s), ";
                    }
                    if (n6 != 0) {
                        string = string + n6 + " Image(s), ";
                    }
                    if (n7 != 0) {
                        string = string + n7 + " Path(s), ";
                    }
                    if (n8 != 0) {
                        string = string + n8 + " Pattern(s), ";
                    }
                    if (n9 != 0) {
                        string = string + n9 + " Region(s), ";
                    }
                    if (n10 != 0) {
                        string = string + n10 + " TextLayout(s), ";
                    }
                    if (n11 != 0) {
                        string = string + n11 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.err.println(string);
                    }
                    for (int i = 0; i < this.errors.length; ++i) {
                        if (this.errors[i] == null) continue;
                        this.errors[i].printStackTrace(System.err);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.gdipToken != null) {
            if (this.fontCollection != 0) {
                Gdip.PrivateFontCollection_delete(this.fontCollection);
            }
            this.fontCollection = 0;
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }

    boolean getEnableAutoScaling() {
        return this.enableAutoScaling;
    }

    void setEnableAutoScaling(boolean bl) {
        this.enableAutoScaling = bl;
    }

    protected int getDeviceZoom() {
        return DPIUtil.mapDPIToZoom(this._getDPIx());
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

