/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xml2;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.infodb.commons.utils.Captialize;
import org.infodb.commons.xml2.RecordResolver;
import org.infodb.commons.xml2.TypeResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RecordHandler
extends DefaultHandler {
    private RecordResolver<?> resolver;
    private TypeResolver typeResolver;
    private Object current;
    private String uri;
    private String localName;
    private String triggeredUri;
    private String triggeredName;

    public RecordHandler(RecordResolver<?> resolver) {
        this.resolver = resolver;
        this.typeResolver = resolver.getTypeResolver();
        this.current = null;
        this.uri = null;
        this.localName = null;
        this.triggeredUri = null;
        this.triggeredName = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.current != null && this.uri != null && this.localName != null) {
            String propertyName = Captialize.convert(this.localName);
            try {
                PropertyDescriptor pd = new PropertyDescriptor(propertyName, this.current.getClass());
                Method method = pd.getWriteMethod();
                String value = new String(ch, start, length);
                Class<?> type = pd.getPropertyType();
                if (type.equals(String.class)) {
                    method.invoke(this.current, value);
                } else if (type.equals(Integer.TYPE)) {
                    method.invoke(this.current, Integer.parseInt(value));
                } else if (type.equals(Date.class)) {
                    method.invoke(this.current, this.typeResolver.parseDate(this.uri, this.localName, value));
                } else {
                    method.invoke(this.current, this.typeResolver.parseObject(this.uri, this.localName, value));
                }
            }
            catch (IntrospectionException ex) {
            }
            catch (IllegalAccessException ex) {
                throw new SAXException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.triggeredUri != null && this.triggeredName != null && uri.equals(this.triggeredUri) && localName.equals(this.triggeredName)) {
            this.resolver.endRecord();
            this.current = null;
        }
        this.uri = null;
        this.localName = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (this.current != null) {
            this.uri = uri;
            this.localName = localName;
        } else {
            this.current = this.resolver.startRecord(uri, localName);
            this.uri = null;
            this.localName = null;
            if (this.current != null) {
                this.triggeredUri = uri;
                this.triggeredName = localName;
            }
        }
    }
}

