/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.convert;

import org.infodb.commons.convert.CTable;
import org.infodb.commons.convert.ConvDict;
import org.infodb.commons.convert.Word;

public class ZK2R {
    private static String convertWord(String s, Cursor c, Word[] words) {
        for (Word w : words) {
            if (!w.isMatch(s, c.index)) continue;
            c.index += w.getKana().length();
            return w.getLatin();
        }
        return null;
    }

    private static String convertByRegexp(String s, String regexp, String repl) {
        return s.replaceAll(regexp, repl);
    }

    private static String convertRoman(String s) {
        String val = ZK2R.convertByRegexp(s, "tt([a-z])", "$1$1");
        val = ZK2R.convertByRegexp(val, "tt", "");
        val = ZK2R.convertByRegexp(val, "x", "");
        val = ZK2R.convertByRegexp(val, "a{2,}", "a-");
        val = ZK2R.convertByRegexp(val, "i{2,}", "i-");
        val = ZK2R.convertByRegexp(val, "u{2,}", "u-");
        val = ZK2R.convertByRegexp(val, "e{2,}", "e-");
        val = ZK2R.convertByRegexp(val, "o{2,}", "o-");
        val = ZK2R.convertByRegexp(val, "ou", "o-");
        val = ZK2R.convertByRegexp(val, "n([pbm])", "m$1");
        val = ZK2R.convertByRegexp(val, "^(.*)-$", "$1");
        return val;
    }

    public static String convertLatin(String s) {
        Cursor c = new Cursor();
        StringBuilder sb = new StringBuilder("");
        while (c.index < s.length()) {
            String val = ZK2R.convertWord(s, c, CTable.romans);
            if (val != null) {
                sb.append(val);
                continue;
            }
            if (s.charAt(c.index) >= '\uff10' && s.charAt(c.index) <= '\uff19') {
                sb.append((char)(s.charAt(c.index) - 65296 + 48));
                ++c.index;
                continue;
            }
            sb.append(s.charAt(c.index));
            ++c.index;
        }
        return ZK2R.convertRoman(sb.toString());
    }

    private static String convertLatinForAddr(String s) {
        Cursor c = new Cursor();
        StringBuilder sb = new StringBuilder("");
        while (c.index < s.length()) {
            String val = ZK2R.convertWord(s, c, ConvDict.words);
            if (val != null) {
                sb.append(val);
                continue;
            }
            val = ZK2R.convertWord(s, c, CTable.romans);
            if (val != null) {
                sb.append(val);
                continue;
            }
            if (s.charAt(c.index) >= '\uff10' && s.charAt(c.index) <= '\uff19') {
                sb.append((char)(s.charAt(c.index) - 65296 + 48));
                ++c.index;
                continue;
            }
            sb.append(s.charAt(c.index));
            ++c.index;
        }
        return ZK2R.convertRoman(sb.toString());
    }

    public static String convertLatinForAddress(String s) {
        String val = ZK2R.convertLatinForAddr(s);
        if (val.length() <= 1) {
            return val;
        }
        val = val.substring(0, 1).toUpperCase() + val.substring(1);
        return val;
    }

    static class Cursor {
        int index = 0;

        Cursor() {
        }
    }
}

