/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.convert;

import org.infodb.commons.convert.CTable;

public class H2Z {
    private static char conv(char c) {
        if (c >= '0' && c <= '9') {
            return (char)(c - 48 + 65296);
        }
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65345);
        }
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - 65 + 65313);
        }
        if (c >= CTable.hankaku_firstch && c <= CTable.hankaku_lastch) {
            return CTable.zenkaku[c - CTable.hankaku_firstch];
        }
        return c;
    }

    private static char mergeChar(char c1, char c2) {
        if (c2 == '\uff9e') {
            if ("\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) >= 0) {
                switch (c1) {
                    case '\uff76': {
                        return '\u30ac';
                    }
                    case '\uff77': {
                        return '\u30ae';
                    }
                    case '\uff78': {
                        return '\u30b0';
                    }
                    case '\uff79': {
                        return '\u30b2';
                    }
                    case '\uff7a': {
                        return '\u30b4';
                    }
                    case '\uff7b': {
                        return '\u30b6';
                    }
                    case '\uff7c': {
                        return '\u30b8';
                    }
                    case '\uff7d': {
                        return '\u30ba';
                    }
                    case '\uff7e': {
                        return '\u30bc';
                    }
                    case '\uff7f': {
                        return '\u30be';
                    }
                    case '\uff80': {
                        return '\u30c0';
                    }
                    case '\uff81': {
                        return '\u30c2';
                    }
                    case '\uff82': {
                        return '\u30c5';
                    }
                    case '\uff83': {
                        return '\u30c7';
                    }
                    case '\uff84': {
                        return '\u30c9';
                    }
                    case '\uff8a': {
                        return '\u30d0';
                    }
                    case '\uff8b': {
                        return '\u30d3';
                    }
                    case '\uff8c': {
                        return '\u30d6';
                    }
                    case '\uff8d': {
                        return '\u30d9';
                    }
                    case '\uff8e': {
                        return '\u30dc';
                    }
                }
            }
        } else if (c2 == '\uff9f' && "\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) >= 0) {
            switch (c1) {
                case '\uff8a': {
                    return '\u30d1';
                }
                case '\uff8b': {
                    return '\u30d4';
                }
                case '\uff8c': {
                    return '\u30d7';
                }
                case '\uff8d': {
                    return '\u30da';
                }
                case '\uff8e': {
                    return '\u30dd';
                }
            }
        }
        return c1;
    }

    public static String convert(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return String.valueOf(H2Z.conv(s.charAt(0)));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length() - 1; ++i) {
            char c2;
            char c1 = s.charAt(i);
            char ch = H2Z.mergeChar(c1, c2 = s.charAt(i + 1));
            if (ch != c1) {
                sb.append(ch);
                if (++i == s.length() - 2) {
                    c2 = s.charAt(i + 1);
                }
            } else {
                ch = H2Z.conv(c1);
                if (ch != c1) {
                    sb.append(ch);
                } else {
                    sb.append(c1);
                }
            }
            if (i != s.length() - 2) continue;
            ch = H2Z.conv(c2);
            if (ch != c2) {
                sb.append(ch);
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }
}

