/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xssf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.infodb.commons.xml.Transformer;
import org.infodb.commons.xssf.Sheet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XLSXTemplate {
    private static final String WORKBOOK = "xl/workbook.xml";
    private String templateName;
    private Map<String, Sheet> mapSheets = new HashMap<String, Sheet>();
    private Map<String, String> mapNames = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String templateName) throws IOException, SAXException {
        this.templateName = templateName;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            fis = new FileInputStream(templateName);
            zis = new ZipInputStream(fis);
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(WORKBOOK)) continue;
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(new ReaderHandler());
                reader.parse(new InputSource(new NotCloseInputStream(zis)));
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void addSheetName(String name, String path) {
        this.mapNames.put(name, path);
    }

    public void addReplaceSheet(Sheet sheet) {
        String path = this.mapNames.get(sheet.getSheetName());
        if (path == null) {
            return;
        }
        this.mapSheets.put(path, sheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(OutputStream os) throws IOException, SAXException, TransformerException {
        ZipOutputStream zos = new ZipOutputStream(os);
        zos.setLevel(9);
        FileInputStream fis = null;
        try {
            ZipEntry ze;
            fis = new FileInputStream(this.templateName);
            ZipInputStream zis = new ZipInputStream(fis);
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().equals(WORKBOOK)) {
                    ZipEntry z = new ZipEntry(WORKBOOK);
                    zos.putNextEntry(z);
                    Transformer trans = new Transformer();
                    trans.setOutputProperty("method", "xml");
                    trans.addFilter(new WriteHandler());
                    trans.setResult(new StreamResult(zos));
                    trans.execute(new InputSource(new NotCloseInputStream(zis)));
                    zos.closeEntry();
                    continue;
                }
                Sheet sheet = this.mapSheets.get(ze.getName());
                ZipEntry z = new ZipEntry(ze.getName());
                zos.putNextEntry(z);
                if (sheet != null) {
                    sheet.write(zos);
                } else {
                    int len;
                    byte[] buff = new byte[1024];
                    while ((len = zis.read(buff, 0, buff.length)) > 0) {
                        zos.write(buff, 0, len);
                    }
                }
                zos.closeEntry();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (zos != null) {
                zos.close();
            }
        }
    }

    private class NotCloseInputStream
    extends InputStream {
        private InputStream is;

        public NotCloseInputStream(InputStream is) {
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class WriteHandler
    extends XMLFilterImpl {
        private WriteHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("calcPr")) {
                AttributesImpl a = new AttributesImpl();
                a.addAttribute("", "calcCompleted", "calcCompleted", "CDATA", "0");
                super.startElement(uri, localName, qName, a);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        }
    }

    private class ReaderHandler
    extends DefaultHandler {
        private ReaderHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("sheet")) {
                String name = atts.getValue("name");
                String id = atts.getValue("sheetId");
                String path = "xl/worksheets/sheet" + id + ".xml";
                XLSXTemplate.this.addSheetName(name, path);
            }
            super.startElement(uri, localName, qName, atts);
        }
    }
}

