/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.infodb.commons.db.JDBCWrapper;

public class JDBCSupport
implements JDBCWrapper {
    private static JDBCWrapper wrapper;
    private static DateFormat df;

    public static void registClass(JDBCWrapper jw) {
        wrapper = jw;
    }

    public static Blob createBlob(Connection conn) throws SQLException {
        return JDBCSupport.getInstance().createBLOB(conn);
    }

    public static Clob createClob(Connection conn) throws SQLException {
        return JDBCSupport.getInstance().createCLOB(conn);
    }

    private static JDBCWrapper getInstance() {
        if (wrapper == null) {
            wrapper = new JDBCSupport();
        }
        return wrapper;
    }

    public static void setDateFormat(DateFormat format) {
        df = format;
    }

    public static String dateFormat(Date dt) {
        return df.format(dt);
    }

    public static boolean isDateFormat() {
        return df != null;
    }

    @Override
    public Blob createBLOB(Connection conn) throws SQLException {
        return conn.createBlob();
    }

    @Override
    public Clob createCLOB(Connection conn) throws SQLException {
        return conn.createClob();
    }

    static {
        df = null;
    }
}

