/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.lang.StringEscapeUtils;
import org.infodb.commons.db.JDBCSupport;
import org.infodb.commons.xml.Parser;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlResultSet
implements XmlBuilder {
    private ResultSet rs;
    private String namespace = "";
    private String data = "data";
    private String row = "row";
    private String tableName = null;
    private boolean withHeader = false;
    private Parser parser;

    public XmlResultSet(ResultSet r, String name, Parser parser) throws SAXException {
        this.rs = r;
        this.tableName = name;
        this.parser = parser;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public void setDataTag(String tag) {
        this.data = tag;
    }

    public void setRowTag(String tag) {
        this.row = tag;
    }

    public void setWithHeader(boolean flag) {
        this.withHeader = flag;
    }

    @Override
    public void buildXml(ContentHandler saxHandler) throws SAXException {
        try {
            ColInfo info;
            int i;
            ResultSetMetaData meta = this.rs.getMetaData();
            int column = meta.getColumnCount();
            ColInfo[] columnList = new ColInfo[column];
            for (int i2 = 1; i2 <= column; ++i2) {
                ColInfo info2 = new ColInfo();
                info2.name = meta.getColumnName(i2).toLowerCase();
                info2.colType = meta.getColumnType(i2);
                info2.colTypeName = meta.getColumnTypeName(i2);
                columnList[i2 - 1] = info2;
            }
            AttributesImpl dataAttrs = new AttributesImpl();
            if (this.tableName != null) {
                dataAttrs.addAttribute("", "name", "name", "CDATA", this.tableName);
            }
            saxHandler.startElement(this.namespace, this.data, this.data, dataAttrs);
            if (this.withHeader) {
                AttributesImpl attr = new AttributesImpl();
                saxHandler.startElement("", "columns", "columns", attr);
                for (i = 0; i < column; ++i) {
                    info = columnList[i];
                    AttributesImpl attrCol = new AttributesImpl();
                    attrCol.addAttribute("", "type", "type", "CDATA", info.colTypeName);
                    saxHandler.startElement("", "column", "column", attrCol);
                    char[] chars = StringEscapeUtils.unescapeXml((String)info.name).toCharArray();
                    saxHandler.characters(chars, 0, chars.length);
                    saxHandler.endElement("", "column", "column");
                }
                saxHandler.endElement("", "columns", "columns");
            }
            while (this.rs.next()) {
                AttributesImpl rowAttrs = new AttributesImpl();
                saxHandler.startElement(this.namespace, this.row, this.row, rowAttrs);
                for (i = 1; i <= column; ++i) {
                    info = columnList[i - 1];
                    if (info.colType == 2005) {
                        this.parser.reset();
                        Clob clob = this.rs.getClob(i);
                        if (clob == null) continue;
                        this.parser.parse(clob.getCharacterStream());
                        XmlBuilder builder = (XmlBuilder)((Object)this.parser.getRootElement());
                        builder.buildXml(saxHandler);
                        continue;
                    }
                    AttributesImpl colAttrs = new AttributesImpl();
                    saxHandler.startElement(this.namespace, info.name, info.name, colAttrs);
                    String value = null;
                    if (info.colType == 91) {
                        if (!JDBCSupport.isDateFormat()) {
                            value = this.rs.getString(i);
                        } else {
                            Timestamp ts = this.rs.getTimestamp(i);
                            if (ts != null) {
                                value = JDBCSupport.dateFormat(ts);
                            }
                        }
                    } else {
                        value = this.rs.getString(i);
                    }
                    if (value != null) {
                        char[] chars = StringEscapeUtils.unescapeXml((String)value).toCharArray();
                        saxHandler.characters(chars, 0, chars.length);
                    }
                    saxHandler.endElement(this.namespace, info.name, info.name);
                }
                saxHandler.endElement(this.namespace, this.row, this.row);
            }
            saxHandler.endElement(this.namespace, this.data, this.data);
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    private class ColInfo {
        public String name;
        public int colType;
        public String colTypeName;

        private ColInfo() {
        }
    }
}

