/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.infodb.commons.db.SQLLog;

public class SQLProcedure {
    private Connection conn;
    private CallableStatement stmt;
    private boolean needClose;
    private String sql;
    private ArrayList<Object> params;

    public SQLProcedure(Connection c) {
        this.conn = c;
        this.needClose = true;
        this.params = new ArrayList();
    }

    public SQLProcedure(Connection c, boolean close) {
        this.conn = c;
        this.needClose = close;
        this.params = new ArrayList();
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.needClose) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void prepare(String sp) throws SQLException {
        this.sql = sp;
    }

    public void addParameter(Object obj) {
        this.params.add(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException {
        long handler = SQLLog.sqllog(this.sql);
        this.stmt = this.conn.prepareCall(this.sql);
        int index = 1;
        for (Object obj : this.params) {
            this.stmt.setObject(index, obj);
            SQLLog.paramlog(index, obj.toString());
            ++index;
        }
        try {
            this.stmt.execute();
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        long handler = SQLLog.sqllog("commit");
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        long handler = SQLLog.sqllog("rollback");
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }
}

