/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.infodb.commons.db.JDBCSupport;
import org.infodb.commons.xml.ThroughHandler;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResultSet
implements XmlBuilder {
    private ResultSet rs;
    private String namespace = "";
    private String data = "data";
    private String row = "row";
    private String tableName = null;
    private SAXParser parser;

    public XmlResultSet(ResultSet r, String name) throws SAXException {
        this.rs = r;
        this.tableName = name;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public void setDataTag(String tag) {
        this.data = tag;
    }

    public void setRowTag(String tag) {
        this.row = tag;
    }

    @Override
    public void buildXml(ContentHandler saxHandler) throws SAXException {
        try {
            ResultSetMetaData meta = this.rs.getMetaData();
            int column = meta.getColumnCount();
            ColInfo[] columnList = new ColInfo[column];
            for (int i = 1; i <= column; ++i) {
                ColInfo info = new ColInfo();
                info.name = meta.getColumnName(i).toLowerCase();
                info.colType = meta.getColumnType(i);
                columnList[i - 1] = info;
            }
            AttributesImpl dataAttrs = new AttributesImpl();
            if (this.tableName != null) {
                dataAttrs.addAttribute("", "name", "name", "CDATA", this.tableName);
            }
            saxHandler.startElement(this.namespace, this.data, this.data, dataAttrs);
            while (this.rs.next()) {
                AttributesImpl rowAttrs = new AttributesImpl();
                saxHandler.startElement(this.namespace, this.row, this.row, rowAttrs);
                for (int i = 1; i <= column; ++i) {
                    ColInfo info = columnList[i - 1];
                    if (info.colType == 2005) {
                        Clob clob = this.rs.getClob(i);
                        if (clob == null) continue;
                        this.parser.parse(new InputSource(clob.getCharacterStream()), (DefaultHandler)new ThroughHandler(saxHandler));
                        continue;
                    }
                    AttributesImpl colAttrs = new AttributesImpl();
                    saxHandler.startElement(this.namespace, info.name, info.name, colAttrs);
                    String value = null;
                    if (info.colType == 91) {
                        if (!JDBCSupport.isDateFormat()) {
                            value = this.rs.getString(i);
                        } else {
                            Timestamp ts = this.rs.getTimestamp(i);
                            if (ts != null) {
                                value = JDBCSupport.dateFormat(ts);
                            }
                        }
                    } else {
                        value = this.rs.getString(i);
                    }
                    if (value != null) {
                        char[] chars = value.toCharArray();
                        saxHandler.characters(chars, 0, chars.length);
                    }
                    saxHandler.endElement(this.namespace, info.name, info.name);
                }
                saxHandler.endElement(this.namespace, this.row, this.row);
            }
            saxHandler.endElement(this.namespace, this.data, this.data);
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    private class ColInfo {
        public String name;
        public int colType;

        private ColInfo() {
        }
    }
}

