/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.infodb.commons.db.JDBCSupport;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResultSet
extends DefaultHandler
implements XmlBuilder {
    private ResultSet rs;
    private String namespace = "";
    private String data = "data";
    private String row = "row";
    private String tableName = null;
    private SAXParser parser;
    private ContentHandler contentHandler;

    public XmlResultSet(ResultSet r, String name) throws SAXException {
        this.rs = r;
        this.tableName = name;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public void setDataTag(String tag) {
        this.data = tag;
    }

    public void setRowTag(String tag) {
        this.row = tag;
    }

    @Override
    public void buildXml(ContentHandler saxHandler) throws SAXException {
        this.contentHandler = saxHandler;
        try {
            ResultSetMetaData meta = this.rs.getMetaData();
            int column = meta.getColumnCount();
            ColInfo[] columnList = new ColInfo[column];
            for (int i = 1; i <= column; ++i) {
                ColInfo info = new ColInfo();
                info.name = meta.getColumnName(i).toLowerCase();
                info.colType = meta.getColumnType(i);
                columnList[i - 1] = info;
            }
            AttributesImpl dataAttrs = new AttributesImpl();
            if (this.tableName != null) {
                dataAttrs.addAttribute("", "name", "name", "CDATA", this.tableName);
            }
            saxHandler.startElement(this.namespace, this.data, this.data, dataAttrs);
            while (this.rs.next()) {
                AttributesImpl rowAttrs = new AttributesImpl();
                saxHandler.startElement(this.namespace, this.row, this.row, rowAttrs);
                for (int i = 1; i <= column; ++i) {
                    ColInfo info = columnList[i - 1];
                    if (info.colType == 2005) {
                        Clob clob = this.rs.getClob(i);
                        if (clob == null) continue;
                        this.parser.parse(new InputSource(clob.getCharacterStream()), (DefaultHandler)this);
                        continue;
                    }
                    AttributesImpl colAttrs = new AttributesImpl();
                    saxHandler.startElement(this.namespace, info.name, info.name, colAttrs);
                    String value = null;
                    if (info.colType == 91) {
                        if (!JDBCSupport.isDateFormat()) {
                            value = this.rs.getString(i);
                        } else {
                            Timestamp ts = this.rs.getTimestamp(i);
                            if (ts != null) {
                                value = JDBCSupport.dateFormat(ts);
                            }
                        }
                    } else {
                        value = this.rs.getString(i);
                    }
                    if (value != null) {
                        char[] chars = value.toCharArray();
                        saxHandler.characters(chars, 0, chars.length);
                    }
                    saxHandler.endElement(this.namespace, info.name, info.name);
                }
                saxHandler.endElement(this.namespace, this.row, this.row);
            }
            saxHandler.endElement(this.namespace, this.data, this.data);
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        } else {
            super.endDocument();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, localName, qName);
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        } else {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        } else {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        } else {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        } else {
            super.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        } else {
            super.skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        } else {
            super.startDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, localName, qName, attributes);
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    private class ColInfo {
        public String name;
        public int colType;

        private ColInfo() {
        }
    }
}

