// $Id: CHttpHeaderTask.cc,v 1.7 2003/05/10 06:46:50 ta_muto Exp $

#include <views/CHttpHeaderTask.h>
#include <CWaxLibs.h>

wax::CHttpHeaderTask::CHttpHeaderTask()
{
	name = NULL;
	value = NULL;
}

wax::CHttpHeaderTask::CHttpHeaderTask(const xmlChar* initName, const xmlChar* initValue)
{
	name = xmlStrdup(initName);
	value = xmlStrdup(initValue);
}

wax::CHttpHeaderTask::~CHttpHeaderTask()
{
	if(name != NULL)	xmlFree(name);
	if(value != NULL)	xmlFree(value);
}

bool wax::CHttpHeaderTask::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	name = xmlGetProp(cur, (const xmlChar*)"name");
	if(name == NULL) {
		IError::message(ERR_ATTRIBUTE, "%s::name", cur->name);
		return false;
	}
	xmlNsPtr ns = xmlSearchNsByHref(runenv->getDocPtr(), cur, CEnvironment::WAX);
	return CWaxLibs::parseAsContent(runenv, cur->children, ns, value);
}

bool wax::CHttpHeaderTask::execute()
{
	return true;
}

void wax::CHttpHeaderTask::output(IWriter* writer)
{
	writer->writeStr(name);
	writer->writeStr(": ");
	writer->writeStr(value);
	writer->writeStr("\n");
}
