// $Id: CCallTemplateTask.cc,v 1.12 2003/09/17 02:57:53 ta_muto Exp $

#include <views/CCallTemplateTask.h>
#include <CScriptlet.h>
#include <CWaxLibs.h>

wax::CCallTemplateTask::CCallTemplateTask()
{
	calledScript = NULL;
	disp = NULL;
}

wax::CCallTemplateTask::~CCallTemplateTask()
{
	if(calledScript != NULL)	delete calledScript;
	if(disp != NULL)	delete disp;
}

bool wax::CCallTemplateTask::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	calledScript = new CEnvironment(runenv->getRequest(), false, runenv->getPoint());
	if(calledScript != NULL) {
		CXmlStr href(xmlGetProp(cur, (const xmlChar*) "href"));
		if(href.value() == NULL) {
			xmlNsPtr ns = xmlSearchNsByHref(runenv->getDocPtr(), cur, CEnvironment::WAX);
			href.replace(CWaxLibs::parseLocation(runenv, cur, ns, calledScript->getPoint()->getParameters()));
			CWaxLibs::matchParameter(runenv, calledScript->getPoint()->getParameters());
			if(href.value() == NULL) {
				IError::message(ERR_ATTRIBUTE, "call-template::href");
				return false;
			}
		}
		CXmlStr path(runenv->makePath(href.value()));
		if(path.value() != NULL) {
			if(calledScript->prepare(path.value()) == true) {
				disp = CScriptlet::parse(calledScript);
				if(disp == NULL)	return false;
				return true;
			}
		}
	}
	IError::message(ERR_OUTOFMEMORY, LOCATION);
	return false;
}

bool wax::CCallTemplateTask::execute()
{
	return disp->execute();
}

void wax::CCallTemplateTask::output(IWriter* writer)
{
	disp->output(writer);
}
