// $Id: error.cc,v 1.10 2003/05/10 06:46:48 ta_muto Exp $

#include <common.h>
#include <collection.h>

static char* errorString[] = {
	"No Errors.",
	"Out of memory.",
	"Parse error.",
	"Document of the wrong type, info-dbWax namespace not found!",
	"Empty document.",
	"Since the PATH_TRANSLATED environment variable is not supported, it cannot perform.",
	"Creation of dynamic contents went wrong.",
	"The output command suitable for a target browser was not found.",
	"The unjust attribute was detected.",
	"The unjust element was detected.",
	"Processing of XSLT went wrong.",
	"The file did not exist.",
	"DOCUMENT_ROOT is not specified.",
	"It cannot overwrite.",
	"Failed to save a file.",
	"Cannot evaluate the XPath location path in the given context.",
	"POSTED DATA is invalid.",
	"The size of parameter array was exceeded.",
	"Contains both quote and double-quotes !",
	"The Defined value was not found.",
	"Since application data is already used, continuation is impossible.",
	"Since PATH_TRANSLATED is not specified, it does not operate.",
	"There is no data to output.",
	"The node-set was not found by the specified XPath expression.",
	"The Connect directive was not specified.",
	"The xupdate:attribute was specified although a parent node was NULL. The definition of waxml is wrong.",
	"It is necessary to set and specify XML source and XSLT source.",
	"A success directive needs to specify as a redirection place.",
	"The waxml file which used the Template directive was requested directly. Processing is not permitted.",
	"The name to rename is not specified.",
	"The specified parameter was not found.",
} ;

wax::IError* handler = NULL;

void errorHandler(void *, const char *msg, ...)
{
	char buffer[256];
    va_list args;
    va_start(args, msg);
    vsprintf(buffer, msg, args);
    va_end(args);
	handler->write(-1, buffer, NULL);
}

void wax::IError::registerErrorHandler(IError* eh)
{
	handler = eh;
	xmlSetGenericErrorFunc(NULL, errorHandler);
	xsltSetGenericErrorFunc(NULL, errorHandler);
}

void wax::IError::unregisterErrorHandler()
{
	xmlSetGenericErrorFunc(NULL, NULL);
	xsltSetGenericErrorFunc(NULL, NULL);
}

void wax::IError::message(int errorCode)
{
	handler->write(errorCode, errorString[errorCode], NULL);
}

void wax::IError::message(int errorCode, const char* msg, ...)
{
	char buffer[1024];
    va_list args;
    va_start(args, msg);
    vsprintf(buffer, msg, args);
    va_end(args);

	handler->write(errorCode, errorString[errorCode], buffer);
}

void wax::IError::message(int errorCode, const xmlChar* msg, ...)
{
	char buffer[1024];
    va_list args;
    va_start(args, msg);
    vsprintf(buffer, (const char*) msg, args);
    va_end(args);

	handler->write(errorCode, errorString[errorCode], buffer);
}

void wax::IError::outputError()
{
	handler->flush();
}
