// $Id: CTemplate.h,v 1.9 2003/05/10 06:46:44 ta_muto Exp $
// Template functional class. It is used from a call-template directive or a template directive.

#ifndef __wax_CTemplate_h
#define __wax_CTemplate_h

#include <common.h>
#include <collection.h>
#include <IDispatch.h>
#include <CEnvironment.h>

namespace wax {
	class CTemplate : public IDispatch {
		CCollection headList;
		CCollection taskList;
		xmlNodePtr startNode;
	public:
		CTemplate();
		~CTemplate();
		
		bool parse(CEnvironment* runenv, xmlNodePtr cur);
		bool execute();
		void output(IWriter* writer);
	private:
		bool parseInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns);

		void outputInternal(IWriter* writer, xmlNodePtr cur);
		void outputTag(IWriter* writer, xmlNodePtr cur);
		void outputNsList(IWriter* writer, xmlNsPtr nsDef);
		void outputAttrList(IWriter* writer, xmlAttrPtr attr);
	} ;
}

#endif
