// $Id: errorCode.h,v 1.9 2003/05/10 06:46:42 ta_muto Exp $
// Error Code List.

#ifndef __wax_errorCode_h
#define __wax_errorCode_h

namespace wax {
	enum EnumErrorCode {
		ERR_OUTOFMEMORY = 1,	// out of memoty.
		ERR_PARSE,				// parse error.
		ERR_NAMESPACE,			// document of the wrong type, info-dbWax namespace not found! 
		ERR_EMPTYDOCUMENT,		// empty document.
		ERR_NOTSUPPORTED,		// not supported.
		ERR_EXECUTE,			// Execution Error.
		ERR_NOTMUTCH,			// not found mutch output element.
		ERR_ATTRIBUTE,			// attribute is invalid.
		ERR_ELEMENT,			// element is invalid.
		ERR_TRANSLATE,			// failed to translate.
		ERR_EXISTFILE,			// the file is not exist.
		ERR_DOCUMENTROOT,		// DOCUMENT_ROOT is not specified.
		ERR_OVERWRITE,			// It cannot overwrite.
		ERR_FAILEDSAVE,			// failed to save a file.
		ERR_XPATH,				// cannot evaluate the XPath location path in the given context.
		ERR_POSTEDDATA,			// POSTED DATA is invalid.
		ERR_OVERMAXPARAMS,		// The size of parameter array was exceeded.
		ERR_BOTHQUOTE,			// contains both quote and double-quotes !
		ERR_NOTDEFINE,			// The defined value was not found.
		ERR_ALREADYUSED,		// Since application data is already used, continuation is impossible.
		ERR_PATHTRANSLATED,		// Since PATH_TRANSLATED is not specified, it does not operate.
		ERR_WRITEDATA,			// There is no data to output.
		ERR_FOUNDNODESET,		// The node-set was not found by the specified XPath expression.
		ERR_CONNECT,			// The Connect directive was not specified.
		ERR_XUPATTR,			// The xupdate:attribute was specified although a parent node was NULL. The definition of waxml is wrong.
		ERR_PARSETRANSLATE,		// It is necessary to set and specify XML source and XSLT source.
		ERR_DIRECTION,			// A success directive needs to specify as a redirection place.
		ERR_NOCALLTEMPLATE,		// The waxml file which used the Template directive was requested directly. Processing is not permitted.
		ERR_RENAMETO,			// The name to rename is not specified.
		ERR_NOTFOUNDPARAM,		// The specified parameter was not found.
	} ;

	#define LOCATION	"%s(%d)", __FILE__, __LINE__

	class IError {
	public:
		virtual void write(int errorCode, const char* message, const char* remarks) = 0;
		virtual void flush() = 0;
	public:
		static void registerErrorHandler(IError* eh);
		static void unregisterErrorHandler();

		static void message(int errorCode);
		static void message(int errorCode, const char* msg, ...);
		static void message(int errorCode, const xmlChar* msg, ...);

		static void outputError();
	} ;
}

#endif
