// $Id: IWriter.h,v 1.5 2003/05/30 05:27:11 ta_muto Exp $
// Such a class is needed in order that some APIs. such as Apache, may not use STDOUT.

#ifndef __wax_IWriter_h
#define __wax_IWriter_h

#include <common.h>

namespace wax {
	class IWriter {
	public:
		virtual ~IWriter();
		virtual void write(const char* buffer, int size) = 0;
#if LE==1
		virtual FILE* getFP() = 0;
#endif
		void writeStr(const xmlChar* str) { write((const char*) str, xmlStrlen(str)); }
		void writeStr(const char* str) { write(str, strlen(str)); }
		bool writeQuote(const xmlChar* str) { return writeQuote((const char*) str); }
		bool writeQuote(const char* str);
		void writeHTMLEncodeChar(const char* str);
	} ;
}

#endif
