// $Id: CXmlLibs.h,v 1.9 2003/05/10 06:46:41 ta_muto Exp $
// XML Library Class

#ifndef __wax_CXmlLibs_h
#define __wax_CXmlLibs_h

#include <common.h>
#include <IReader.h>

namespace wax {
	class CXmlLibs {
	public:
		static xmlDocPtr read(IReader* reader, bool recordError = true);
		
		static xmlChar* getDateTime(const xmlChar* dateFormat);
	} ;

	class CXPathMacro {
		xmlXPathContextPtr xpctx;
		xmlXPathObjectPtr eval;
	public:
		CXPathMacro(xmlDocPtr doc);
		~CXPathMacro();
		
		void registerVariable(const xmlChar* name, const xmlChar* uri);
		
		void registerNs(const xmlChar* prefix, const xmlChar* uri);
		bool evaluate(const xmlChar* xpath);
		
		xmlChar* getString();
		
		int getNodeCount();
		xmlNodePtr getNode(int index);
	} ;
}

#endif
