// $Id: CParameterItem.h,v 1.1 2003/08/26 03:57:54 ta_muto Exp $
//

#ifndef __CParameterItem_h
#define __CParameterItem_h

#include <common.h>
#include <collection.h>

namespace wax {
	class CParameterItem : public ICursor {
		xmlChar* name;
		xmlChar* value;
		xmlChar* origin;
		bool fixed;
	public:
		CParameterItem(const xmlChar* initName, const xmlChar* initValue, bool initFixed);
		~CParameterItem();
		
		const xmlChar* getName() const { return name; }
		const xmlChar* getValue() const { return value; }
		const xmlChar* getOriginalValue() const { return origin; }
		bool getFixed() const { return fixed; }
		
		void setOriginalValue(const xmlChar* newValue);
	private:
		xmlChar* quoteStrdup(const xmlChar* newValue);
	} ;
}

#endif
