// $Id: CEnvironment.h,v 1.13 2003/08/26 03:57:54 ta_muto Exp $
// The class which manages the environment which a script performs.

#ifndef __wax_CEnvironment_h
#define __wax_CEnvironment_h

#include <common.h>
#include <IReader.h>
#include <CRequest.h>
#include <CStackPoint.h>

namespace wax {
	class CEnvironment {
		xmlChar* scriptPath;
		
		xmlDocPtr doc;
		xmlNodePtr root;
		
		CRequest* request;
		CStackPoint point;
		bool startFlag;
	public:
		CEnvironment(CRequest* req, bool initFlag = true, CStackPoint* before = NULL);
		~CEnvironment();
		
		xmlDocPtr getDocPtr() const { return doc; }
		xmlNodePtr getRootNodePtr() const { return root; }
		
		CRequest* getRequest() const { return request; }
		CStackPoint* getPoint() { return &point; }
		bool getStartFlag() const { return startFlag; }
		const xmlChar* getScriptPath() const { return scriptPath; }

		IReader* getReader(const xmlChar* href);
		xmlChar* makePath(const xmlChar* path);
		
		bool prepare(const xmlChar* targetPath);
	public:
		static const xmlChar* WAX;
		static const xmlChar* XUPDATE;
		static const xmlChar* XMLSCHEMA;
	} ;
}

#endif
