// $Id: IXmlDB.h,v 1.8 2003/05/10 06:46:47 ta_muto Exp $
// The abstract class for using XML like a database.

#ifndef __wax_IXmlDB_h
#define __wax_IXmlDB_h

#include <common.h>
#include <collection.h>

namespace wax {
	class IXmlDB : public ICursor {
	public:
		virtual ~IXmlDB();
		
		virtual bool open(const xmlChar* connect) = 0;
		virtual void registerVariable(const xmlChar* name, const xmlChar* value) = 0;
		
		virtual bool flush() = 0;
		virtual void close() = 0;

		virtual bool isMatch(const xmlChar* connect) = 0;
		virtual bool select(const xmlChar* xpath) = 0;

		virtual bool insertAfter(xmlDocPtr doc) = 0;
		virtual bool insertBefore(xmlDocPtr doc) = 0;
		virtual bool append(xmlDocPtr doc, const xmlChar* child) = 0;
		virtual bool rename(const xmlChar* name) = 0;
		virtual bool updateContent(xmlDocPtr doc) = 0;
		virtual bool remove() = 0;
	} ;
}

#endif
