// $Id: IAction.h,v 1.5 2003/05/10 06:46:47 ta_muto Exp $
// Action Abstract Class

#ifndef __wax_IAction_h
#define __wax_IAction_h

#include <common.h>
#include <collection.h>
#include <CEnvironment.h>
#include <xupdate/CXmlSession.h>

namespace wax {
	class IAction : public ICursor {
	public:
		virtual ~IAction();
	
		virtual bool parse(CEnvironment* runenv, xmlNodePtr cur) = 0;
		virtual bool execute(CXmlSession* session) = 0;
		
		void setVariables(CCollection& initVars) { vars.share(initVars); }
	protected:
		CCollection vars;
	} ;
}

#endif
