// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib.shaders;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

/**
  2D-like Shader. A plane always face camera.
**/

class Shader2D extends hxsl.Shader {
  static public var id:String = "2DShader";
  static var SRC = {
    var input : {
      pos:Float3,
    };
    function vertex( mpos:M44,
                     mproj:M44,
                     origin:Float4 ) {
      var p4:Float4 = [ input.pos.x, input.pos.y, input.pos.z, 0.0 ];
      out = origin.xyzw * mpos * mproj + p4;
    }
    function fragment( color:Float3,
                       alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  }
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      or:Vector3D,
                                      cl:Vector3D,
                                      a:Float ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.origin = or;
    this.color = cl;
    this.alpha = a;
  }
}
