// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.display3D.Context3D;

import flash.Vector;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

import tinylib.Point3D;
import tinylib.Polygon;

/**
  A general polygon
**/

class WMPolygon extends WMObjBase {
  private var myType:String; // original object type

  @:isVar public var dashed( get, set ):Int;
    public function get_dashed():Int { return( dashed ); }
    public function set_dashed( i:Int ):Int {
      dashed = i;
      return( dashed );
    }

  @:isVar public var myIndex( get, set ):Int;
    public function get_myIndex():Int { return( myIndex ); }
    public function set_myIndex( i:Int ):Int {
      myIndex = i;
      return( myIndex );
    }
  @:isVar public var numIndex( get, set ):Int;
    public function get_numIndex():Int { return( numIndex ); }
    public function set_numIndex( i:Int ):Int {
      numIndex = i;
      return( numIndex );
    }
  @:isVar public var size( get, set ):Int;
    public function get_size():Int { return( size ); }
    public function set_size( i:Int ):Int {
      size = i;
      return( size );
    }

  private var ibuf:Vector< UInt >;
  private var vbuf:Vector< Float >;

  // #####################################################################

  public function new( ?r:Float = 1.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 3,
                       ?ag:Float = 0.35,
                       ?d:Float = 0.7,
                       ?sp:Float = 0.8,
                       ?gl:Float = 20.0,
                       ?sh:String = "Phong" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
    dashed = 0;
    myIndex = 0;
    numIndex = 0;
    size = 0;
  }

  public override function loadFromXml( x:Xml,
                                        ?def:WMDefaults = null ):Void {
    super.loadFromXml( x );
    if ( !x.exists( "mi" ) || !x.exists( "ni" ) || !x.exists( "sz" ) ) {
      trace( "mi, ni, and s attributes are neccessary for POLYGON" );
      return;
    }
    myIndex = Std.parseInt( x.get( "mi" ) );
    numIndex = Std.parseInt( x.get( "ni" ) );
    size = Std.parseInt( x.get( "sz" ) );
    if ( x.exists( "type" ) ) myType = x.get( "type" );
    // for bond
    var strs = [ "dash", "dashed" ];
    for ( str in strs ) {
      if ( x.exists( str ) ) dashed = Std.parseInt( x.get( str ) );
    }
    for ( elem in x.elementsNamed( "IBUF" ) ) {
      ibuf = new Vector< UInt >();
      var data = elem.firstChild().toString();
      var vals:Array< String > = WMBase.splitString( data );
      for ( v in vals ) {
        ibuf.push( Std.parseInt( v ) );
      }
    }
    for ( elem in x.elementsNamed( "VBUF" ) ) {
      vbuf = new Vector< Float >();
      var data = elem.firstChild().toString();
      var vals:Array< String > = WMBase.splitString( data );
      for ( v in vals ) {
        vbuf.push( Std.parseFloat( v ) );
      }
    }
  }

  // currently, WMLabel is not supported
  public function gen( c:Context3D,
                       ?is_dc_active:Bool ):Void {
    pregen();
    gen2( c, is_dc_active );
  }

  public function pregen() {
    _polygon = new Polygon();
    setShaderParams();
  }

  public function gen2( c:Context3D,
                        ?is_dc_active:Bool = false ) {
    _polygon.load( c, numIndex, ibuf, myIndex, size, vbuf,
                   shader, is_dc_active, color0, alpha );
    if ( myType == "WMBond" ) {
      if ( dashed != 0 ) {
        _polygon.createDashedDoubleColoredTexture( c, dashed, color0, color1 );
      } else if ( color0 != color1 ) {
        _polygon.createDoubleColoredTexture( c, color0, color1 );
      }
    } else if ( myType == "WMRibbon" ) {
      if ( color0 != color1 ) {
        _polygon.createGradientTexture( c, color0, color1 );
      }
    }
  }

  public function num():Int { return(0); }
  public function sumPos():Point3D { return( new Point3D( 0, 0, 0 ) ); }
  public function translate( p:Point3D ):Void {}
  public function absmax():Point3D { return( new Point3D( 0, 0, 0 ) ); }
  public function scaleCoord( scale:Float ):Void {}
  public override function getDataSize():Int { return( vbuf.length ); }
}
