// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package wmutil;

/**
 index of a cell in 3D
**/
class CellIndex {
  /**
   Generate list of adjacent cells used for generating cell-cell pairs.
   Note: this function returns 13 cells, not 26 cells.
  **/
  static public function adjCells():Array< CellIndex > {
    var ret:Array< CellIndex > = new Array< CellIndex >();
    ret.push( new CellIndex(  1,  0,  0 ) );
    ret.push( new CellIndex(  1, -1,  0 ) );
    ret.push( new CellIndex(  0, -1,  0 ) );
    ret.push( new CellIndex( -1, -1,  0 ) );
    ret.push( new CellIndex(  1,  1, -1 ) );
    ret.push( new CellIndex(  0,  1, -1 ) );
    ret.push( new CellIndex( -1,  1, -1 ) );
    ret.push( new CellIndex(  1,  0, -1 ) );
    ret.push( new CellIndex(  0,  0, -1 ) );
    ret.push( new CellIndex( -1,  0, -1 ) );
    ret.push( new CellIndex(  1, -1, -1 ) );
    ret.push( new CellIndex(  0, -1, -1 ) );
    ret.push( new CellIndex( -1, -1, -1 ) );
    return( ret );
  }

  // ################################################################

  /**
   index in x direction
  **/
  public var i:Int;
  /**
   index in y direction
  **/
  public var j:Int;
  /**
   index in z direction
  **/
  public var k:Int;
  /**
   ci: x direction
   cj: y direction
   ck: z direction
  **/
  public function new( ?ci:Int = 0,
                       ?cj:Int = 0,
                       ?ck:Int = 0 ) {
    i = ci;
    j = cj;
    k = ck;
  }
  /**
   generate clone of this CellIndex
  **/
  public function clone():CellIndex {
    return( new CellIndex( i, j, k ) );
  }
}
