// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib;

/**
  simple container class for vertex ids
**/

class TriFaceIDs {
  public var i( default, default ):UInt;
  public var j( default, default ):UInt;
  public var k( default, default ):UInt;

  // ####################################################

  public function new( ?a:UInt,
                       ?b:UInt,
                       ?c:UInt ) {
    clear();
    if ( a != null ) i = a;
    if ( b != null ) j = b;
    if ( c != null ) k = c;
  }

  public function clear():Void {
    i = j = k = 0;
  }

  public function clone():TriFaceIDs {
    return( new TriFaceIDs( i, j, k ) );
  }

  // simple check of ids
  public function isValid():Bool {
    if ( i == j || i == k || j == k ) return( false );
    return( true );
  }

  public function toString():String {
    return( "[ " + i + " " + j + " " + k + " ]" );
  }
}
