// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib;

/**
  A Face: container for a triangle and an uv coordinate of its vertexes
**/

class Face {
  /**
    index of vertexes
  **/
  @:isVar public var ids( get, set ):TriFaceIDs; // vertex ids
    /**
      getter of `ids`
    **/
    public function get_ids():TriFaceIDs { return( ids ); }
    /**
      setter of `ids`
    **/
    public function set_ids( i:TriFaceIDs ):TriFaceIDs {
      ids = i.clone();
      return( ids );
    }
  /**
    UV coordinate for vertex 0 of this face (triangle)
  **/
  @:isVar public var uv0( get, set ):UVCoord;
    /**
      getter of `uv0`
    **/
    public function get_uv0():UVCoord { return( uv0 ); }
    /**
      setter of `uv0`
    **/
    public function set_uv0( r:UVCoord ):UVCoord {
      uv0 = r.clone();
      return( uv0 );
    }
  /**
    UV coordinate for vertex 1 of this face (triangle)
  **/
  @:isVar public var uv1( get, set ):UVCoord;
    /**
      getter of `uv1`
    **/
    public function get_uv1():UVCoord { return( uv1 ); }
    /**
      setter of `uv1`
    **/
    public function set_uv1( r:UVCoord ):UVCoord {
      uv1 = r.clone();
      return( uv1 );
    }
  /**
    UV coordinate for vertex 2 of this face (triangle)
  **/
  @:isVar public var uv2( get, set ):UVCoord;
    /**
      getter of `uv2`
    **/
    public function get_uv2():UVCoord { return( uv2 ); }
    /**
      setter of `uv2`
    **/
    public function set_uv2( r:UVCoord ):UVCoord {
      uv2 = r.clone();
      return( uv2 );
    }

  // ##################################################################

  /**
    Constructor.

    - i: vertex id 0 of the face
    - j: vertex id 1 of the face
    - k: vertex id 2 of the face
    - r0: UV coordinate of vertex id 0
    - r1: UV coordinate of vertex id 1
    - r2: UV coordinate of vertex id 2
  **/
  public function new( ?i:UInt,
                       ?j:UInt,
                       ?k:UInt,
                       ?r0:UVCoord,
                       ?r1:UVCoord,
                       ?r2:UVCoord ) {
    if ( i != null && j != null && k != null ) {
      ids = new TriFaceIDs( i, j, k );
    }
    if ( r0 != null ) uv0 = r0;
    if ( r1 != null ) uv1 = r1;
    if ( r2 != null ) uv2 = r2;
  }

  /**
    another setter of `ids`
  **/
  public function setID( i:UInt,
                         j:UInt,
                         k:UInt ):Void {
    ids = new TriFaceIDs( i, j, k );
  }
}
